/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.OpenDeclarationAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.StackTraceContentProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.StackTraceLabelProvider;

public class StackTraceViewer
extends TableViewer {
    OpenDeclarationAction openAction;
    CopyAction copyAction;

    public StackTraceViewer(Composite parent, IActionBars actionBars) {
        super(parent, 2);
        this.setContentProvider((IContentProvider)new StackTraceContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new StackTraceLabelProvider());
        this.createContextMenu(actionBars);
        this.addSelectionChangedListener(this.openAction);
        this.getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                StackTraceViewer.this.removeSelectionChangedListener(StackTraceViewer.this.copyAction);
            }

            public void focusGained(FocusEvent e) {
                StackTraceViewer.this.addSelectionChangedListener(StackTraceViewer.this.copyAction);
            }
        });
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                StackTraceViewer.this.openAction.run();
            }
        });
    }

    private void createContextMenu(IActionBars actionBars) {
        this.openAction = OpenDeclarationAction.createOpenDeclarationAction(actionBars);
        this.copyAction = CopyAction.createCopyAction(actionBars);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)StackTraceViewer.this.openAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)StackTraceViewer.this.copyAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }
}

