/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.fusesource.ide.jvmmonitor.core.cpu.ICallTreeNode;
import org.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import org.fusesource.ide.jvmmonitor.core.cpu.IThreadNode;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractLabelProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallTreeColumn;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages;

public class CallTreeLabelProvider
extends AbstractLabelProvider {
    private TreeViewer treeViewer;

    public CallTreeLabelProvider(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return this.getCallTreeColumnText(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(CallTreeColumn.CALL_TREE)) {
            return this.getCallTreeColumnImage(element);
        }
        if (columnIndex == this.getColumnIndex(CallTreeColumn.TIME_PERCENTAGE)) {
            return this.getTimeColumnImage(element);
        }
        if (columnIndex == this.getColumnIndex(CallTreeColumn.SELFTIME_PERCENTAGE)) {
            return this.getSelfTimeColumnImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (columnIndex == this.getColumnIndex(CallTreeColumn.CALL_TREE)) {
            text = this.getCallTreeColumnText(element);
        } else if (columnIndex == this.getColumnIndex(CallTreeColumn.TIME_MS)) {
            text = this.getTimeInMsColumnText(element);
        } else if (columnIndex == this.getColumnIndex(CallTreeColumn.TIME_PERCENTAGE)) {
            text = this.getTimeInPercentageColumnText(element);
        } else if (columnIndex == this.getColumnIndex(CallTreeColumn.SELFTIME_MS)) {
            text = this.getSelfTimeInMsColumnText(element);
        } else if (columnIndex == this.getColumnIndex(CallTreeColumn.SELFTIME_PERCENTAGE)) {
            text = this.getSelfTimeInPercentageColumnText(element);
        } else if (columnIndex == this.getColumnIndex(CallTreeColumn.COUNT)) {
            text = this.getCountColumnText(element);
        }
        return text;
    }

    public Font getFont(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(CallTreeColumn.CALL_TREE)) {
            return null;
        }
        return this.getmonospacedFont(this.treeViewer.getControl().getFont());
    }

    private String getCallTreeColumnText(Object element) {
        if (element instanceof IThreadNode) {
            if (((IThreadNode)element).hasChildren()) {
                return String.valueOf(Messages.threadLabel) + ' ' + ((IThreadNode)element).getName();
            }
        } else if (element instanceof ICallTreeNode) {
            return ((ICallTreeNode)element).getName();
        }
        return "";
    }

    private String getTimeInMsColumnText(Object element) {
        ICpuModel cpuModel = (ICpuModel)this.treeViewer.getInput();
        if (cpuModel == null) {
            return "";
        }
        int length = String.valueOf(cpuModel.getMaxTotalTime() * 1000L).length();
        int n = length = length > 10 ? 10 : length;
        if (element instanceof IThreadNode) {
            String milliseconds = this.getMillisecondsText(((IThreadNode)element).getTotalTime(), length);
            return milliseconds;
        }
        if (element instanceof ICallTreeNode) {
            long totalTime = ((ICallTreeNode)element).getTotalTime();
            return this.getMillisecondsText(totalTime, length);
        }
        return "";
    }

    private String getTimeInPercentageColumnText(Object element) {
        if (element instanceof IThreadNode) {
            return "100.0%";
        }
        if (element instanceof ICallTreeNode) {
            double percentage = ((ICallTreeNode)element).getTotalTimeInPercentage();
            return String.valueOf(String.format("%5.1f", percentage)) + "%";
        }
        return "";
    }

    private String getSelfTimeInMsColumnText(Object element) {
        ICpuModel cpuModel = (ICpuModel)this.treeViewer.getInput();
        if (cpuModel == null) {
            return "";
        }
        if (element instanceof ICallTreeNode) {
            long totalTime = ((ICallTreeNode)element).getSelfTime();
            int length = String.valueOf(cpuModel.getMaxSelfTime() * 1000L).length();
            length = length > 10 ? 10 : length;
            return this.getMillisecondsText(totalTime, length);
        }
        return "";
    }

    private String getSelfTimeInPercentageColumnText(Object element) {
        if (element instanceof ICallTreeNode) {
            double percentage = ((ICallTreeNode)element).getSelfTimeInPercentage();
            return String.valueOf(String.format("%5.1f", percentage)) + "%";
        }
        return "";
    }

    private String getCountColumnText(Object element) {
        ICpuModel cpuModel = (ICpuModel)this.treeViewer.getInput();
        if (cpuModel == null) {
            return "";
        }
        if (element instanceof ICallTreeNode) {
            int length = String.valueOf(cpuModel.getMaxInvocationCount()).length();
            return String.format("%" + length + "d", ((ICallTreeNode)element).getInvocationCount());
        }
        return "";
    }

    private Image getCallTreeColumnImage(Object element) {
        if (element instanceof IThreadNode) {
            if (((IThreadNode)element).hasChildren()) {
                return this.getThreadImage();
            }
        } else if (element instanceof ICallTreeNode) {
            return this.getMethodImage();
        }
        return null;
    }

    private Image getTimeColumnImage(Object element) {
        if (element instanceof IThreadNode) {
            return this.getPercentageImage(100.0);
        }
        if (element instanceof ICallTreeNode) {
            double percentage = ((ICallTreeNode)element).getTotalTimeInPercentage();
            return this.getPercentageImage(percentage);
        }
        return null;
    }

    private Image getSelfTimeColumnImage(Object element) {
        if (element instanceof ICallTreeNode) {
            double percentage = ((ICallTreeNode)element).getSelfTimeInPercentage();
            return this.getPercentageImage(percentage);
        }
        return null;
    }

    private int getColumnIndex(CallTreeColumn column) {
        Tree tree = this.treeViewer.getTree();
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

