/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.cpu.CpuModelEvent;
import org.fusesource.ide.jvmmonitor.core.cpu.ICallTreeNode;
import org.fusesource.ide.jvmmonitor.core.cpu.ICpuModelChangeListener;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractTabPage;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallTreeContentProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallTreeFilteredTree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CallTreeLabelProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.CpuSection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.ConfigureCpuProfilerAction;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class CallTreeTabPage
extends AbstractTabPage {
    CallTreeFilteredTree filteredTree;
    private Image callTreeImage;

    public CallTreeTabPage(CpuSection cpuSection, CTabFolder tabFolder) {
        super(cpuSection, tabFolder);
        Composite composite = new Composite((Composite)this.viewForm, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setBackground(Display.getDefault().getSystemColor(2));
        this.createCallTreeViewer(composite);
        this.viewForm.setContent((Control)composite);
        CTabItem tabItem = cpuSection.getWidgetFactory().createTabItem(tabFolder, 0);
        tabItem.setText(Messages.callTreeTabLabel);
        tabItem.setImage(this.getCallTreeImage());
        tabItem.setControl((Control)this);
        this.cpuModelChangeListener = new ICpuModelChangeListener(){

            public void modelChanged(CpuModelEvent event) {
                if (event.state == CpuModelEvent.CpuModelState.FocusedMethodChanged) {
                    CallTreeTabPage.this.refresh();
                }
            }
        };
    }

    @Override
    protected void setInput(IActiveJvm jvm) {
        super.setInput(jvm);
        this.filteredTree.getViewer().setInput((Object)jvm.getCpuProfiler().getCpuModel());
    }

    @Override
    protected void refresh() {
        if (!this.filteredTree.getViewer().getControl().isDisposed()) {
            this.filteredTree.getViewer().refresh();
            this.filteredTree.updateStatusLine((IStructuredSelection)this.filteredTree.getViewer().getSelection());
        }
        this.refreshContentDescription();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.callTreeImage != null) {
            this.callTreeImage.dispose();
        }
    }

    @Override
    protected List<AbstractFilteredTree> getFilteredTrees() {
        ArrayList<AbstractFilteredTree> trees = new ArrayList<AbstractFilteredTree>();
        trees.add(this.filteredTree);
        return trees;
    }

    private void createCallTreeViewer(Composite composite) {
        PropertySheet propertySheet = (PropertySheet)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.filteredTree = new CallTreeFilteredTree(composite, propertySheet.getViewSite().getActionBars()){

            @Override
            protected void addMenus(IMenuManager manager) {
                super.addMenus(manager);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ConfigureCpuProfilerAction(CallTreeTabPage.this.cpuSection));
            }
        };
        TreeViewer callTreeViewer = this.filteredTree.getViewer();
        callTreeViewer.setContentProvider((IContentProvider)new CallTreeContentProvider());
        callTreeViewer.setLabelProvider((IBaseLabelProvider)new CallTreeLabelProvider(callTreeViewer));
        callTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CallTreeTabPage.this.filteredTree.updateStatusLine((IStructuredSelection)event.getSelection());
            }
        });
    }

    private void refreshContentDescription() {
        if (this.jvm == null) {
            return;
        }
        ICallTreeNode focusedNode = this.jvm.getCpuProfiler().getCpuModel().getFocusTarget();
        StringBuilder description = new StringBuilder();
        if (focusedNode != null) {
            description.append(NLS.bind((String)Messages.focusTargetIndicator, (Object)focusedNode.getNonqualifiedName())).append(NLS.bind((String)Messages.threadIndicator, (Object)focusedNode.getThread()));
        }
        this.setContentDescription(description.toString());
    }

    private Image getCallTreeImage() {
        if (this.callTreeImage == null || this.callTreeImage.isDisposed()) {
            this.callTreeImage = Activator.getImageDescriptor("icons/full/obj16/call_tree.gif").createImage();
        }
        return this.callTreeImage;
    }
}

