/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.fusesource.ide.commons.ui.Trees;
import org.fusesource.ide.commons.ui.config.ColumnConfiguration;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractFilteredTree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsColumn;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsComparator;

public class HotSpotsFilteredTree
extends AbstractFilteredTree {
    public HotSpotsFilteredTree(Composite parent, IActionBars actionBars) {
        super(parent, actionBars);
    }

    public List<String> getColumns() {
        HotSpotsColumn[] values;
        ArrayList<String> columnLabels = new ArrayList<String>();
        HotSpotsColumn[] hotSpotsColumnArray = values = HotSpotsColumn.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            HotSpotsColumn value = hotSpotsColumnArray[n2];
            if (value == HotSpotsColumn.HOT_SPOT) {
                columnLabels.add(this.getMethodColumnName());
            } else {
                columnLabels.add(value.label);
            }
            ++n2;
        }
        return columnLabels;
    }

    public void updateColumnConfiguration() {
        this.configureTree();
    }

    public boolean getDefaultVisibility(String column) {
        return true;
    }

    @Override
    public AbstractFilteredTree.ViewerType getViewerType() {
        return AbstractFilteredTree.ViewerType.HotSpots;
    }

    @Override
    protected void configureTree() {
        Trees.disposeColumns((TreeViewer)this.getViewer());
        this.getViewer().getTree().setLinesVisible(true);
        this.getViewer().getTree().setHeaderVisible(true);
        List columns = this.getConfiguration().getColumnConfigurations();
        for (ColumnConfiguration config : columns) {
            if (!config.isVisible()) continue;
            HotSpotsColumn column = this.getColumn(config.getName());
            TreeColumn treeColumn = new TreeColumn(this.getViewer().getTree(), 0);
            String label = column == HotSpotsColumn.HOT_SPOT ? this.getMethodColumnName() : column.label;
            String toolTip = column == HotSpotsColumn.HOT_SPOT ? this.getMethodColumnToolTip() : column.toolTip;
            treeColumn.setText(label);
            treeColumn.setWidth(column.defalutWidth);
            treeColumn.setAlignment(column.alignment);
            treeColumn.setToolTipText(toolTip);
            treeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof TreeColumn) {
                        HotSpotsFilteredTree.this.sortColumn((TreeColumn)e.widget);
                    }
                }
            });
        }
        this.getConfiguration().addColumnListeners(this.getViewer());
    }

    public void sortColumn(TreeColumn treeColumn) {
        HotSpotsComparator.ColumnType columnType;
        String columnText = treeColumn.getText();
        if (columnText.equals(this.getMethodColumnName())) {
            columnType = HotSpotsComparator.ColumnType.Methods;
        } else if (columnText.equals(HotSpotsColumn.SELFTIME_MS.label)) {
            columnType = HotSpotsComparator.ColumnType.TimeMs;
        } else if (columnText.equals(HotSpotsColumn.SELFTIME_PERCENTAGE.label)) {
            columnType = HotSpotsComparator.ColumnType.TimePercentage;
        } else if (columnText.equals(HotSpotsColumn.COUNT.label)) {
            columnType = HotSpotsComparator.ColumnType.Count;
        } else {
            throw new IllegalArgumentException("Unknown column");
        }
        HotSpotsComparator comparator = new HotSpotsComparator(columnType);
        if (treeColumn.equals(this.getViewer().getTree().getSortColumn()) && this.getViewer().getTree().getSortDirection() == comparator.getSortDirection()) {
            comparator.reverseSortDirection();
        }
        this.getViewer().setComparator((ViewerComparator)comparator);
        this.getViewer().getTree().setSortColumn(treeColumn);
        this.getViewer().getTree().setSortDirection(comparator.getSortDirection());
        this.getViewer().refresh();
    }

    protected String getMethodColumnName() {
        return HotSpotsColumn.HOT_SPOT.label;
    }

    protected String getMethodColumnToolTip() {
        return HotSpotsColumn.HOT_SPOT.toolTip;
    }

    private HotSpotsColumn getColumn(String label) {
        HotSpotsColumn[] hotSpotsColumnArray = HotSpotsColumn.values();
        int n = hotSpotsColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            HotSpotsColumn column = hotSpotsColumnArray[n2];
            if (column == HotSpotsColumn.HOT_SPOT) {
                if (label.equals(this.getMethodColumnName())) {
                    return HotSpotsColumn.HOT_SPOT;
                }
            } else if (label.equals(column.label)) {
                return column;
            }
            ++n2;
        }
        return null;
    }
}

