/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import org.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import org.fusesource.ide.jvmmonitor.core.cpu.IThreadNode;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.AbstractLabelProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsColumn;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.HotSpotsFilteredTree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.Messages;

public class HotSpotsLabelProvider
extends AbstractLabelProvider {
    private HotSpotsFilteredTree filteredTree;

    public HotSpotsLabelProvider(HotSpotsFilteredTree filteredTree) {
        this.filteredTree = filteredTree;
    }

    public Image getImage(Object obj) {
        return null;
    }

    public String getText(Object element) {
        return this.getMethodColumnText(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(HotSpotsColumn.HOT_SPOT)) {
            return this.getMethodColumnImage(element);
        }
        if (columnIndex == this.getColumnIndex(HotSpotsColumn.SELFTIME_PERCENTAGE)) {
            return this.getSelfTimeColumnImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (columnIndex == this.getColumnIndex(HotSpotsColumn.HOT_SPOT)) {
            text = this.getMethodColumnText(element);
        } else if (columnIndex == this.getColumnIndex(HotSpotsColumn.SELFTIME_MS)) {
            text = this.getSelfTimeInMsColumnText(element);
        } else if (columnIndex == this.getColumnIndex(HotSpotsColumn.SELFTIME_PERCENTAGE)) {
            text = this.getSelfTimeInPercentageColumnText(element);
        } else if (columnIndex == this.getColumnIndex(HotSpotsColumn.COUNT)) {
            text = this.getCountColumnText(element);
        }
        return text;
    }

    public Font getFont(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(HotSpotsColumn.HOT_SPOT)) {
            return null;
        }
        return this.getmonospacedFont(this.filteredTree.getFont());
    }

    private Image getMethodColumnImage(Object element) {
        if (element instanceof IThreadNode) {
            if (((IThreadNode)element).hasChildren()) {
                return this.getThreadImage();
            }
        } else if (element instanceof IMethodNode) {
            return this.getMethodImage();
        }
        return null;
    }

    private Image getSelfTimeColumnImage(Object element) {
        if (element instanceof IMethodNode) {
            double percentage = ((IMethodNode)element).getSelfTimeInPercentage();
            return this.getPercentageImage(percentage);
        }
        return null;
    }

    private String getMethodColumnText(Object element) {
        if (element instanceof IThreadNode) {
            if (((IThreadNode)element).hasChildren()) {
                return String.valueOf(Messages.threadLabel) + ' ' + ((IThreadNode)element).getName();
            }
        } else if (element instanceof IMethodNode) {
            return ((IMethodNode)element).getName();
        }
        return "";
    }

    private String getSelfTimeInMsColumnText(Object element) {
        ICpuModel cpuModel = (ICpuModel)this.filteredTree.getViewer().getInput();
        if (cpuModel == null) {
            return "";
        }
        if (element instanceof IMethodNode) {
            long selfTime = ((IMethodNode)element).getSelfTime();
            int length = String.valueOf(cpuModel.getMaxSelfTime() * 1000L).length();
            length = length > 10 ? 10 : length;
            return this.getMillisecondsText(selfTime, length);
        }
        return "";
    }

    private String getSelfTimeInPercentageColumnText(Object element) {
        if (element instanceof IMethodNode) {
            double percentage = ((IMethodNode)element).getSelfTimeInPercentage();
            return String.valueOf(String.format("%5.1f", percentage)) + "%";
        }
        return "";
    }

    private String getCountColumnText(Object element) {
        ICpuModel cpuModel = (ICpuModel)this.filteredTree.getViewer().getInput();
        if (cpuModel == null) {
            return "";
        }
        if (element instanceof IMethodNode) {
            int length = String.valueOf(cpuModel.getMaxInvocationCount()).length();
            return String.format("%" + length + "d", ((IMethodNode)element).getInvocationCount());
        }
        return "";
    }

    private int getColumnIndex(HotSpotsColumn column) {
        Tree tree = this.filteredTree.getViewer().getTree();
        String label = column == HotSpotsColumn.HOT_SPOT ? this.filteredTree.getMethodColumnName() : column.label;
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

