/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.PackageLabelProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.AddPackageDialog;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.Messages;

public class ConfigurationDialog
extends SelectionDialog {
    ICpuProfiler.ProfilerType profilerType;
    int samplingPeriod;
    TableViewer packagesViewer;
    Set<String> packages;
    Text samplingPeriodText;
    Label samplingPeriodLabel;
    private ICpuProfiler.ProfilerState profilerState;
    private Image warningImage;
    private Label warningImageLabel;
    private Label warningMessageLabel;
    private Button bciButton;

    public ConfigurationDialog(Shell parentShell, ICpuProfiler.ProfilerType profilerType, int samplingPeriod, ICpuProfiler.ProfilerState bciProfilerState, Set<String> packages) {
        super(parentShell);
        this.setTitle(Messages.configureCpuProfilerTitle);
        this.setHelpAvailable(false);
        this.profilerType = profilerType;
        this.samplingPeriod = samplingPeriod;
        this.profilerState = bciProfilerState;
        this.packages = new LinkedHashSet<String>(packages);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createProfilerTypeSelection(inner);
        this.createPackagesViewer(inner);
        this.createWarningMessageControls(inner);
        ConfigurationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    public void create() {
        super.create();
        this.validate();
    }

    public boolean close() {
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        return super.close();
    }

    protected ICpuProfiler.ProfilerType getProfilerType() {
        return this.profilerType;
    }

    protected int getSamplingPeriod() {
        return this.samplingPeriod;
    }

    protected Set<String> getPackages() {
        return this.packages;
    }

    boolean validate() {
        boolean isValid = true;
        try {
            Integer value = Integer.valueOf(this.samplingPeriodText.getText());
            if (value <= 0) {
                isValid = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            isValid = false;
        }
        String warningMessage = "";
        if (this.profilerState == ICpuProfiler.ProfilerState.INVALID_VERSION) {
            warningMessage = Messages.invalidVersionMsg;
        } else if (this.profilerState == ICpuProfiler.ProfilerState.AGENT_NOT_LOADED || this.profilerState == ICpuProfiler.ProfilerState.UNKNOWN) {
            warningMessage = Messages.agentNotLoadedMsg;
        }
        this.warningImageLabel.setVisible(!warningMessage.isEmpty());
        this.warningMessageLabel.setText(warningMessage);
        this.bciButton.setEnabled(this.profilerState == ICpuProfiler.ProfilerState.READY || this.profilerState == ICpuProfiler.ProfilerState.RUNNING);
        this.getOkButton().setEnabled(isValid);
        return isValid;
    }

    private void createProfilerTypeSelection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.profilerTypeGroupLabel);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(1, false));
        Button samplingButton = new Button((Composite)group, 16);
        samplingButton.setText(Messages.samplingButtonLabel);
        samplingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.profilerType = ICpuProfiler.ProfilerType.SAMPLING;
                ConfigurationDialog.this.samplingPeriodLabel.setEnabled(true);
                ConfigurationDialog.this.samplingPeriodText.setEnabled(true);
            }
        });
        this.createSamplingPeriodText((Composite)group);
        this.bciButton = new Button((Composite)group, 16);
        this.bciButton.setText(Messages.bciButtonLabel);
        this.bciButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.profilerType = ICpuProfiler.ProfilerType.BCI;
                ConfigurationDialog.this.samplingPeriodLabel.setEnabled(false);
                ConfigurationDialog.this.samplingPeriodText.setEnabled(false);
            }
        });
        boolean isBCI = this.profilerType == ICpuProfiler.ProfilerType.BCI;
        samplingButton.setSelection(!isBCI);
        this.bciButton.setSelection(isBCI);
        this.bciButton.setEnabled(this.profilerState != ICpuProfiler.ProfilerState.AGENT_NOT_LOADED);
        this.samplingPeriodLabel.setEnabled(!isBCI);
        this.samplingPeriodText.setEnabled(!isBCI);
    }

    private void createSamplingPeriodText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        composite.setLayoutData((Object)gridData);
        this.samplingPeriodLabel = new Label(composite, 0);
        this.samplingPeriodLabel.setText(Messages.samplingPeriodLabel);
        this.samplingPeriodText = new Text(composite, 2048);
        this.samplingPeriodText.setText(String.valueOf(this.samplingPeriod));
        this.samplingPeriodText.setLayoutData((Object)new GridData(768));
        this.samplingPeriodText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConfigurationDialog.this.validate()) {
                    ConfigurationDialog.this.samplingPeriod = Integer.valueOf(ConfigurationDialog.this.samplingPeriodText.getText());
                }
            }
        });
    }

    private void createPackagesViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.profiledPackagesLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.packagesViewer = new TableViewer(composite, 2050);
        this.packagesViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.packagesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.packagesViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.packagesViewer.setInput((Object)this.packages.toArray(new String[this.packages.size()]));
        this.createAddRemoveButtons(composite);
    }

    private void createAddRemoveButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Button addButton = new Button(composite, 8);
        addButton.setText(Messages.addLabel);
        this.setButtonLayoutData(addButton);
        addButton.addSelectionListener(this.getAddButtonListener());
        Button removeButton = new Button(composite, 8);
        removeButton.setText(Messages.removeLabel);
        this.setButtonLayoutData(removeButton);
        removeButton.addSelectionListener(this.getRemoveButtonListener());
    }

    private void createWarningMessageControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.warningImageLabel = new Label(composite, 0);
        this.warningImageLabel.setImage(this.getWarningImage());
        this.warningImageLabel.setVisible(false);
        this.warningMessageLabel = new Label(composite, 72);
        this.warningMessageLabel.setLayoutData((Object)new GridData(768));
    }

    private SelectionListener getRemoveButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] selections;
                Object[] input = (Object[])ConfigurationDialog.this.packagesViewer.getInput();
                ConfigurationDialog.this.packages.clear();
                Object[] objectArray = input;
                int n = input.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    ConfigurationDialog.this.packages.add((String)object);
                    ++n2;
                }
                Object[] objectArray2 = selections = ((IStructuredSelection)ConfigurationDialog.this.packagesViewer.getSelection()).toArray();
                int n3 = selections.length;
                n = 0;
                while (n < n3) {
                    Object selection = objectArray2[n];
                    ConfigurationDialog.this.packages.remove(selection);
                    ++n;
                }
                ConfigurationDialog.this.packagesViewer.setInput((Object)ConfigurationDialog.this.packages.toArray(new String[ConfigurationDialog.this.packages.size()]));
                ConfigurationDialog.this.packagesViewer.refresh();
            }
        };
    }

    private SelectionListener getAddButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] input = (Object[])ConfigurationDialog.this.packagesViewer.getInput();
                AddPackageDialog dialog = new AddPackageDialog(ConfigurationDialog.this.getShell(), input);
                if (dialog.open() == 0) {
                    Object[] elements;
                    ConfigurationDialog.this.packages.clear();
                    Object[] objectArray = input;
                    int n = input.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ConfigurationDialog.this.packages.add((String)object);
                        ++n2;
                    }
                    Object[] objectArray2 = elements = dialog.getResult();
                    int n3 = elements.length;
                    n = 0;
                    while (n < n3) {
                        Object object = objectArray2[n];
                        ConfigurationDialog.this.packages.add(((String)object).trim());
                        ++n;
                    }
                    Object[] items = ConfigurationDialog.this.packages.toArray(new String[ConfigurationDialog.this.packages.size()]);
                    Arrays.sort(items);
                    ConfigurationDialog.this.packagesViewer.setInput((Object)items);
                    ConfigurationDialog.this.packagesViewer.refresh();
                }
            }
        };
    }

    private Image getWarningImage() {
        if (this.warningImage == null || this.warningImage.isDisposed()) {
            this.warningImage = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_WARN_TSK").createImage();
        }
        return this.warningImage;
    }
}

