/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.cpu.actions.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.views.OpenSnapshotAction;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class DumpCpuProfilingDataAction
extends Action {
    AbstractJvmPropertySection section;

    public DumpCpuProfilingDataAction(AbstractJvmPropertySection section) {
        this.setText(Messages.dumpCpuLabel);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/elcl16/take_cpu_dump.gif"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/full/dlcl16/take_cpu_dump.gif"));
        this.setId(((Object)((Object)this)).getClass().getName());
        this.section = section;
    }

    public void run() {
        new Job(Messages.dumpCpuProfileDataJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IActiveJvm jvm = DumpCpuProfilingDataAction.this.section.getJvm();
                if (jvm == null) {
                    return Status.CANCEL_STATUS;
                }
                IFileStore fileStore = null;
                try {
                    fileStore = jvm.getCpuProfiler().dump();
                }
                catch (JvmCoreException e) {
                    Activator.log(Messages.dumpCpuProfileDataFailedMsg, (CoreException)((Object)e));
                    return Status.CANCEL_STATUS;
                }
                DumpCpuProfilingDataAction.this.section.setPinned(true);
                OpenSnapshotAction.openEditor(fileStore);
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

