/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.core.Activator;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.PropertiesColumn;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeNode;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeParser;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;

public class InvokeDialog
extends Dialog {
    private static final int DIALOG_HEIGHT = 500;
    private static final int DIALOG_WIDTH = 450;
    private MBeanOperationInfo info;
    private IActiveJvm jvm;
    private ObjectName objectName;
    Map<MBeanParameterInfo, Control> controls;
    Label messageLabel;
    TreeViewer returnValueViewer;
    CopyAction copyAction;

    protected InvokeDialog(Shell shell, IActiveJvm jvm, ObjectName objectName, MBeanOperationInfo info) {
        super(shell);
        this.objectName = objectName;
        this.jvm = jvm;
        this.info = info;
        this.controls = new HashMap<MBeanParameterInfo, Control>();
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.invokeDialogTitle);
        this.getShell().setSize(Math.max(450, this.getShell().getSize().x), 500);
        this.validate();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.fusesource.ide.jvmmonitor.ui.invoke_dialog_content");
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 5;
        layout.marginRight = 5;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        this.createOperationGroup(panel);
        this.createParameterGroup(panel);
        this.createReturnValueViewer(panel);
        this.createMessageArea(panel);
        InvokeDialog.applyDialogFont((Control)panel);
        return panel;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button invokeButton = this.createButton(parent, 1024, Messages.invokeButtonLabel, true);
        invokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InvokeDialog.this.invoke();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected boolean isResizable() {
        return true;
    }

    private void createOperationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.operationGroupLabel);
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label methodName = new Label((Composite)group, 0);
        methodName.setText(this.getMethodSignature());
    }

    private void createParameterGroup(Composite parent) {
        if (this.info.getSignature().length == 0) {
            return;
        }
        Group group = new Group(parent, 0);
        group.setText(Messages.parametersGroupLabel);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        MBeanParameterInfo[] mBeanParameterInfoArray = this.info.getSignature();
        int n = mBeanParameterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            MBeanParameterInfo signature = mBeanParameterInfoArray[n2];
            Label label = new Label((Composite)group, 0);
            String type = signature.getType();
            if (type.startsWith("[")) {
                type = Signature.toString((String)type);
                label.setToolTipText(Messages.enterCommaSeparatedValuesToolTip);
            }
            if ((index = type.lastIndexOf(46)) > 0) {
                type = type.substring(index + 1);
            }
            label.setText(String.valueOf(type) + ":");
            if (Boolean.class.getSimpleName().equalsIgnoreCase(type)) {
                Combo combo = new Combo((Composite)group, 8);
                combo.setLayoutData((Object)new GridData(768));
                combo.add(Boolean.TRUE.toString());
                combo.add(Boolean.FALSE.toString());
                combo.select(0);
                this.controls.put(signature, (Control)combo);
            } else {
                Text text = new Text((Composite)group, 2048);
                text.setLayoutData((Object)new GridData(768));
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        InvokeDialog.this.validate();
                    }
                });
                this.controls.put(signature, (Control)text);
            }
            ++n2;
        }
    }

    private void createReturnValueViewer(Composite parent) {
        if (this.info.getReturnType().equals("void")) {
            return;
        }
        Label label = new Label(parent, 0);
        label.setText(Messages.returnValueLabel);
        label.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.returnValueViewer = new TreeViewer(composite, 65538);
        this.configureTree(this.returnValueViewer.getTree());
        this.returnValueViewer.setContentProvider((IContentProvider)new ReturnValueContentProvider());
        this.returnValueViewer.setLabelProvider((IBaseLabelProvider)new ReturnValueLabelProvider());
        this.copyAction = new CopyAction();
        this.copyAction.setActionDefinitionId(null);
        this.returnValueViewer.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
    }

    private void configureTree(Tree tree) {
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        PropertiesColumn[] propertiesColumnArray = PropertiesColumn.values();
        int n = propertiesColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertiesColumn column = propertiesColumnArray[n2];
            TreeColumn treeColumn = new TreeColumn(tree, 0);
            treeColumn.setText(column.label);
            treeColumn.setWidth(column.defalutWidth);
            treeColumn.setAlignment(column.alignment);
            treeColumn.setToolTipText(column.toolTip);
            ++n2;
        }
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)InvokeDialog.this.copyAction);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private void createMessageArea(Composite parent) {
        this.messageLabel = new Label(parent, 0);
        this.messageLabel.setLayoutData((Object)new GridData(768));
    }

    void validate() {
        boolean enableButton = true;
        for (Map.Entry<MBeanParameterInfo, Control> entry : this.controls.entrySet()) {
            String text;
            String type;
            Control control = entry.getValue();
            if (!(control instanceof Text) || this.validateNumber(type = entry.getKey().getType(), text = ((Text)control).getText())) continue;
            enableButton = false;
            break;
        }
        Button invokeButton = this.getButton(1024);
        if (invokeButton != null) {
            invokeButton.setEnabled(enableButton);
        }
    }

    private boolean validateNumber(String type, String string) {
        try {
            if ("byte".equals(type)) {
                Byte.valueOf(string);
            } else if ("double".equals(type)) {
                Double.valueOf(string);
            } else if ("float".equals(type)) {
                Float.valueOf(string);
            } else if ("int".equals(type)) {
                Integer.valueOf(string);
            } else if ("long".equals(type)) {
                Long.valueOf(string);
            } else if ("short".equals(type)) {
                Short.valueOf(string);
            } else if (type.startsWith("[")) {
                return this.validateNumberArray(type, string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean validateNumberArray(String arrayType, String string) {
        String[] elements;
        String readableString = Signature.toString((String)arrayType);
        String type = readableString.substring(0, readableString.indexOf("["));
        String[] stringArray = elements = string.split(",");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!this.validateNumber(type, element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    void setMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                InvokeDialog.this.messageLabel.setText(message);
            }
        });
    }

    private String getMethodSignature() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.info.getName());
        buffer.append("(");
        StringBuffer paramBuffer = new StringBuffer();
        MBeanParameterInfo[] mBeanParameterInfoArray = this.info.getSignature();
        int n = mBeanParameterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            String param;
            MBeanParameterInfo parameterInfo = mBeanParameterInfoArray[n2];
            if (paramBuffer.length() != 0) {
                paramBuffer.append(", ");
            }
            if ((param = parameterInfo.getType()).startsWith("[")) {
                param = Signature.toString((String)param);
            }
            if ((index = param.lastIndexOf(46)) > 0) {
                param = param.substring(index + 1);
            }
            paramBuffer.append(param);
            ++n2;
        }
        buffer.append(paramBuffer);
        buffer.append(")");
        return buffer.toString();
    }

    void invoke() {
        if (this.objectName == null || this.jvm == null || this.info == null) {
            return;
        }
        new Job(Messages.invokeMBeanOperationJobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    InvokeDialog.this.doInvoke();
                }
                catch (JMException jMException) {
                    InvokeDialog.this.setMessage(NLS.bind((String)Messages.mBeanOperationFailedLabel, (Object)new Date()));
                    return Status.CANCEL_STATUS;
                }
                catch (IOException iOException) {
                    InvokeDialog.this.setMessage(NLS.bind((String)Messages.mBeanOperationFailedLabel, (Object)new Date()));
                    return Status.CANCEL_STATUS;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    InvokeDialog.this.setMessage(NLS.bind((String)Messages.mBeanOperationFailedLabel, (Object)new Date()));
                    return Status.CANCEL_STATUS;
                }
                InvokeDialog.this.setMessage(NLS.bind((String)Messages.mBeanOperationSucceededLabel, (Object)new Date()));
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    void doInvoke() throws JMException, IOException {
        Object result;
        String operationName = this.info.getName();
        String[] signature = this.getSignature();
        Object[] params = this.getParams();
        try {
            result = this.jvm.getMBeanServer().invoke(this.objectName, operationName, params, signature);
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.mBeanOperationFailedMsg, (Throwable)e);
            return;
        }
        if (result == null) {
            return;
        }
        final AttributeNode attributeNode = new AttributeNode(result.getClass().getCanonicalName(), null, result);
        new AttributeParser().refreshAttribute(attributeNode);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AttributeNode[] input = attributeNode.hasChildren() ? attributeNode.getChildren().toArray(new AttributeNode[0]) : new AttributeNode[]{attributeNode};
                InvokeDialog.this.returnValueViewer.setInput((Object)input);
                InvokeDialog.this.returnValueViewer.refresh();
            }
        });
    }

    private Object[] getParams() {
        ArrayList<Integer> params = new ArrayList<Integer>();
        MBeanParameterInfo[] mBeanParameterInfoArray = this.info.getSignature();
        int n = mBeanParameterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            MBeanParameterInfo signature = mBeanParameterInfoArray[n2];
            String text = this.getText(signature);
            String type = signature.getType();
            if ("int".equals(type)) {
                object = Integer.valueOf(text);
            } else if ("long".equals(type)) {
                object = Long.valueOf(text);
            } else if ("boolean".equals(type)) {
                object = Boolean.valueOf(text);
            } else if ("java.lang.String".equals(type)) {
                object = String.valueOf(text);
            } else if ("[J".equals(type)) {
                String[] elements = text.split(",");
                long[] objects = new long[elements.length];
                int i = 0;
                while (i < elements.length) {
                    objects[i] = Long.parseLong(elements[i]);
                    ++i;
                }
                object = objects;
            } else {
                throw new IllegalStateException("unknown parameter type");
            }
            params.add((Integer)object);
            ++n2;
        }
        return params.toArray(new Object[0]);
    }

    private String getText(final MBeanParameterInfo signature) {
        final String[] text = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Control control = InvokeDialog.this.controls.get(signature);
                if (control instanceof Text) {
                    text[0] = ((Text)control).getText();
                } else if (control instanceof Combo) {
                    text[0] = ((Combo)control).getText();
                }
            }
        });
        return text[0];
    }

    private String[] getSignature() {
        ArrayList<String> result = new ArrayList<String>();
        MBeanParameterInfo[] mBeanParameterInfoArray = this.info.getSignature();
        int n = mBeanParameterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanParameterInfo signature = mBeanParameterInfoArray[n2];
            result.add(signature.getType());
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    private static class ReturnValueContentProvider
    implements ITreeContentProvider {
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            if (input instanceof AttributeNode[]) {
                return (AttributeNode[])input;
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AttributeNode) {
                return ((AttributeNode)parentElement).getChildren().toArray(new AttributeNode[0]);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof AttributeNode) {
                return ((AttributeNode)element).hasChildren();
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }
    }

    private static class ReturnValueLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            Object value;
            AttributeNode attribute = (AttributeNode)element;
            if (columnIndex == 0) {
                return attribute.getName();
            }
            if (columnIndex == 1 && (value = attribute.getValue()) != null && attribute.isValidLeaf()) {
                return value.toString();
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

