/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.Notification;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.CopyAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.PropertiesColumn;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeNode;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.AttributeParser;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.NotificationFilteredTree;
import org.fusesource.ide.jvmmonitor.ui.Activator;

class NotificationDetailsDialog
extends Dialog {
    private static final int DIALOG_HEIGHT = 500;
    private static final int DIALOG_WIDTH = 450;
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private Label dateLabel;
    private Label sequenceNumberText;
    private Label sourceLabel;
    private Label typeLabel;
    private Text messageText;
    private Button prevButton;
    private Button nextButton;
    TreeViewer detailsViewer;
    private Image prevImage;
    private Image nextImage;
    NotificationFilteredTree tree;
    CopyAction copyAction;

    protected NotificationDetailsDialog(NotificationFilteredTree tree) {
        super(tree.getShell());
        this.tree = tree;
        this.setShellStyle(3312);
    }

    public void create() {
        super.create();
        this.getShell().setSize(Math.max(450, this.getShell().getSize().x), 500);
        this.getShell().setText(Messages.notificationDetailsLabel);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.fusesource.ide.jvmmonitor.ui.notification_details_dialog_content");
    }

    public boolean close() {
        this.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite textsPanel = new Composite(composite, 0);
        this.createTexts(textsPanel);
        textsPanel.setLayoutData((Object)new GridData(768));
        Composite buttonsPanel = new Composite(composite, 0);
        this.createButtons(buttonsPanel);
        buttonsPanel.setLayoutData((Object)new GridData());
        Composite treePanel = new Composite(composite, 0);
        this.createTree(treePanel);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        treePanel.setLayoutData((Object)gridData);
        this.refreshWidgets();
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true).setFocus();
    }

    protected boolean isOpened() {
        Shell shell = this.getShell();
        return shell != null && shell.isVisible();
    }

    protected void refreshWidgets() {
        IContentProvider contentProvider;
        Notification notification = (Notification)((StructuredSelection)this.tree.getViewer().getSelection()).getFirstElement();
        if (notification == null) {
            return;
        }
        this.dateLabel.setText(new SimpleDateFormat(DATE_FORMAT).format(new Date(notification.getTimeStamp())));
        this.sequenceNumberText.setText(String.valueOf(notification.getSequenceNumber()));
        this.sourceLabel.setText(notification.getSource().toString());
        this.typeLabel.setText(notification.getType());
        this.messageText.setText(notification.getMessage());
        Object userData = notification.getUserData();
        if (userData != null && (contentProvider = this.detailsViewer.getContentProvider()) != null) {
            ((DetailsContentProvider)contentProvider).refresh(userData);
        }
        if (this.prevButton != null && !this.prevButton.isDisposed()) {
            this.prevButton.setEnabled(this.tree.getPrevItem() != null);
        }
        if (this.nextButton != null && !this.nextButton.isDisposed()) {
            this.nextButton.setEnabled(this.tree.getNextItem() != null);
        }
    }

    private void dispose() {
        if (this.prevImage != null) {
            this.prevImage.dispose();
        }
        if (this.nextImage != null) {
            this.nextImage.dispose();
        }
    }

    private void createTexts(Composite composite) {
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0).setText(Messages.dateLabel);
        this.dateLabel = new Label(composite, 0);
        this.dateLabel.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(Messages.sequenceNumberLabel);
        this.sequenceNumberText = new Label(composite, 0);
        this.sequenceNumberText.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(Messages.sourceLabel);
        this.sourceLabel = new Label(composite, 0);
        this.sourceLabel.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(Messages.typeLabel);
        this.typeLabel = new Label(composite, 0);
        this.typeLabel.setLayoutData((Object)new GridData(768));
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText(Messages.messageLabel);
        this.messageText = new Text(composite, 2626);
        GridData gridData = new GridData(768);
        gridData.heightHint = 44;
        this.messageText.setLayoutData((Object)gridData);
        this.messageText.setEditable(false);
    }

    private void createButtons(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        this.prevButton = new Button(composite, 8);
        this.prevButton.setImage(this.getPrevImage());
        this.prevButton.setToolTipText(Messages.prevButtonToolTip);
        this.prevButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationDetailsDialog.this.tree.selectPrevItem();
                NotificationDetailsDialog.this.refreshWidgets();
            }
        });
        this.nextButton = new Button(composite, 8);
        this.nextButton.setImage(this.getNextImage());
        this.nextButton.setToolTipText(Messages.nextButtonToolTip);
        this.nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotificationDetailsDialog.this.tree.selectNextItem();
                NotificationDetailsDialog.this.refreshWidgets();
            }
        });
    }

    private void createTree(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.detailsViewer = new TreeViewer(composite, 65538);
        this.configureTree(this.detailsViewer.getTree());
        this.detailsViewer.setContentProvider((IContentProvider)new DetailsContentProvider());
        this.detailsViewer.setLabelProvider((IBaseLabelProvider)new DetailsLabelProvider());
        this.detailsViewer.setInput(new Object());
        this.copyAction = new CopyAction();
        this.copyAction.setActionDefinitionId(null);
        this.detailsViewer.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
    }

    private void configureTree(Tree detailsTree) {
        detailsTree.setLinesVisible(true);
        detailsTree.setHeaderVisible(true);
        PropertiesColumn[] propertiesColumnArray = PropertiesColumn.values();
        int n = propertiesColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertiesColumn column = propertiesColumnArray[n2];
            TreeColumn treeColumn = new TreeColumn(detailsTree, 0);
            treeColumn.setText(column.label);
            treeColumn.setWidth(column.defalutWidth);
            treeColumn.setAlignment(column.alignment);
            treeColumn.setToolTipText(column.toolTip);
            ++n2;
        }
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)NotificationDetailsDialog.this.copyAction);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)detailsTree);
        detailsTree.setMenu(menu);
    }

    private Image getNextImage() {
        if (this.nextImage == null || this.nextImage.isDisposed()) {
            this.nextImage = Activator.getImageDescriptor("icons/full/elcl16/next.gif").createImage();
        }
        return this.nextImage;
    }

    private Image getPrevImage() {
        if (this.prevImage == null || this.prevImage.isDisposed()) {
            this.prevImage = Activator.getImageDescriptor("icons/full/elcl16/prev.gif").createImage();
        }
        return this.prevImage;
    }

    private class DetailsContentProvider
    implements ITreeContentProvider {
        protected AttributeNode attributeRootNode;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object input) {
            if (this.attributeRootNode != null) {
                if (this.attributeRootNode.hasChildren()) {
                    return this.attributeRootNode.getChildren().toArray(new AttributeNode[0]);
                }
                return new AttributeNode[]{this.attributeRootNode};
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AttributeNode) {
                return ((AttributeNode)parentElement).getChildren().toArray(new AttributeNode[0]);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof AttributeNode) {
                return ((AttributeNode)element).hasChildren();
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void refresh(Object userData) {
            if (this.attributeRootNode != null && this.attributeRootNode.getName().equals(userData.getClass().getCanonicalName())) {
                this.attributeRootNode.setValue(userData);
            } else {
                this.attributeRootNode = new AttributeNode(userData.getClass().getCanonicalName(), null, userData);
            }
            new AttributeParser().refreshAttribute(this.attributeRootNode);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((DetailsContentProvider)DetailsContentProvider.this).NotificationDetailsDialog.this.detailsViewer.refresh();
                }
            });
        }
    }

    private static class DetailsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            Object value;
            AttributeNode attribute = (AttributeNode)element;
            if (columnIndex == 0) {
                return attribute.getName();
            }
            if (columnIndex == 1 && (value = attribute.getValue()) != null && attribute.isValidLeaf()) {
                return value.toString();
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

