/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean;

import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.jvmmonitor.ui.Activator;
import org.fusesource.ide.jvmmonitor.ui.ISharedImages;

public class OperationsLabelProvider
extends LabelProvider
implements ISharedImages {
    private Image methodImage;

    public String getText(Object element) {
        if (element instanceof MBeanOperationInfo) {
            MBeanOperationInfo info = (MBeanOperationInfo)element;
            return this.getMethodSignature(info);
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof MBeanOperationInfo) {
            return this.getMethodImage();
        }
        return super.getImage(element);
    }

    public void dispose() {
        if (this.methodImage != null) {
            this.methodImage.dispose();
        }
    }

    private Image getMethodImage() {
        if (this.methodImage == null || this.methodImage.isDisposed()) {
            this.methodImage = Activator.getImageDescriptor("icons/full/obj16/method_obj.gif").createImage();
        }
        return this.methodImage;
    }

    private String getMethodSignature(MBeanOperationInfo info) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(info.getName());
        buffer.append("(");
        StringBuffer paramBuffer = new StringBuffer();
        MBeanParameterInfo[] mBeanParameterInfoArray = info.getSignature();
        int n = mBeanParameterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index;
            String param;
            MBeanParameterInfo parameterInfo = mBeanParameterInfoArray[n2];
            if (paramBuffer.length() != 0) {
                paramBuffer.append(", ");
            }
            if ((param = parameterInfo.getType()).startsWith("[")) {
                param = Signature.toString((String)param);
            }
            if ((index = param.lastIndexOf(46)) > 0) {
                param = param.substring(index + 1);
            }
            paramBuffer.append(param);
            ++n2;
        }
        buffer.append(paramBuffer);
        buffer.append(")");
        return buffer.toString();
    }
}

