/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.overview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewCategory;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewProperties;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewProperty;

public class OverviewContentProvider
implements ITreeContentProvider {
    private OverviewProperties overviewProperties;
    private List<OverviewProperty> systemProperties;

    public OverviewContentProvider(OverviewProperties overviewProperties) {
        this.overviewProperties = overviewProperties;
        this.systemProperties = new ArrayList<OverviewProperty>();
    }

    public Object[] getElements(Object inputElement) {
        return OverviewCategory.values();
    }

    public Object[] getChildren(Object parentElement) {
        Object value;
        if (parentElement instanceof OverviewCategory) {
            return this.overviewProperties.getOverviewProperties((OverviewCategory)((Object)parentElement));
        }
        if (parentElement instanceof OverviewProperty && (value = ((OverviewProperty)parentElement).getValue()) instanceof TabularData) {
            return this.toArray((TabularData)value);
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        OverviewProperty property;
        if (element instanceof OverviewCategory) {
            return true;
        }
        return element instanceof OverviewProperty && (property = (OverviewProperty)element).getValue() instanceof TabularData;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private Object[] toArray(TabularData tabularData) {
        ArrayList<OverviewProperty> list = new ArrayList<OverviewProperty>();
        for (Object object : tabularData.values()) {
            if (!(object instanceof CompositeData)) continue;
            CompositeData compositeData = (CompositeData)object;
            String[] elements = compositeData.values().toArray(new String[0]);
            OverviewProperty property = this.getProperty(elements[0]);
            if (property == null) {
                property = new OverviewProperty(OverviewCategory.Runtime, elements[0], elements[0], false);
            }
            property.setValue(elements[1]);
            list.add(property);
        }
        Collections.sort(list, new Comparator<OverviewProperty>(){

            @Override
            public int compare(OverviewProperty o1, OverviewProperty o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        this.systemProperties = list;
        return this.systemProperties.toArray(new OverviewProperty[this.systemProperties.size()]);
    }

    private OverviewProperty getProperty(String attribute) {
        for (OverviewProperty property : this.systemProperties) {
            if (!property.getAttributeName().equals(attribute)) continue;
            return property;
        }
        return null;
    }
}

