/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.overview;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.IFormat;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.OverviewCategory;

public class OverviewProperty {
    private String displayName;
    private String attributeName;
    private IFormat format;
    private String objectName;
    private Object value;
    private boolean isTimelineSupported;

    public OverviewProperty(OverviewCategory category, String displayName, String attributeName, boolean isTimelineSupported) {
        this(category, displayName, attributeName, null, null, isTimelineSupported);
    }

    public OverviewProperty(OverviewCategory category, String displayName, String attributeName, IFormat format, boolean isTimelineSupported) {
        this(category, displayName, attributeName, null, format, isTimelineSupported);
    }

    public OverviewProperty(OverviewCategory category, String displayName, String attributeName, String name, IFormat format, boolean isTimelineSupported) {
        this.displayName = displayName;
        this.attributeName = attributeName;
        this.format = format;
        this.isTimelineSupported = isTimelineSupported;
        this.objectName = name == null ? String.format("java.lang:type=%s", category.name()) : String.format("java.lang:type=%s,name=%s", category.name(), name);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.displayName);
        buffer.append('\t').append(this.getValueString());
        return buffer.toString();
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected String getAttributeName() {
        return this.attributeName;
    }

    protected String getObjectName() {
        return this.objectName;
    }

    protected Object getValue() {
        return this.value;
    }

    protected void setValue(Object value) {
        this.value = value;
    }

    protected boolean isTimelineSupported() {
        return this.isTimelineSupported;
    }

    protected String getValueString() {
        if (this.value == null) {
            return "";
        }
        if (this.value instanceof String[]) {
            StringBuffer buffer = new StringBuffer();
            String[] stringArray = (String[])this.value;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                buffer.append(element).append(' ');
                ++n2;
            }
            return buffer.toString();
        }
        if (this.value instanceof CompositeData) {
            if (!this.attributeName.contains(".")) {
                return "";
            }
            CompositeData compositeData = (CompositeData)this.value;
            String[] elements = this.attributeName.split("\\.");
            String compositeDataKey = elements[elements.length - 1];
            this.value = compositeData.get(compositeDataKey);
        }
        if (this.value instanceof String) {
            return ((String)this.value).replace("\n", "\\n");
        }
        if (this.value instanceof Long && this.format != null) {
            return this.format.format(this.value);
        }
        if (this.value instanceof TabularData) {
            return "";
        }
        return this.value.toString();
    }
}

