/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.thread;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.fusesource.ide.jvmmonitor.core.IThreadElement;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.overview.IFormat;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadColumn;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class ThreadLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final ThreadColumn[] COLUMNS_TAKEN_INTO_ACCOUNT_FOR_FILTER = new ThreadColumn[]{ThreadColumn.THREAD, ThreadColumn.STATE, ThreadColumn.LOCK, ThreadColumn.LOCK_OWNWER};
    private Image threadRunnableObjImage;
    private Image threadWaitingObjImage;
    private Image threadBlockedObjImage;
    private Image threadSuspendedObjImage;
    private Image threadDeadlockedObjImage;
    private TreeViewer treeViewer;

    public ThreadLabelProvider(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IThreadElement) {
            return this.getColumnText((IThreadElement)element, columnIndex);
        }
        return super.getText(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(ThreadColumn.THREAD) && element instanceof IThreadElement) {
            return this.getThreadObjImage((IThreadElement)element);
        }
        return super.getImage(element);
    }

    public String getText(Object obj) {
        if (obj instanceof IThreadElement) {
            StringBuffer buffer = new StringBuffer();
            Object[] objectArray = COLUMNS_TAKEN_INTO_ACCOUNT_FOR_FILTER;
            int n = COLUMNS_TAKEN_INTO_ACCOUNT_FOR_FILTER.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadColumn column = objectArray[n2];
                buffer.append(this.getColumnText((IThreadElement)obj, this.getColumnIndex(column))).append(' ');
                ++n2;
            }
            if (Activator.getDefault().getPreferenceStore().getBoolean("WideScopeThreadFilter")) {
                objectArray = ((IThreadElement)obj).getStackTraceElements();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    ThreadColumn element = objectArray[n2];
                    buffer.append(((StackTraceElement)((Object)element)).getClassName()).append('.').append(((StackTraceElement)((Object)element)).getMethodName()).append(' ');
                    buffer.append(((StackTraceElement)((Object)element)).getFileName()).append(' ');
                    ++n2;
                }
            }
            return buffer.toString();
        }
        return super.getText(obj);
    }

    public void dispose() {
        if (this.threadRunnableObjImage != null) {
            this.threadRunnableObjImage.dispose();
        }
        if (this.threadWaitingObjImage != null) {
            this.threadWaitingObjImage.dispose();
        }
        if (this.threadBlockedObjImage != null) {
            this.threadBlockedObjImage.dispose();
        }
        if (this.threadSuspendedObjImage != null) {
            this.threadSuspendedObjImage.dispose();
        }
    }

    private String getColumnText(IThreadElement element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(ThreadColumn.THREAD)) {
            return element.getThreadName();
        }
        if (columnIndex == this.getColumnIndex(ThreadColumn.STATE)) {
            String state = element.getThreadState().name();
            if (element.isDeadlocked()) {
                state = "DEADLOCKED";
            }
            return state;
        }
        if (columnIndex == this.getColumnIndex(ThreadColumn.CPU)) {
            return String.valueOf(String.format(" %.1f", element.getCpuUsage())) + "%";
        }
        if (columnIndex == this.getColumnIndex(ThreadColumn.BLOCKED_TIME)) {
            return IFormat.MILLISEC_FORMAT.format(element.getBlockedTime());
        }
        if (columnIndex == this.getColumnIndex(ThreadColumn.BLOCKED_COUNT)) {
            return String.valueOf(element.getBlockedCount());
        }
        if (columnIndex == this.getColumnIndex(ThreadColumn.WAITED_TIME)) {
            return IFormat.MILLISEC_FORMAT.format(element.getWaitedTime());
        }
        if (columnIndex == this.getColumnIndex(ThreadColumn.WAITED_COUNT)) {
            return String.valueOf(element.getWaitedCount());
        }
        if (columnIndex == this.getColumnIndex(ThreadColumn.LOCK)) {
            return element.getLockName();
        }
        if (columnIndex == this.getColumnIndex(ThreadColumn.LOCK_OWNWER)) {
            return element.getLockOwnerName();
        }
        return "";
    }

    private int getColumnIndex(ThreadColumn column) {
        Tree tree = this.treeViewer.getTree();
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Image getThreadObjImage(IThreadElement element) {
        if (element.isDeadlocked()) {
            if (this.threadDeadlockedObjImage == null || this.threadDeadlockedObjImage.isDisposed()) {
                this.threadDeadlockedObjImage = Activator.getImageDescriptor("icons/full/obj16/thread_deadlocked_obj.png").createImage();
            }
            return this.threadDeadlockedObjImage;
        }
        if (element.isSuspended()) {
            if (this.threadSuspendedObjImage == null || this.threadSuspendedObjImage.isDisposed()) {
                this.threadSuspendedObjImage = Activator.getImageDescriptor("icons/full/obj16/thread_suspended_obj.gif").createImage();
            }
            return this.threadSuspendedObjImage;
        }
        Thread.State state = element.getThreadState();
        if (state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING) {
            if (this.threadWaitingObjImage == null || this.threadWaitingObjImage.isDisposed()) {
                this.threadWaitingObjImage = Activator.getImageDescriptor("icons/full/obj16/thread_waiting_obj.png").createImage();
            }
            return this.threadWaitingObjImage;
        }
        if (state == Thread.State.RUNNABLE) {
            if (this.threadRunnableObjImage == null || this.threadRunnableObjImage.isDisposed()) {
                this.threadRunnableObjImage = Activator.getImageDescriptor("icons/full/obj16/thread_runnable_obj.gif").createImage();
            }
            return this.threadRunnableObjImage;
        }
        if (state == Thread.State.BLOCKED) {
            if (this.threadBlockedObjImage == null || this.threadBlockedObjImage.isDisposed()) {
                this.threadBlockedObjImage = Activator.getImageDescriptor("icons/full/obj16/thread_blocked_obj.png").createImage();
            }
            return this.threadBlockedObjImage;
        }
        return null;
    }
}

