/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.thread;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractSashForm;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.StackTraceViewer;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.IThreadInput;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadContentProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadFilteredTree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadLabelProvider;

public class ThreadSashForm
extends AbstractSashForm {
    private static final int[] SASH_WEIGHTS = new int[]{55, 45};
    private TreeViewer threadViewer;
    StackTraceViewer stackTraceViewer;

    public ThreadSashForm(Composite parent, IActionBars actionBars) {
        super(parent, actionBars, SASH_WEIGHTS);
        this.createSashFormControls(this, actionBars);
        this.setWeights(this.initialSashWeights);
    }

    @Override
    protected void createSashFormControls(SashForm sashForm, IActionBars actionBars) {
        this.threadViewer = new ThreadFilteredTree((Composite)sashForm, actionBars).getViewer();
        this.threadViewer.setContentProvider((IContentProvider)new ThreadContentProvider(this.threadViewer));
        this.threadViewer.setLabelProvider((IBaseLabelProvider)new ThreadLabelProvider(this.threadViewer));
        this.threadViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    selection = null;
                }
                ThreadSashForm.this.stackTraceViewer.setInput(selection);
            }
        });
        this.stackTraceViewer = new StackTraceViewer((Composite)sashForm, actionBars);
    }

    public void refresh() {
        if (!this.threadViewer.getControl().isDisposed()) {
            this.threadViewer.refresh();
            if (this.threadViewer.getSelection().isEmpty()) {
                TreeItem[] items = this.threadViewer.getTree().getItems();
                if (items != null && items.length > 0) {
                    this.threadViewer.getTree().select(items[0]);
                    this.stackTraceViewer.setInput(this.threadViewer.getSelection());
                } else {
                    this.stackTraceViewer.setInput(null);
                }
            }
        }
        if (!this.stackTraceViewer.getControl().isDisposed()) {
            this.stackTraceViewer.refresh();
        }
    }

    public void setInput(IThreadInput threadInput) {
        this.threadViewer.setInput((Object)threadInput);
    }
}

