/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.thread;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.IThreadElement;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.ui.RefreshJob;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.RefreshAction;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.ToggleOrientationAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.DumpThreadsAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.IThreadInput;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.thread.ThreadSashForm;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class ThreadsSection
extends AbstractJvmPropertySection {
    private static final String LAYOUT_MENU_ID = "layout";
    ThreadSashForm sashForm;
    DumpThreadsAction dumpThreadsAction;
    RefreshAction refreshAction;
    private Separator separator;
    private MenuManager layoutMenu;

    public ThreadsSection() {
        this.createActions();
    }

    public void refresh() {
        if (!this.isSectionActivated) {
            return;
        }
        new RefreshJob(NLS.bind((String)Messages.refreshThreadsSectionJobLabel, (Object)this.getJvm().getPid()), ((Object)((Object)this)).toString()){

            @Override
            protected void refreshModel(IProgressMonitor monitor) {
                IActiveJvm jvm = ThreadsSection.this.getJvm();
                if (jvm != null && jvm.isConnected() && !ThreadsSection.this.isRefreshSuspended()) {
                    try {
                        jvm.getMBeanServer().refreshThreadCache();
                    }
                    catch (JvmCoreException e) {
                        Activator.log(null, (CoreException)((Object)e));
                    }
                }
            }

            @Override
            protected void refreshUI() {
                IActiveJvm jvm = ThreadsSection.this.getJvm();
                boolean isConnected = jvm != null && jvm.isConnected();
                ThreadsSection.this.dumpThreadsAction.setEnabled(!ThreadsSection.this.hasErrorMessage());
                ThreadsSection.this.refreshAction.setEnabled(isConnected);
                if (ThreadsSection.this.sashForm != null && !ThreadsSection.this.sashForm.isDisposed()) {
                    ThreadsSection.this.refreshBackground(ThreadsSection.this.sashForm.getChildren(), isConnected);
                    ThreadsSection.this.sashForm.refresh();
                }
            }
        }.schedule();
    }

    @Override
    protected void createControls(Composite parent) {
        this.sashForm = new ThreadSashForm(parent, this.getActionBars());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.fusesource.ide.jvmmonitor.ui.threads_page_content");
    }

    @Override
    protected void setInput(IWorkbenchPart part, ISelection selection, final IActiveJvm newJvm, IActiveJvm oldJvm) {
        this.sashForm.setInput(new IThreadInput(){

            @Override
            public IThreadElement[] getThreadListElements() {
                return newJvm.getMBeanServer().getThreadCache();
            }
        });
    }

    @Override
    protected void addToolBarActions(IToolBarManager manager) {
        manager.insertAfter("defaults", (IContributionItem)this.separator);
        if (manager.find(this.refreshAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.refreshAction);
        }
        if (manager.find(this.dumpThreadsAction.getId()) == null) {
            manager.insertAfter("defaults", (IAction)this.dumpThreadsAction);
        }
    }

    @Override
    protected void removeToolBarActions(IToolBarManager manager) {
        manager.remove((IContributionItem)this.separator);
        manager.remove(this.refreshAction.getId());
        manager.remove(this.dumpThreadsAction.getId());
    }

    @Override
    protected void addLocalMenus(IMenuManager manager) {
        if (manager.find(this.layoutMenu.getId()) == null) {
            manager.add((IContributionItem)this.layoutMenu);
            if (this.sashForm != null && !this.sashForm.isDisposed()) {
                List<ToggleOrientationAction> orientationActions = this.sashForm.getOrientationActions();
                for (ToggleOrientationAction action : orientationActions) {
                    if (action == null || this.layoutMenu.find(action.getId()) != null) continue;
                    this.layoutMenu.add((IAction)action);
                }
            }
        }
    }

    @Override
    protected void removeLocalMenus(IMenuManager manager) {
        manager.remove((IContributionItem)this.layoutMenu);
    }

    @Override
    protected void deactivateSection() {
        super.deactivateSection();
        Job.getJobManager().cancel((Object)((Object)((Object)this)).toString());
        IToolBarManager manager = this.getActionBars().getToolBarManager();
        this.removeToolBarActions(manager);
    }

    private void createActions() {
        this.dumpThreadsAction = new DumpThreadsAction(this);
        this.refreshAction = new RefreshAction(this);
        this.separator = new Separator();
        this.layoutMenu = new MenuManager(Messages.layoutLabel, LAYOUT_MENU_ID);
    }
}

