/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.RGB;
import org.fusesource.ide.jvmmonitor.core.Activator;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.JMXUtils;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanDomain;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanName;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.mbean.MBeanType;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.AttributeNode;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;

public class AttributeContentProvider
implements ITreeContentProvider {
    protected Map<String, MBeanDomain> domains = new HashMap<String, MBeanDomain>();
    protected Map<ObjectName, List<AttributeNode>> attributes = new HashMap<ObjectName, List<AttributeNode>>();

    public Object[] getElements(Object inputElement) {
        return this.domains.values().toArray(new MBeanDomain[0]);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MBeanDomain) {
            return ((MBeanDomain)parentElement).getMBeanTypes();
        }
        ObjectName objectName = null;
        if (parentElement instanceof MBeanType) {
            Object[] names = ((MBeanType)parentElement).getMBeanNames();
            if (names.length > 1) {
                return names;
            }
            if (names.length == 1) {
                objectName = ((MBeanName)names[0]).getObjectName();
            }
        }
        if (parentElement instanceof MBeanName) {
            objectName = ((MBeanName)parentElement).getObjectName();
        }
        if (objectName != null) {
            return this.attributes.get(objectName).toArray(new AttributeNode[0]);
        }
        if (parentElement instanceof AttributeNode) {
            return ((AttributeNode)parentElement).getChildren().toArray(new AttributeNode[0]);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof MBeanType) {
            return ((MBeanType)element).getMBeanDomain();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MBeanDomain) {
            return true;
        }
        ObjectName objectName = null;
        if (element instanceof MBeanType) {
            MBeanName[] names = ((MBeanType)element).getMBeanNames();
            if (names.length > 1) {
                return true;
            }
            if (names.length == 1) {
                objectName = names[0].getObjectName();
            }
        }
        if (element instanceof MBeanName) {
            objectName = ((MBeanName)element).getObjectName();
        }
        if (objectName != null) {
            List<AttributeNode> list = this.attributes.get(objectName);
            return list != null && list.size() > 0;
        }
        if (element instanceof AttributeNode) {
            return ((AttributeNode)element).hasChildren();
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.domains.clear();
    }

    public void refresh(IActiveJvm jvm) {
        this.domains = new HashMap<String, MBeanDomain>();
        for (ObjectName objectName : this.getObjectNames(jvm)) {
            MBeanName mBeanName;
            MBeanInfo mBeanInfo = this.getMBeanInfo(jvm, objectName);
            if (mBeanInfo == null) continue;
            ArrayList<AttributeNode> mBeanAttributes = new ArrayList<AttributeNode>();
            Object[] objectArray = mBeanInfo.getAttributes();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                MBeanAttributeInfo attributeInfo = objectArray[n2];
                String attributeName = attributeInfo.getName();
                Object value = this.getContents(jvm, objectName, attributeName);
                this.addAttributeRoots(mBeanAttributes, new AttributeNode(attributeName, null, objectName), value);
                ++n2;
            }
            objectArray = mBeanAttributes.toArray(new AttributeNode[0]);
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object node = objectArray[n2];
                this.validateAttributes((AttributeNode)node);
                if (((AttributeNode)node).getChildren().size() == 0 && !((AttributeNode)node).isValidLeaf()) {
                    mBeanAttributes.remove(node);
                }
                ++n2;
            }
            if (mBeanAttributes.size() == 0) continue;
            this.attributes.put(objectName, mBeanAttributes);
            String domainName = objectName.getDomain();
            MBeanDomain domain = this.domains.containsKey(domainName) ? this.domains.get(domainName) : new MBeanDomain(domainName);
            this.domains.put(domainName, domain);
            String typeName = JMXUtils.getTypeName(objectName);
            MBeanType type = domain.getMBeanType(typeName);
            if (type == null) {
                type = new MBeanType(jvm, typeName, domain);
                domain.putMBeanType(typeName, type);
            }
            if ((mBeanName = type.getMBeanName(objectName)) == null) {
                MBeanInfo info = this.getMBeanInfo(jvm, objectName);
                mBeanName = new MBeanName(objectName, jvm, info.getNotifications().length > 0);
            }
            type.addMBeanName(mBeanName);
        }
    }

    private void validateAttributes(AttributeNode node) {
        AttributeNode[] nodes = node.getChildren().toArray(new AttributeNode[0]);
        if (nodes.length == 0 && !node.isValidLeaf()) {
            node.remove();
        }
        AttributeNode[] attributeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeNode child = attributeNodeArray[n2];
            this.validateAttributes(child);
            ++n2;
        }
        nodes = node.getChildren().toArray(new AttributeNode[0]);
        if (nodes.length == 0 && !node.isValidLeaf()) {
            node.remove();
        }
    }

    private void addAttributeRoots(List<AttributeNode> mBeanAttributes, AttributeNode root, Object value) {
        if (value instanceof CompositeData) {
            mBeanAttributes.add(root);
            CompositeData compositeData = (CompositeData)value;
            CompositeType type = compositeData.getCompositeType();
            for (String key : type.keySet()) {
                AttributeNode attribute = new AttributeNode(key, root);
                root.addChild(attribute);
                this.addAttributeItems(attribute, compositeData.get(key));
            }
        } else if (value instanceof TabularData) {
            mBeanAttributes.add(root);
            TabularData tabularData = (TabularData)value;
            for (Object keyList : tabularData.keySet()) {
                Object[] keys = ((List)keyList).toArray(new Object[0]);
                AttributeNode attribute = new AttributeNode(String.valueOf(keys[0]), root);
                root.addChild(attribute);
                this.addAttributeItems(attribute, tabularData.get(keys));
            }
        } else if (value instanceof Long || value instanceof Integer || value instanceof Double) {
            root.setValidLeaf(true);
            root.setRgb(this.getRGB(root.getQualifiedName()));
            mBeanAttributes.add(root);
        }
    }

    private RGB getRGB(String string) {
        int hashCode = string.hashCode();
        int r = (hashCode >> 3) % 256;
        int g = (hashCode >> 1) % 256;
        int b = hashCode % 256;
        return new RGB(Math.abs(r), Math.abs(g), Math.abs(b));
    }

    private void addAttributeItems(AttributeNode parent, Object value) {
        if (value instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)value;
            CompositeType type = compositeData.getCompositeType();
            for (String key : type.keySet()) {
                AttributeNode attribute = new AttributeNode(key, parent);
                parent.addChild(attribute);
                this.addAttributeItems(attribute, compositeData.get(key));
            }
        } else if (value instanceof TabularData) {
            TabularData tabularData = (TabularData)value;
            for (Object keyList : tabularData.keySet()) {
                Object[] keys = ((List)keyList).toArray(new Object[0]);
                AttributeNode attribute = new AttributeNode(String.valueOf(keys[0]), parent);
                parent.addChild(attribute);
                this.addAttributeItems(attribute, tabularData.get(keys));
            }
        } else if (value instanceof Long || value instanceof Integer || value instanceof Double) {
            parent.setRgb(this.getRGB(parent.getQualifiedName()));
            parent.setValidLeaf(true);
        }
    }

    private Set<ObjectName> getObjectNames(IActiveJvm jvm) {
        try {
            return jvm.getMBeanServer().queryNames(null);
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.getMBeanNamesFailedMsg, (Throwable)e);
            return new HashSet<ObjectName>();
        }
    }

    private MBeanInfo getMBeanInfo(IActiveJvm jvm, ObjectName objectName) {
        try {
            return jvm.getMBeanServer().getMBeanInfo(objectName);
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.getMBeanInfoFailedMsg, (Throwable)e);
            return null;
        }
    }

    private Object getContents(IActiveJvm jvm, ObjectName objectName, String attributeName) {
        try {
            return jvm.getMBeanServer().getAttribute(objectName, attributeName);
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.getMBeanAttributeFailedMsg, (Throwable)e);
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            return null;
        }
        return null;
    }
}

