/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.AttributeContentProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.AttributeLabelProvider;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.AttributeNode;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;

public class AttributeSelectionDialog
extends Dialog {
    private ArrayList<MBeanAttribute> selectedAttributes;
    TreeViewer viewer;
    private IActiveJvm jvm;
    private ColorSelector colorSelector;

    protected AttributeSelectionDialog(Shell shell, IActiveJvm jvm) {
        super(shell);
        this.jvm = jvm;
        this.selectedAttributes = new ArrayList();
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.attributeSelectionDialogTitle);
        this.getShell().setSize(500, 600);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.fusesource.ide.jvmmonitor.ui.attribute_selection_dialog_content");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.attributesToAddOnChartLabel);
        this.createMBeanViewer(composite);
        AttributeSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof AttributeNode) {
                AttributeNode node = (AttributeNode)item;
                MBeanAttribute mBeanAttribute = new MBeanAttribute(node.getObjectName(), node.getQualifiedName(), node.getRgb());
                this.selectedAttributes.add(mBeanAttribute);
            }
            ++n2;
        }
        super.okPressed();
    }

    public List<MBeanAttribute> getSelectedAttributes() {
        return this.selectedAttributes;
    }

    private void createMBeanViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.viewer = new MyFilteredTree(composite).getViewer();
        AttributeContentProvider mBeanContentProvider = new AttributeContentProvider();
        this.viewer.setContentProvider((IContentProvider)mBeanContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new MyDecoratingStyledCellLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AttributeSelectionDialog.this.viewerSlectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        this.viewer.setInput((Object)this.jvm);
        mBeanContentProvider.refresh(this.jvm);
        this.viewer.refresh();
        this.viewer.expandToLevel(2);
        new Label(composite, 0).setText(Messages.colorLabel);
        this.colorSelector = this.createColorSelector(composite);
    }

    private ColorSelector createColorSelector(Composite parent) {
        final ColorSelector selector = new ColorSelector(parent);
        selector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AttributeSelectionDialog.this.viewer.getSelection();
                AttributeNode attribute = (AttributeNode)selection.getFirstElement();
                if (attribute != null) {
                    attribute.setRgb(selector.getColorValue());
                }
            }
        });
        selector.setEnabled(false);
        return selector;
    }

    void viewerSlectionChanged(IStructuredSelection selection) {
        AttributeNode attribute;
        Object element = selection.getFirstElement();
        if (element instanceof AttributeNode && (attribute = (AttributeNode)element).isValidLeaf()) {
            this.colorSelector.setEnabled(true);
            this.colorSelector.setColorValue(attribute.getRgb());
            return;
        }
        this.colorSelector.setEnabled(false);
    }

    private static class MyDecoratingStyledCellLabelProvider
    extends DecoratingStyledCellLabelProvider
    implements ILabelProvider {
        public MyDecoratingStyledCellLabelProvider() {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AttributeLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        }

        public String getText(Object element) {
            return this.getStyledStringProvider().getStyledText(element).toString();
        }
    }

    public static class MyFilteredTree
    extends FilteredTree {
        protected MyFilteredTree(Composite parent) {
            super(parent, 67586, new PatternFilter(), true);
            this.setBackground(Display.getDefault().getSystemColor(1));
        }

        protected void createControl(Composite composite, int treeStyle) {
            super.createControl(composite, treeStyle);
            GridData data = (GridData)this.filterComposite.getLayoutData();
            data.horizontalIndent = 2;
            data.verticalIndent = 2;
            this.filterComposite.setLayoutData((Object)data);
        }
    }
}

