/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttribute;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.MBeanAttributeColumn;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class MBeanAttributeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image attributeImage;
    private Image mBeanImage;
    private TreeViewer viewer;

    public MBeanAttributeLabelProvider(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == this.getColumnIndex(MBeanAttributeColumn.Attribute)) {
            return this.getAttributeImage();
        }
        if (columnIndex == this.getColumnIndex(MBeanAttributeColumn.ObjectName)) {
            return this.getMBeanImage();
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof MBeanAttribute) {
            return this.getColumnText((MBeanAttribute)element, columnIndex);
        }
        throw new IllegalArgumentException("unknown input");
    }

    public String getText(Object obj) {
        if (obj instanceof MBeanAttribute) {
            return this.getColumnText((MBeanAttribute)obj, this.getColumnIndex(MBeanAttributeColumn.Attribute));
        }
        return super.getText(obj);
    }

    public void dispose() {
        if (this.attributeImage != null) {
            this.attributeImage.dispose();
        }
        if (this.mBeanImage != null) {
            this.mBeanImage.dispose();
        }
    }

    private String getColumnText(MBeanAttribute attribute, int columnIndex) {
        if (columnIndex == this.getColumnIndex(MBeanAttributeColumn.ObjectName)) {
            return attribute.getObjectName().getCanonicalName();
        }
        if (columnIndex == this.getColumnIndex(MBeanAttributeColumn.Attribute)) {
            return attribute.getAttributeName();
        }
        throw new IllegalArgumentException("unknown column");
    }

    private int getColumnIndex(MBeanAttributeColumn column) {
        Tree tree = this.viewer.getTree();
        int i = 0;
        while (i < tree.getColumnCount()) {
            if (tree.getColumn(i).getText().equals(column.label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Image getAttributeImage() {
        if (this.attributeImage == null || this.attributeImage.isDisposed()) {
            this.attributeImage = Activator.getImageDescriptor("icons/full/obj16/attribute.gif").createImage();
        }
        return this.attributeImage;
    }

    private Image getMBeanImage() {
        if (this.mBeanImage == null || this.mBeanImage.isDisposed()) {
            this.mBeanImage = Activator.getImageDescriptor("icons/full/obj16/mbean.gif").createImage();
        }
        return this.mBeanImage;
    }
}

