/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanAttribute;
import org.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.AbstractJvmPropertySection;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.AbstractChartSetAction;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.Messages;
import org.fusesource.ide.jvmmonitor.internal.ui.properties.timeline.SaveChartSetAsDialog;
import org.fusesource.ide.jvmmonitor.ui.Activator;

public class SaveChartSetAsAction
extends AbstractChartSetAction {
    public SaveChartSetAsAction(AbstractJvmPropertySection section) {
        super(section);
        this.setText(Messages.saveChartSetAsLabel);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT"));
    }

    public void run() {
        SaveChartSetAsDialog dialog;
        try {
            dialog = new SaveChartSetAsDialog(this.section.getPart().getSite().getShell(), this.getChartSets(), this.getPredefinedChartSets());
        }
        catch (WorkbenchException e) {
            Activator.log(4, Messages.openSaveChartSetAsDialogFailedMsg, e);
            return;
        }
        catch (IOException e) {
            Activator.log(4, Messages.openSaveChartSetAsDialogFailedMsg, e);
            return;
        }
        if (dialog.open() == 0) {
            try {
                this.performSave(dialog.getChartSet(), dialog.getChartSets());
            }
            catch (WorkbenchException e) {
                Activator.log(4, Messages.saveChartSetFailedMsg, e);
            }
            catch (IOException e) {
                Activator.log(4, Messages.saveChartSetFailedMsg, e);
            }
        }
    }

    private void performSave(String newChartSet, List<String> chartSets) throws WorkbenchException, IOException {
        IMemento oldChartSetsMemento = this.getChartSetsMemento();
        IMemento[] oldMementos = oldChartSetsMemento == null ? new IMemento[]{} : oldChartSetsMemento.getChildren("ChartSet");
        XMLMemento chartSetsMemento = XMLMemento.createWriteRoot((String)"ChartSets");
        block0: for (String chartSet : chartSets) {
            IMemento[] iMementoArray = oldMementos;
            int n = oldMementos.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento memento = iMementoArray[n2];
                if (chartSet.equals(memento.getID()) && !chartSet.equals(newChartSet)) {
                    chartSetsMemento.createChild("ChartSet").putMemento(memento);
                    continue block0;
                }
                ++n2;
            }
        }
        this.addNewChartSet(chartSetsMemento, newChartSet);
        StringWriter writer = new StringWriter();
        chartSetsMemento.save((Writer)writer);
        Activator.getDefault().getPreferenceStore().setValue("ChartSets", writer.getBuffer().toString());
    }

    private void addNewChartSet(XMLMemento memento, String chartSet) {
        IMemento chartSetMemento = memento.createChild("ChartSet", chartSet);
        for (IMonitoredMXBeanGroup group : this.section.getJvm().getMBeanServer().getMonitoredAttributeGroups()) {
            IMemento groupMemento = chartSetMemento.createChild("Group", group.getName());
            groupMemento.putString("Unit", group.getAxisUnit().name());
            for (IMonitoredMXBeanAttribute attribute : group.getAttributes()) {
                IMemento attributeMemento = groupMemento.createChild("Attribute", attribute.getAttributeName());
                attributeMemento.putString("ObjectName", attribute.getObjectName().getCanonicalName());
                attributeMemento.putString("Color", this.getRGBString(attribute.getRGB()));
            }
        }
    }

    private String getRGBString(int[] rgb) {
        return new StringBuffer().append(rgb[0]).append(',').append(rgb[1]).append(',').append(rgb[2]).toString();
    }
}

