/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.jvmmonitor.internal.ui.actions.PreferencesAction;
import org.fusesource.ide.jvmmonitor.internal.ui.views.JvmTreeViewer;
import org.fusesource.ide.jvmmonitor.internal.ui.views.NewJvmConnectionAction;

public class JvmExplorer
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    private JvmTreeViewer treeViewer;

    public void createPartControl(Composite parent) {
        this.treeViewer = new JvmTreeViewer(parent, 770, this.getViewSite().getActionBars());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.createLocalToolBar();
        this.createLocalMenus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.treeViewer.getControl(), "org.fusesource.ide.jvmmonitor.ui.jvm_explorer_view_conent");
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.treeViewer != null) {
            this.treeViewer.dispose();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage(this){

                public void resizeScrolledComposite() {
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    protected ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    private void createLocalToolBar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IAction)new NewJvmConnectionAction(this.treeViewer));
        manager.update(false);
    }

    private void createLocalMenus() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new PreferencesAction());
        manager.update(false);
    }
}

