/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.fusesource.ide.jvmmonitor.core.Activator;
import org.fusesource.ide.jvmmonitor.core.IActiveJvm;
import org.fusesource.ide.jvmmonitor.core.IHost;
import org.fusesource.ide.jvmmonitor.core.IJvm;
import org.fusesource.ide.jvmmonitor.core.ISWTResourceMonitor;
import org.fusesource.ide.jvmmonitor.core.IThreadElement;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.core.JvmModel;
import org.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import org.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import org.fusesource.ide.jvmmonitor.internal.core.AbstractJvm;
import org.fusesource.ide.jvmmonitor.internal.core.Host;
import org.fusesource.ide.jvmmonitor.internal.core.MBeanServer;
import org.fusesource.ide.jvmmonitor.internal.core.Messages;
import org.fusesource.ide.jvmmonitor.internal.core.SWTResourceMonitor;
import org.fusesource.ide.jvmmonitor.internal.core.Util;
import org.fusesource.ide.jvmmonitor.internal.core.cpu.CpuProfiler;

public class ActiveJvm
extends AbstractJvm
implements IActiveJvm {
    private static final String URL_PATH = "/jndi/rmi://%s:%d/jmxrmi";
    private static final String RMI_PROTOCOL = "rmi";
    private static final String MAIN_THREAD = "main";
    private boolean isAttachSupported;
    private String errorStateMessage;
    private boolean isRemote;
    private boolean isConnected;
    private MBeanServer mBeanServer;
    private ICpuProfiler cpuProfiler;
    private ISWTResourceMonitor swtResourceMonitor;

    public ActiveJvm(int pid, String url, IHost host) throws JvmCoreException {
        super(pid, host);
        this.isRemote = false;
        JMXServiceURL jmxUrl = null;
        try {
            if (url != null) {
                jmxUrl = new JMXServiceURL(url);
                this.isAttachSupported = true;
            }
        }
        catch (MalformedURLException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getJmxServiceUrlForPidFailedMsg, (Object)pid), e);
        }
        this.initialize(jmxUrl);
        this.saveJvmProperties();
    }

    public ActiveJvm(int port, String userName, String password, IHost host, int updatePeriod) throws JvmCoreException {
        super(port, userName, password, host);
        this.isRemote = true;
        String urlPath = String.format(URL_PATH, host.getName(), port);
        JMXServiceURL url = null;
        try {
            url = new JMXServiceURL(RMI_PROTOCOL, "", 0, urlPath);
            this.isAttachSupported = true;
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getJmxServiceUrlForPortFailedMsg, (Object)port), e);
        }
        this.initialize(url);
        this.connect(updatePeriod);
        this.refreshPid();
        this.refreshMainClass();
        this.refreshSnapshots();
        this.disconnect();
        this.saveJvmProperties();
    }

    public ActiveJvm(String url, String userName, String password, int updatePeriod) throws JvmCoreException {
        super(userName, password);
        this.isRemote = true;
        JMXServiceURL jmxUrl = null;
        try {
            jmxUrl = new JMXServiceURL(url);
            this.isAttachSupported = true;
        }
        catch (MalformedURLException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getJmxServiceUrlForUrlFailedMsg, (Object)url), e);
        }
        this.initialize(jmxUrl);
        this.connect(updatePeriod);
        this.refreshPid();
        this.refreshMainClass();
        boolean jvmAddedToHost = this.refreshHost();
        this.disconnect();
        if (jvmAddedToHost) {
            this.refreshSnapshots();
        }
    }

    @Override
    public void connect(int updatePeriod) throws JvmCoreException {
        if (!this.isAttachSupported) {
            throw new IllegalStateException(Messages.attachNotSupportedMsg);
        }
        this.mBeanServer.connect(updatePeriod);
        this.isConnected = true;
        if (!this.isRemote) {
            JvmModel.getInstance().getAgentLoadHandler().loadAgent(this);
        }
        if (this.swtResourceMonitor.isSupported()) {
            this.swtResourceMonitor.setTracking(true);
        }
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmConnected, this));
    }

    @Override
    public void disconnect() {
        this.isConnected = false;
        this.mBeanServer.dispose();
        try {
            if (this.swtResourceMonitor.isSupported()) {
                this.swtResourceMonitor.setTracking(false);
            }
        }
        catch (JvmCoreException jvmCoreException) {}
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmDisconnected, this));
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public boolean isConnectionSupported() {
        return this.isAttachSupported;
    }

    @Override
    public String getErrorStateMessage() {
        return this.errorStateMessage;
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    @Override
    public ICpuProfiler getCpuProfiler() {
        return this.cpuProfiler;
    }

    @Override
    public ISWTResourceMonitor getSWTResourceMonitor() {
        return this.swtResourceMonitor;
    }

    public String toString() {
        return this.getMainClass();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveJvmProperties() {
        IFileStore fileStore;
        try {
            fileStore = Util.getFileStore("properties.xml", this.getBaseDirectory());
            if (fileStore.fetchInfo().exists()) {
                return;
            }
        }
        catch (JvmCoreException e) {
            Activator.log(4, Messages.savePropertiesFileFailedMsg, (Throwable)((Object)e));
            return;
        }
        Properties props = new Properties();
        OutputStream os = null;
        try {
            os = fileStore.openOutputStream(0, null);
            int pid = this.getPid();
            int port = this.getPort();
            String mainClass = this.getMainClass();
            props.setProperty("Pid", String.valueOf(pid));
            props.setProperty("Port", String.valueOf(port));
            if (mainClass != null) {
                props.setProperty("MainClass", mainClass);
            }
            props.setProperty("Host", this.getHost().getName());
            props.storeToXML(os, "JVM Properties");
        }
        catch (CoreException e) {
            Activator.log(4, NLS.bind((String)Messages.openOutputStreamFailedMsg, (Object)fileStore.toURI().getPath()), e);
            if (os == null) return;
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            try {
                try {
                    fileStore.delete(0, null);
                }
                catch (CoreException coreException) {}
                Activator.log(4, NLS.bind((String)Messages.writePropertiesFileFailedMsg, (Object)fileStore.toURI().getPath()), e);
                if (os == null) return;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected void setErrorStateMessage(String errorStateMessage) {
        this.errorStateMessage = errorStateMessage;
    }

    private void initialize(JMXServiceURL url) {
        this.isConnected = false;
        this.cpuProfiler = new CpuProfiler(this);
        this.mBeanServer = new MBeanServer(url, this);
        this.swtResourceMonitor = new SWTResourceMonitor(this);
    }

    private void refreshPid() throws JvmCoreException {
        String[] elements = this.mBeanServer.getRuntimeName().split("@");
        if (elements == null || elements.length != 2) {
            throw new JvmCoreException(4, Messages.getPidFailedMsg, new Exception());
        }
        this.setPid(Integer.valueOf(elements[0]));
    }

    private boolean refreshHost() throws JvmCoreException {
        String[] elements = this.mBeanServer.getRuntimeName().split("@");
        if (elements == null || elements.length != 2) {
            throw new JvmCoreException(4, Messages.getHostNameFailedMsg, new Exception());
        }
        String hostName = elements[1];
        Host host = (Host)JvmModel.getInstance().getHost(hostName);
        if (host == null) {
            host = new Host(hostName);
        } else {
            for (IJvm iJvm : host.getActiveJvms()) {
                if (iJvm.getPid() != this.getPid()) continue;
                return false;
            }
        }
        host.addActiveJvm(this);
        this.setHost(host);
        return true;
    }

    private void refreshMainClass() throws JvmCoreException {
        this.mBeanServer.refreshThreadCache();
        IThreadElement[] iThreadElementArray = this.mBeanServer.getThreadCache();
        int n = iThreadElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IThreadElement element = iThreadElementArray[n2];
            if (element.getThreadName().equals(MAIN_THREAD)) {
                StackTraceElement[] elements = element.getStackTraceElements();
                if (elements == null || elements.length == 0) {
                    return;
                }
                StackTraceElement lastElement = elements[elements.length - 1];
                this.setMainClass(lastElement.getClassName());
                break;
            }
            ++n2;
        }
    }
}

