/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.fusesource.ide.jvmmonitor.core.IHeapElement;
import org.fusesource.ide.jvmmonitor.core.dump.IProfileInfo;
import org.fusesource.ide.jvmmonitor.internal.core.HeapElement;
import org.fusesource.ide.jvmmonitor.internal.core.ProfileInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HeapDumpSaxEventHandler
extends DefaultHandler {
    private IProgressMonitor monitor;
    private List<IHeapElement> heapListElements;
    private IProfileInfo info;

    public HeapDumpSaxEventHandler(List<IHeapElement> heapListElements, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.heapListElements = heapListElements;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if ("heap-profile".equals(name)) {
            String date = attributes.getValue("date");
            String runtime = attributes.getValue("runtime");
            String mainClass = attributes.getValue("mainClass");
            String arguments = attributes.getValue("arguments");
            String comments = attributes.getValue("comments");
            this.info = new ProfileInfo(date, runtime, mainClass, arguments, comments);
        }
        if ("class".equals(name)) {
            String className = attributes.getValue("name");
            String size = attributes.getValue("size");
            String count = attributes.getValue("count");
            String baseSize = attributes.getValue("baseSize");
            HeapElement element = new HeapElement(className, Long.parseLong(size), Long.parseLong(count), Long.parseLong(baseSize));
            this.heapListElements.add(element);
        }
    }

    public IProfileInfo getProfileInfo() {
        return this.info;
    }
}

