/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.core.JvmModel;
import org.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import org.fusesource.ide.jvmmonitor.core.mbean.IMBeanNotification;
import org.fusesource.ide.jvmmonitor.internal.core.ActiveJvm;

public class MBeanNotification
implements IMBeanNotification {
    private ActiveJvm activeJvm;
    private Map<ObjectName, NotificationListener> listeners;
    protected Map<ObjectName, List<Notification>> notifications;

    public MBeanNotification(ActiveJvm activeJvm) {
        this.activeJvm = activeJvm;
        this.listeners = new HashMap<ObjectName, NotificationListener>();
        this.notifications = new LinkedHashMap<ObjectName, List<Notification>>();
    }

    @Override
    public void subscribe(final ObjectName objectName) throws JvmCoreException {
        NotificationListener listener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                List<Notification> list = MBeanNotification.this.notifications.get(objectName);
                if (list == null) {
                    list = new ArrayList<Notification>();
                }
                list.add(new DecoratedNotification(notification));
                MBeanNotification.this.notifications.put(objectName, list);
            }
        };
        this.activeJvm.getMBeanServer().addNotificationListener(objectName, listener);
        this.listeners.put(objectName, listener);
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmModified, this.activeJvm));
    }

    @Override
    public void unsubscribe(ObjectName objectName) throws JvmCoreException {
        NotificationListener listener = this.listeners.get(objectName);
        this.activeJvm.getMBeanServer().removeNotificationListener(objectName, listener);
        this.listeners.remove(objectName);
        this.notifications.remove(objectName);
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmModified, this.activeJvm));
    }

    @Override
    public Notification[] getNotifications(ObjectName objectName) {
        List<Notification> list = this.notifications.get(objectName);
        if (list == null) {
            return new Notification[0];
        }
        return list.toArray(new Notification[list.size()]);
    }

    @Override
    public void clear(ObjectName objectName) {
        List<Notification> notification = this.notifications.get(objectName);
        if (notification == null) {
            return;
        }
        notification.clear();
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmModified, this.activeJvm));
    }

    @Override
    public boolean isSubscribed(ObjectName objectName) {
        return this.listeners.containsKey(objectName);
    }

    @Override
    public boolean isSupported(ObjectName objectName) {
        MBeanInfo info = null;
        try {
            info = this.activeJvm.getMBeanServer().getMBeanInfo(objectName);
        }
        catch (JvmCoreException jvmCoreException) {
            return false;
        }
        if (info == null) {
            return false;
        }
        MBeanNotificationInfo[] notificationInfoArray = info.getNotifications();
        return notificationInfoArray != null && notificationInfoArray.length != 0;
    }

    public void dispose() {
        for (Map.Entry<ObjectName, NotificationListener> entry : this.listeners.entrySet()) {
            try {
                this.unsubscribe(entry.getKey());
            }
            catch (JvmCoreException jvmCoreException) {}
        }
        this.listeners.clear();
        this.notifications.clear();
    }

    private static class DecoratedNotification
    extends Notification {
        private static final long serialVersionUID = 1L;
        private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";

        public DecoratedNotification(Notification notification) {
            super(notification.getType(), notification.getSource(), notification.getSequenceNumber(), notification.getTimeStamp(), notification.getMessage());
            this.setUserData(notification.getUserData());
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(new SimpleDateFormat(DATE_FORMAT).format(new Date(this.getTimeStamp()))).append('\n');
            buffer.append("Sequence Number: ").append(this.getSequenceNumber()).append('\n');
            buffer.append("Source: ").append(this.getSource()).append('\n');
            buffer.append("Type: ").append(this.getType()).append('\n').append('\n');
            buffer.append(this.getMessage()).append('\n');
            this.parseObject(buffer, this.getUserData(), 0);
            return buffer.toString();
        }

        protected void parseObject(StringBuffer buffer, Object object, int indentation) {
            int indent = 0;
            if (object instanceof CompositeData) {
                CompositeData compositeData = (CompositeData)object;
                for (String key : compositeData.getCompositeType().keySet()) {
                    Object value = compositeData.get(key);
                    if (value instanceof CompositeData) {
                        buffer.append(key).append(":\n");
                        this.parseObject(buffer, value, ++indent);
                        continue;
                    }
                    int i = 0;
                    while (i < indent) {
                        buffer.append('\t');
                        ++i;
                    }
                    buffer.append(key).append(": ").append(value).append('\n');
                }
            }
        }
    }
}

