/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanAttribute;
import org.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import org.fusesource.ide.jvmmonitor.core.mbean.MBeanServerEvent;
import org.fusesource.ide.jvmmonitor.internal.core.MBeanServer;
import org.fusesource.ide.jvmmonitor.internal.core.MonitoredMXBeanAttribute;

public class MonitoredMXBeanGroup
implements IMonitoredMXBeanGroup {
    private MBeanServer mBeanServer;
    private String name;
    private IMonitoredMXBeanGroup.AxisUnit axisUnit;
    private List<IMonitoredMXBeanAttribute> attributes;

    public MonitoredMXBeanGroup(MBeanServer mBeanServer, String name, IMonitoredMXBeanGroup.AxisUnit axisUnit) {
        this.mBeanServer = mBeanServer;
        this.name = name;
        this.axisUnit = axisUnit;
        this.attributes = new ArrayList<IMonitoredMXBeanAttribute>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IMonitoredMXBeanGroup.AxisUnit getAxisUnit() {
        return this.axisUnit;
    }

    @Override
    public void setAxisUnit(IMonitoredMXBeanGroup.AxisUnit axisUnit) {
        this.axisUnit = axisUnit;
    }

    @Override
    public List<IMonitoredMXBeanAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public IMonitoredMXBeanAttribute getAttribute(ObjectName objectName, String attributeName) {
        for (IMonitoredMXBeanAttribute attribute : this.attributes) {
            if (!attribute.getObjectName().equals(objectName) || !attribute.getAttributeName().equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void addAttribute(String objectNameString, String attributeName, int[] rgb) throws JvmCoreException {
        for (IMonitoredMXBeanAttribute attribute : this.attributes) {
            if (!attribute.getAttributeName().equals(attributeName) || !attribute.getObjectName().getCanonicalName().equals(objectNameString)) continue;
            return;
        }
        this.addAttribute(objectNameString, attributeName, rgb, true);
    }

    @Override
    public void removeAttribute(String objectName, String attributeName) {
        IMonitoredMXBeanAttribute targetAttribute = null;
        for (IMonitoredMXBeanAttribute attribute : this.attributes) {
            if (!attribute.getObjectName().getCanonicalName().equals(objectName) || !attribute.getAttributeName().equals(attributeName)) continue;
            targetAttribute = attribute;
            break;
        }
        if (targetAttribute != null) {
            this.attributes.remove(targetAttribute);
            this.mBeanServer.fireMBeanServerChangeEvent(new MBeanServerEvent(MBeanServerEvent.MBeanServerState.MonitoredAttributeRemoved, targetAttribute));
        }
    }

    @Override
    public void clearAttributes() {
        for (IMonitoredMXBeanAttribute attribute : this.attributes) {
            attribute.clear();
        }
    }

    protected void addAttribute(String objectNameString, String attributeName, int[] rgb, boolean fireEvent) throws JvmCoreException {
        ObjectName objectName = this.mBeanServer.getObjectName(objectNameString);
        MonitoredMXBeanAttribute attribute = new MonitoredMXBeanAttribute(objectName, attributeName, rgb);
        this.attributes.add(attribute);
        if (fireEvent) {
            this.mBeanServer.fireMBeanServerChangeEvent(new MBeanServerEvent(MBeanServerEvent.MBeanServerState.MonitoredAttributeAdded, attribute));
        }
    }
}

