/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.fusesource.ide.jvmmonitor.core.ISWTResourceElement;
import org.fusesource.ide.jvmmonitor.core.ISWTResourceMonitor;
import org.fusesource.ide.jvmmonitor.core.JvmCoreException;
import org.fusesource.ide.jvmmonitor.core.JvmModel;
import org.fusesource.ide.jvmmonitor.internal.core.ActiveJvm;
import org.fusesource.ide.jvmmonitor.internal.core.Messages;
import org.fusesource.ide.jvmmonitor.internal.core.SWTResourceElement;

public class SWTResourceMonitor
implements ISWTResourceMonitor {
    static final String SWT_RESOURCE_MONITOR_MXBEAN_NAME = "org.fusesource.ide.jvmmonitor:type=SWT Resource Monitor";
    private static final String TRACKING = "Tracking";
    private static final String RESOURCES = "Resources";
    private static final String CLEAR = "clear";
    private static final String NAME = "name";
    private static final String STACK_TRACE = "stackTrace";
    private static final String CLASS_NAME = "className";
    private static final String FILE_NAME = "fileName";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String METHOD_NAME = "methodName";
    private static final String NATIVE_METHOD = "nativeMethod";
    private ActiveJvm jvm;
    private Map<String, ISWTResourceElement> resourceElements;
    private List<ISWTResourceElement> resources;

    public SWTResourceMonitor(ActiveJvm jvm) {
        this.jvm = jvm;
        this.resourceElements = new HashMap<String, ISWTResourceElement>();
        this.resources = new ArrayList<ISWTResourceElement>();
    }

    @Override
    public void setTracking(boolean tracking) throws JvmCoreException {
        ObjectName objectName = this.validateAgent();
        if (objectName != null) {
            this.jvm.getMBeanServer().setAttribute(objectName, new Attribute(TRACKING, tracking));
        }
    }

    @Override
    public boolean isTracking() throws JvmCoreException {
        Object attribute;
        ObjectName objectName = this.validateAgent();
        if (objectName != null && (attribute = this.jvm.getMBeanServer().getAttribute(objectName, TRACKING)) instanceof Boolean) {
            return (Boolean)attribute;
        }
        return false;
    }

    @Override
    public void refreshResourcesCache() throws JvmCoreException {
        Object attribute;
        this.resources.clear();
        ObjectName objectName = this.validateAgent();
        if (objectName != null && (attribute = this.jvm.getMBeanServer().getAttribute(objectName, RESOURCES)) instanceof CompositeData[]) {
            this.resources = new ArrayList<ISWTResourceElement>(this.getSWTResourceElements((CompositeData[])attribute));
        }
    }

    @Override
    public ISWTResourceElement[] getResources() {
        return this.resources.toArray(new ISWTResourceElement[this.resources.size()]);
    }

    @Override
    public void clear() throws JvmCoreException {
        ObjectName objectName = this.validateAgent();
        if (objectName != null) {
            this.jvm.getMBeanServer().invoke(objectName, CLEAR, new Object[0], new String[0]);
        }
    }

    @Override
    public boolean isSupported() {
        ObjectName objectName;
        block3: {
            try {
                objectName = this.validateAgent();
                if (objectName != null) break block3;
                return false;
            }
            catch (JvmCoreException jvmCoreException) {
                return false;
            }
        }
        Object attribute = this.jvm.getMBeanServer().getAttribute(objectName, TRACKING);
        return attribute != null;
    }

    private ObjectName validateAgent() throws JvmCoreException {
        if (!this.jvm.isRemote() && !JvmModel.getInstance().getAgentLoadHandler().isAgentLoaded()) {
            throw new JvmCoreException(4, Messages.agentNotLoadedMsg, new Exception());
        }
        return this.jvm.getMBeanServer().getObjectName(SWT_RESOURCE_MONITOR_MXBEAN_NAME);
    }

    private Collection<ISWTResourceElement> getSWTResourceElements(CompositeData[] resourceComposites) {
        HashMap<String, ISWTResourceElement> newResourceElements = new HashMap<String, ISWTResourceElement>();
        CompositeData[] compositeDataArray = resourceComposites;
        int n = resourceComposites.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                ISWTResourceElement element;
                Object name;
                block4: {
                    CompositeData compositeData = compositeDataArray[n2];
                    name = compositeData.get(NAME);
                    if (!(name instanceof String)) break block3;
                    element = this.resourceElements.get(name);
                    if (element != null) break block4;
                    Object stackTraceElements = compositeData.get(STACK_TRACE);
                    if (!(stackTraceElements instanceof CompositeData[])) break block3;
                    element = new SWTResourceElement((String)name, this.getStackTrace((CompositeData[])stackTraceElements));
                }
                newResourceElements.put((String)name, element);
            }
            ++n2;
        }
        this.resourceElements = newResourceElements;
        return this.resourceElements.values();
    }

    private StackTraceElement[] getStackTrace(CompositeData[] stackTrace) {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        CompositeData[] compositeDataArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            CompositeData compositeData = compositeDataArray[n2];
            Object className = compositeData.get(CLASS_NAME);
            Object fileName = compositeData.get(FILE_NAME);
            Object lineNumber = compositeData.get(LINE_NUMBER);
            Object metohdName = compositeData.get(METHOD_NAME);
            Object nativeMethod = compositeData.get(NATIVE_METHOD);
            if (className instanceof String && className instanceof String && fileName instanceof String && lineNumber instanceof Integer && metohdName instanceof String && nativeMethod instanceof Boolean) {
                list.add(new StackTraceElement((String)className, (String)metohdName, (String)fileName, (Boolean)nativeMethod != false ? -2 : (Integer)lineNumber));
            }
            ++n2;
        }
        return list.toArray(new StackTraceElement[list.size()]);
    }
}

