/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jvmmonitor.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.fusesource.ide.jvmmonitor.core.IThreadElement;
import org.fusesource.ide.jvmmonitor.core.dump.IProfileInfo;
import org.fusesource.ide.jvmmonitor.internal.core.ProfileInfo;
import org.fusesource.ide.jvmmonitor.internal.core.ThreadElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ThreadDumpSaxEventHandler
extends DefaultHandler {
    private IProgressMonitor monitor;
    private List<IThreadElement> threadListElements;
    private ThreadElement currentlyParsedThread;
    private List<StackTraceElement> stackTraceElements;
    private IProfileInfo info;

    public ThreadDumpSaxEventHandler(List<IThreadElement> threadListElements, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.threadListElements = threadListElements;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if ("thread-profile".equals(name)) {
            String date = attributes.getValue("date");
            String runtime = attributes.getValue("runtime");
            String mainClass = attributes.getValue("mainClass");
            String arguments = attributes.getValue("arguments");
            String comments = attributes.getValue("comments");
            this.info = new ProfileInfo(date, runtime, mainClass, arguments, comments);
        }
        if ("thread".equals(name)) {
            String threadName = attributes.getValue("name");
            String threadState = attributes.getValue("state");
            String blockedTime = attributes.getValue("blockedTime");
            String blockedCount = attributes.getValue("blockedCount");
            String waitedTime = attributes.getValue("waitedTime");
            String waitedCount = attributes.getValue("waitedCount");
            String lockName = attributes.getValue("lock");
            String lockOwnerName = attributes.getValue("lockOwner");
            String isSuspended = attributes.getValue("suspended");
            String isDeadlocked = attributes.getValue("deadlocked");
            String cpuUsage = attributes.getValue("cpuUsage");
            this.currentlyParsedThread = new ThreadElement(threadName, Thread.State.valueOf(threadState), Long.parseLong(blockedTime), Long.parseLong(blockedCount), Long.parseLong(waitedTime), Long.parseLong(waitedCount), lockName, lockOwnerName, Boolean.parseBoolean(isSuspended), Boolean.parseBoolean(isDeadlocked), Double.parseDouble(cpuUsage));
            this.stackTraceElements = new ArrayList<StackTraceElement>();
            return;
        }
        if ("frame".equals(name)) {
            String className = attributes.getValue("class");
            String methodName = attributes.getValue("method");
            String fileName = attributes.getValue("file");
            String lineNumber = attributes.getValue("line");
            StackTraceElement element = new StackTraceElement(className, methodName, fileName.equals("null") ? null : fileName, Integer.parseInt(lineNumber));
            this.stackTraceElements.add(element);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("thread".equals(name)) {
            this.currentlyParsedThread.setStackTrace(this.stackTraceElements.toArray(new StackTraceElement[0]));
            this.threadListElements.add(this.currentlyParsedThread);
        }
    }

    public IProfileInfo getProfileInfo() {
        return this.info;
    }
}

