/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.impl.ThrottlingInflightRoutePolicy;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.InstrumentationInterceptStrategy;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.management.mbean.ManagedBrowsableEndpoint;
import org.apache.camel.management.mbean.ManagedCamelContext;
import org.apache.camel.management.mbean.ManagedComponent;
import org.apache.camel.management.mbean.ManagedConsumer;
import org.apache.camel.management.mbean.ManagedDelayer;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.management.mbean.ManagedErrorHandler;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.management.mbean.ManagedProducer;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.management.mbean.ManagedScheduledPollConsumer;
import org.apache.camel.management.mbean.ManagedSendProcessor;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedThrottler;
import org.apache.camel.management.mbean.ManagedThrottlingInflightRoutePolicy;
import org.apache.camel.management.mbean.ManagedTracer;
import org.apache.camel.model.AOPDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.Delayer;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.processor.Throttler;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAware;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManagementLifecycleStrategy
implements LifecycleStrategy,
Service {
    private static final Log LOG = LogFactory.getLog(DefaultManagementLifecycleStrategy.class);
    private final Map<Processor, KeyValueHolder<ProcessorDefinition, InstrumentationProcessor>> wrappedProcessors = new HashMap<Processor, KeyValueHolder<ProcessorDefinition, InstrumentationProcessor>>();
    private final CamelContext context;
    private boolean initialized;

    public DefaultManagementLifecycleStrategy(CamelContext context) {
        this.context = context;
    }

    @Override
    public void onContextStart(CamelContext context) {
        try {
            this.initialized = true;
            ManagedCamelContext mc = new ManagedCamelContext(context);
            mc.init(context.getManagementStrategy());
            this.getManagementStrategy().manageObject(mc);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void onContextStop(CamelContext context) {
        if (!this.initialized) {
            return;
        }
        try {
            ManagedCamelContext mc = new ManagedCamelContext(context);
            mc.init(context.getManagementStrategy());
            if (this.getManagementStrategy().isManaged(null, mc)) {
                this.getManagementStrategy().unmanageObject(mc);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not unregister CamelContext MBean", (Throwable)e);
        }
    }

    @Override
    public void onComponentAdd(String name, Component component) {
        if (!this.initialized) {
            return;
        }
        try {
            Object mc = this.getManagedObjectForComponent(name, component);
            this.getManagementStrategy().manageObject(mc);
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not register Component MBean", (Throwable)e);
        }
    }

    @Override
    public void onComponentRemove(String name, Component component) {
        if (!this.initialized) {
            return;
        }
        try {
            Object mc = this.getManagedObjectForComponent(name, component);
            this.getManagementStrategy().unmanageObject(mc);
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not unregister Component MBean", (Throwable)e);
        }
    }

    private Object getManagedObjectForComponent(String name, Component component) {
        if (component instanceof ManagementAware) {
            return ((ManagementAware)((Object)component)).getManagedObject(component);
        }
        ManagedComponent mc = new ManagedComponent(name, component);
        mc.init(this.getManagementStrategy());
        return mc;
    }

    @Override
    public void onEndpointAdd(Endpoint endpoint) {
        if (!this.initialized) {
            return;
        }
        try {
            Object managedObject = this.getManagedObjectForEndpoint(endpoint);
            if (managedObject == null) {
                return;
            }
            this.getManagementStrategy().manageObject(managedObject);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not register Endpoint MBean for uri: " + endpoint.getEndpointUri()), (Throwable)e);
        }
    }

    @Override
    public void onEndpointRemove(Endpoint endpoint) {
        if (!this.initialized) {
            return;
        }
        try {
            Object me = this.getManagedObjectForEndpoint(endpoint);
            this.getManagementStrategy().unmanageObject(me);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not unregister Endpoint MBean for uri: " + endpoint.getEndpointUri()), (Throwable)e);
        }
    }

    private Object getManagedObjectForEndpoint(Endpoint endpoint) {
        if (!endpoint.isSingleton()) {
            return null;
        }
        if (endpoint instanceof ManagementAware) {
            return ((ManagementAware)((Object)endpoint)).getManagedObject(endpoint);
        }
        if (endpoint instanceof BrowsableEndpoint) {
            ManagedBrowsableEndpoint me = new ManagedBrowsableEndpoint((BrowsableEndpoint)endpoint);
            me.init(this.getManagementStrategy());
            return me;
        }
        ManagedEndpoint me = new ManagedEndpoint(endpoint);
        me.init(this.getManagementStrategy());
        return me;
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service, Route route) {
        if (!this.initialized) {
            return;
        }
        Object managedObject = this.getManagedObjectForService(context, service, route);
        if (managedObject == null) {
            return;
        }
        if (this.getManagementStrategy().isManaged(managedObject, null)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("The service is already managed: " + service));
            }
            return;
        }
        try {
            this.getManagementStrategy().manageObject(managedObject);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not register service: " + service + " as Service MBean."), (Throwable)e);
        }
    }

    @Override
    public void onServiceRemove(CamelContext context, Service service, Route route) {
        if (!this.initialized) {
            return;
        }
        Object managedObject = this.getManagedObjectForService(context, service, route);
        if (managedObject != null) {
            try {
                this.getManagementStrategy().unmanageObject(managedObject);
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not unregister service: " + service + " as Service MBean."), (Throwable)e);
            }
        }
    }

    private Object getManagedObjectForService(CamelContext context, Service service, Route route) {
        ManagedService answer = null;
        if (service instanceof ManagementAware) {
            return ((ManagementAware)((Object)service)).getManagedObject(service);
        }
        if (service instanceof Tracer) {
            ManagedTracer mt = new ManagedTracer(context, (Tracer)service);
            mt.init(this.getManagementStrategy());
            return mt;
        }
        if (service instanceof Producer) {
            answer = new ManagedProducer(context, (Producer)service);
        } else if (service instanceof ScheduledPollConsumer) {
            answer = new ManagedScheduledPollConsumer(context, (ScheduledPollConsumer)service);
        } else if (service instanceof Consumer) {
            answer = new ManagedConsumer(context, (Consumer)service);
        } else {
            if (service instanceof Processor) {
                return this.getManagedObjectForProcessor(context, (Processor)((Object)service), route);
            }
            if (service instanceof ThrottlingInflightRoutePolicy) {
                answer = new ManagedThrottlingInflightRoutePolicy(context, (ThrottlingInflightRoutePolicy)service);
            } else if (service != null) {
                answer = new ManagedService(context, service);
            }
        }
        if (answer != null) {
            answer.setRoute(route);
            answer.init(this.getManagementStrategy());
            return answer;
        }
        return null;
    }

    private Object getManagedObjectForProcessor(CamelContext context, Processor processor, Route route) {
        InstrumentationProcessor counter;
        KeyValueHolder<ProcessorDefinition, InstrumentationProcessor> holder = this.wrappedProcessors.get(processor);
        if (holder == null) {
            return null;
        }
        Object managedObject = this.createManagedObjectForProcessor(context, processor, holder.getKey(), route);
        if (managedObject != null && managedObject instanceof PerformanceCounter && (counter = holder.getValue()) != null) {
            counter.setCounter((ManagedPerformanceCounter)managedObject);
        }
        return managedObject;
    }

    private Object createManagedObjectForProcessor(CamelContext context, Processor processor, ProcessorDefinition definition, Route route) {
        if (processor instanceof ErrorHandler) {
            return false;
        }
        ManagedProcessor answer = null;
        if (processor instanceof Delayer) {
            answer = new ManagedDelayer(context, (Delayer)processor, definition);
        } else if (processor instanceof Throttler) {
            answer = new ManagedThrottler(context, (Throttler)processor, definition);
        } else if (processor instanceof SendProcessor) {
            answer = new ManagedSendProcessor(context, (SendProcessor)processor, definition);
        }
        if (answer == null) {
            answer = new ManagedProcessor(context, processor, definition);
        }
        answer.setRoute(route);
        answer.init(this.getManagementStrategy());
        return answer;
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        if (!this.initialized) {
            return;
        }
        for (Route route : routes) {
            EventDrivenConsumerRoute edcr;
            Processor processor;
            ManagedRoute mr = new ManagedRoute(this.context, route);
            mr.init(this.getManagementStrategy());
            if (this.getManagementStrategy().isManaged(mr, null)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("The route is already managed: " + route));
                continue;
            }
            if (route instanceof EventDrivenConsumerRoute && (processor = (edcr = (EventDrivenConsumerRoute)route).getProcessor()) instanceof InstrumentationProcessor) {
                InstrumentationProcessor ip = (InstrumentationProcessor)processor;
                ip.setCounter(mr);
            }
            try {
                this.getManagementStrategy().manageObject(mr);
            }
            catch (JMException e) {
                LOG.warn((Object)"Could not register Route MBean", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn((Object)"Could not create Route MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRoutesRemove(Collection<Route> routes) {
    }

    @Override
    public void onErrorHandlerAdd(RouteContext routeContext, Processor errorHandler, ErrorHandlerBuilder errorHandlerBuilder) {
        if (!this.initialized) {
            return;
        }
        ManagedErrorHandler me = new ManagedErrorHandler(routeContext, errorHandler, errorHandlerBuilder);
        me.init(this.getManagementStrategy());
        if (this.getManagementStrategy().isManaged(me, null)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("The error handler builder is already managed: " + errorHandlerBuilder));
            }
            return;
        }
        try {
            this.getManagementStrategy().manageObject(me);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not register error handler builder: " + errorHandlerBuilder + " as ErrorHandlerMBean."), (Throwable)e);
        }
    }

    @Override
    public void onRouteContextCreate(RouteContext routeContext) {
        if (!this.initialized) {
            return;
        }
        HashMap<ProcessorDefinition, PerformanceCounter> registeredCounters = new HashMap<ProcessorDefinition, PerformanceCounter>();
        RouteDefinition route = routeContext.getRoute();
        for (ProcessorDefinition processor : route.getOutputs()) {
            this.registerPerformanceCounters(routeContext, processor, registeredCounters);
        }
        routeContext.setManagedInterceptStrategy(new InstrumentationInterceptStrategy(registeredCounters, this.wrappedProcessors));
    }

    private void registerPerformanceCounters(RouteContext routeContext, ProcessorDefinition processor, Map<ProcessorDefinition, PerformanceCounter> registeredCounters) {
        List<ProcessorDefinition> children = processor.getOutputs();
        for (ProcessorDefinition child : children) {
            this.registerPerformanceCounters(routeContext, child, registeredCounters);
        }
        if (!this.registerProcessor(processor)) {
            return;
        }
        DelegatePerformanceCounter pc = new DelegatePerformanceCounter();
        boolean enabled = this.context.getManagementStrategy().getStatisticsLevel() == ManagementStatisticsLevel.All;
        pc.setStatisticsEnabled(enabled);
        registeredCounters.put(processor, pc);
    }

    protected boolean registerProcessor(ProcessorDefinition processor) {
        if (processor instanceof OnExceptionDefinition) {
            return false;
        }
        if (processor instanceof OnCompletionDefinition) {
            return false;
        }
        if (processor instanceof InterceptDefinition) {
            return false;
        }
        if (processor instanceof AOPDefinition) {
            return false;
        }
        if (processor instanceof PolicyDefinition) {
            return false;
        }
        if (this.getManagementStrategy().isOnlyManageProcessorWithCustomId()) {
            return processor.hasCustomIdAssigned();
        }
        return this.getManagementStrategy().manageProcessor(processor);
    }

    private ManagementStrategy getManagementStrategy() {
        return this.context.getManagementStrategy();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        this.initialized = false;
    }
}

