/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.sysfunc;

import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.util.Codecs;
import com.sap.conn.rfc.api.IRfcFunction;
import com.sap.conn.rfc.api.IRfcParameter;
import com.sap.conn.rfc.data.RfcChars;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.exceptions.RfcException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;

public final class RfcCreateTID
implements IRfcFunction {
    private static String processIDHex = null;
    private static String hostAddressHex = null;
    private static AtomicInteger counter = new AtomicInteger(0);
    private static final String[] documentation;

    @Override
    public String getName() {
        return "API_CREATE_TID";
    }

    @Override
    public void execute(RfcIoOpenCntl act_cntl) throws RfcException {
        act_cntl.RfcGetData(null, null, null, null, null);
        act_cntl.ab_rfccount(1);
        String result = this.generateTID();
        RfcChars tid = new RfcChars(act_cntl, "TID", 24);
        tid.setChars(result.toCharArray());
        IRfcParameter[] exp = new IRfcParameter[]{tid};
        act_cntl.RfcSendData(exp, null, null);
        act_cntl.flushServerConnection();
    }

    public String generateTID() {
        StringBuilder tidBuffer = new StringBuilder(24);
        tidBuffer.append(hostAddressHex).append(processIDHex);
        tidBuffer.append(Codecs.Hex.encode((int)(System.currentTimeMillis() & 0xFFFFFFFFL)));
        tidBuffer.append(Codecs.Hex.encode((char)(counter.getAndIncrement() & 0xFFFF)));
        return tidBuffer.toString();
    }

    @Override
    public String[] getDocumentation() {
        return documentation;
    }

    static {
        String traceFileName = JCoRuntimeFactory.getRuntime().getRfcRuntimeInstance().getTraceFileName();
        int underscorePosition = traceFileName.indexOf(95);
        processIDHex = Codecs.Hex.encode((char)(Integer.parseInt(traceFileName.substring(4, underscorePosition)) & 0xFFFF));
        try {
            InetAddress ia = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

                @Override
                public InetAddress run() {
                    try {
                        return InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        return null;
                    }
                }
            });
            hostAddressHex = ia != null ? Codecs.Hex.encode(ia.hashCode()) : "00000000";
        }
        catch (Exception ex) {
            hostAddressHex = "00000000";
        }
        documentation = new String[]{"Creates a transaction ID for transactional RFC", "Only for tRFC between external programs", "", "EXPORTING", "  TID(24)"};
    }
}

