/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc;

import com.sap.conn.idoc.IDocException;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;

public class IDocParseException
extends IDocException {
    private static final long serialVersionUID = 3009L;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String state = null;
    private int charPosition = 0;
    private int lineNumber = 0;
    private int columnNumber = 0;
    private String sourceSnippet = null;
    private int sourceSnippetPosition = 0;
    private int invalidCodepoint = Integer.MAX_VALUE;

    public IDocParseException(String message, String state, int charPosition, int lineNumber, int columnNumber, String sourceSnippet, int sourceSnippetPosition) {
        super(7, message);
        this.state = state;
        this.charPosition = charPosition;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.sourceSnippet = sourceSnippet;
        this.sourceSnippetPosition = sourceSnippetPosition;
        this.invalidCodepoint = this.extractInvalidCodepoint();
    }

    public IDocParseException(String message, String state, int charPosition, int lineNumber, int columnNumber, String sourceSnippet, int sourceSnippetPosition, Throwable cause) {
        super(7, message, cause);
        this.state = state;
        this.charPosition = charPosition;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.sourceSnippet = sourceSnippet;
        this.sourceSnippetPosition = sourceSnippetPosition;
        this.invalidCodepoint = this.extractInvalidCodepoint();
    }

    public IDocParseException(String state, IDocMetaDataUnavailableException cause) {
        super(7, "The metadata for the parsed IDoc was not available. See cause exception for details. ", cause);
        this.state = state;
    }

    private int extractInvalidCodepoint() {
        int sem;
        int len;
        int n = len = this.sourceSnippet != null ? this.sourceSnippet.length() : 0;
        if (this.sourceSnippetPosition < 0 || this.sourceSnippetPosition >= len) {
            return Integer.MAX_VALUE;
        }
        int cp = this.sourceSnippet.codePointAt(this.sourceSnippetPosition);
        if (cp == 38 && this.sourceSnippetPosition + 3 < len && this.sourceSnippet.charAt(this.sourceSnippetPosition + 1) == '#' && (sem = this.sourceSnippet.indexOf(59, this.sourceSnippetPosition + 2)) >= 0) {
            try {
                cp = this.sourceSnippet.charAt(this.sourceSnippetPosition + 2) == 'x' ? Integer.parseInt(this.sourceSnippet.substring(this.sourceSnippetPosition + 3, sem), 16) : Integer.parseInt(this.sourceSnippet.substring(this.sourceSnippetPosition + 2, sem), 10);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return cp;
    }

    public int getCharPosition() {
        return this.charPosition;
    }

    public int getCharPositionInSourceSnippet() {
        return this.sourceSnippetPosition;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public char getInvalidChar() throws IndexOutOfBoundsException {
        if (this.invalidCodepoint == Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        if (this.invalidCodepoint >= 65536) {
            return (char)((this.invalidCodepoint - 65536 >>> 10) + 55296);
        }
        return (char)this.invalidCodepoint;
    }

    public int getInvalidCodepoint() throws IndexOutOfBoundsException {
        if (this.invalidCodepoint == Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return this.invalidCodepoint;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        int len;
        StringBuilder message = new StringBuilder(super.getMessage());
        message.append(":\nstate=").append(this.state);
        message.append(", charPosition=").append(this.charPosition);
        message.append(", lineNumber=").append(this.lineNumber);
        message.append(", columnNumber=").append(this.columnNumber);
        int n = len = this.sourceSnippet != null ? this.sourceSnippet.length() : 0;
        if (len > 0) {
            int i;
            if (this.invalidCodepoint < Integer.MAX_VALUE) {
                message.append(", invalidChar=U+");
                for (i = 28; i > 12 && this.invalidCodepoint >>> i == 0; i -= 4) {
                }
                while (i >= 0) {
                    message.append(HEX[this.invalidCodepoint >>> i & 0xF]);
                    i -= 4;
                }
            }
            int pos = this.sourceSnippetPosition + 14;
            message.append(",\nsourceSnippet=");
            if (!this.sourceSnippet.startsWith("<?xml", this.sourceSnippet.charAt(0) == '\ufeff' ? 1 : 0)) {
                message.append("...");
                pos += 3;
            }
            char c = '\u0000';
            block8: for (i = 0; i < len; ++i) {
                char last = c;
                c = this.sourceSnippet.charAt(i);
                switch (c) {
                    case '\t': {
                        message.append('~');
                        continue block8;
                    }
                    case '\r': {
                        message.append('^');
                        continue block8;
                    }
                    case '\n': {
                        if (last != '\r') {
                            message.append('^');
                            continue block8;
                        }
                        if (i > this.sourceSnippetPosition) continue block8;
                        --pos;
                        continue block8;
                    }
                    case '\ufeff': {
                        message.append('@');
                        continue block8;
                    }
                    default: {
                        if (c < ' ' || '\u007f' <= c && c <= '\u009f') {
                            message.append('#');
                            continue block8;
                        }
                        if (i <= this.sourceSnippetPosition && '\udc00' <= c && c <= '\udfff' && '\ud800' <= last && last <= '\udbff') {
                            --pos;
                            continue block8;
                        }
                        message.append(c);
                    }
                }
            }
            message.append("...");
            if (this.invalidCodepoint < Integer.MAX_VALUE) {
                message.append('\n');
                for (i = 0; i < pos; ++i) {
                    message.append(' ');
                }
                message.append('^');
            }
        }
        return message.toString();
    }

    public String getSourceSnippet() {
        return this.sourceSnippet;
    }

    public String getState() {
        return this.state;
    }
}

