/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoRequestUnit;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.DefaultRequest;
import com.sap.conn.jco.util.Codecs;
import java.util.ArrayList;
import java.util.List;

class AbapRequestUnit
extends AbapFunctionUnit
implements JCoRequestUnit {
    List<JCoRequest> requests = new ArrayList<JCoRequest>();

    AbapRequestUnit(JCoBackgroundUnitAttributes unitAttributes) {
        super(unitAttributes);
    }

    AbapFunctionUnit toAbapFunctionUnit() {
        for (JCoRequest request : this.requests) {
            DefaultRequest defReq = (DefaultRequest)request;
            super.addFunction(defReq.function);
        }
        return this;
    }

    @Override
    public void addRequest(JCoRequest request) {
        if (!(request instanceof DefaultRequest)) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only Requests created by the JCo runtime are allowed. " + request.getClass().getName() + " is not allowed");
        }
        this.requests.add(request);
    }

    @Override
    public void addRequests(List<JCoRequest> requestsToAdd) {
        this.check();
        for (JCoRequest request : requestsToAdd) {
            this.addRequest(request);
        }
    }

    @Override
    public List<JCoRequest> getRequests() {
        return this.requests;
    }

    @Override
    public void commit(JCoDestination destination) throws JCoException {
        this.toAbapFunctionUnit().commit(destination);
    }

    @Override
    public String toString() {
        boolean first;
        StringBuilder buf = new StringBuilder();
        buf.append("Request unit: id=").append(Codecs.Hex.encode(this.guid));
        if (this.queueSet != null) {
            buf.append(", queues=[");
            first = true;
            for (String queue : this.queueSet) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(queue);
            }
            buf.append("]");
        }
        buf.append(", requests=[");
        first = true;
        for (JCoRequest req : this.requests) {
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
            }
            buf.append(req.getName());
        }
        buf.append("]");
        return buf.toString();
    }
}

