/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco.rt;

import com.sap.conn.idoc.IDocConversionException;
import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.IDocSyntaxException;
import com.sap.conn.idoc.jco.rt.JCoIDocSegment;
import com.sap.conn.idoc.jco.rt.JCoStaticRepositories;
import com.sap.conn.idoc.jco.rt.JCoStaticRepository;
import com.sap.conn.idoc.jco.rt.RawTable;
import com.sap.conn.idoc.jco.rt.SAPRepository;
import com.sap.conn.idoc.rt.DefaultIDocDocument;
import com.sap.conn.idoc.rt.DefaultIDocRuntime;
import com.sap.conn.idoc.rt.DefaultIDocSegment;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.idoc.rt.util.Int;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;
import java.util.Hashtable;

public class JCoIDocDocument
extends DefaultIDocDocument {
    static final long serialVersionUID = 1000L;
    protected static transient Int m_greatestJCoIDocNumber = new Int(0);

    protected JCoIDocDocument(IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        super(repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    protected JCoIDocDocument(String controlStructName) {
        super(controlStructName);
    }

    protected JCoIDocDocument(String controlStructName, IDocRepository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws IDocMetaDataUnavailableException {
        super(controlStructName, repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JCoIDocDocument createIDocDocument(IDocRepository repository, RawTable tabControl, int idxTabControl, RawTable tabData, int idxTabData, boolean tabDataContainsTypes, String binaryDataCharset, boolean usePartnerProfileRelease) throws IDocMetaDataUnavailableException {
        String controlStructName = tabControl.getMetaData().getName();
        int controlStructVersion = 0;
        if ("EDI_DC40".equals(controlStructName)) {
            controlStructVersion = 40;
        } else if ("EDI_DC".equals(controlStructName)) {
            controlStructVersion = 31;
        }
        String idocType = null;
        String idocTypeExtension = null;
        String systemRelease = null;
        String applicationRelease = null;
        RawTable rawTable = tabControl;
        synchronized (rawTable) {
            String[] iDocOutboundMessageRelease;
            tabControl.setRow(idxTabControl);
            switch (controlStructVersion) {
                case 40: {
                    idocType = tabControl.getString(9);
                    idocTypeExtension = tabControl.getString(10);
                    break;
                }
                case 31: {
                    idocType = tabControl.getString(31);
                    idocTypeExtension = tabControl.getString(32);
                    break;
                }
                default: {
                    idocType = tabControl.getString("IDOCTYP");
                    idocTypeExtension = tabControl.getString("CIMTYP");
                }
            }
            if (usePartnerProfileRelease && repository instanceof SAPRepository && (iDocOutboundMessageRelease = ((SAPRepository)repository).getIDocOutboundMessageRelease(tabControl.getString("MANDT"), tabControl.getString("RCVPRN"), tabControl.getString("RCVPRT"), tabControl.getString("RCVPFC"), tabControl.getString("MESTYP"), tabControl.getString("MESCOD"), tabControl.getString("MESFCT"), tabControl.getString("TEST"))) != null) {
                systemRelease = iDocOutboundMessageRelease[0];
                applicationRelease = iDocOutboundMessageRelease[1];
            }
        }
        JCoIDocDocument document = new JCoIDocDocument(controlStructName, repository, idocType, idocTypeExtension, systemRelease, applicationRelease);
        char[] controlBuffer = tabControl.getRowBuffer(idxTabControl);
        System.arraycopy(controlBuffer, 0, document.getRawBuffer(), 0, Math.min(controlBuffer.length, document.getRawBufferLength()));
        String dataStructName = tabData.getMetaData().getName();
        int dataStructVersion = 0;
        if ("EDI_DD40".equals(dataStructName) || "EDI_DD40_WITH_BINARY_DATA".equals(dataStructName)) {
            dataStructVersion = 40;
        } else if ("EDI_DD".equals(dataStructName) || "EDI_DD_WITH_BINARY_DATA".equals(dataStructName)) {
            dataStructVersion = 31;
            tabDataContainsTypes = false;
        }
        RawTable rawTable2 = tabData;
        synchronized (rawTable2) {
            tabData.setRow(idxTabData);
            String iDocNumber = document.getIDocNumber();
            String segmentIDocNumber = null;
            switch (dataStructVersion) {
                case 40: {
                    segmentIDocNumber = tabData.getString(2);
                    break;
                }
                case 31: {
                    segmentIDocNumber = tabData.getString(2);
                    break;
                }
                default: {
                    segmentIDocNumber = tabData.getString("DOCNUM");
                }
            }
            if (!iDocNumber.equals(segmentIDocNumber)) {
                throw new IDocRuntimeException("IDoc no. " + iDocNumber + " of control table row " + idxTabControl + " does not match IDoc no. " + segmentIDocNumber + " of data table row " + idxTabData + ".");
            }
            JCoIDocSegment segment = null;
            JCoIDocSegment parentSegment = null;
            IDocSegmentMetaData segmentMetaData = null;
            Hashtable<String, JCoIDocSegment> segments = new Hashtable<String, JCoIDocSegment>(89);
            segments.put("000000", (JCoIDocSegment)document.m_rootSegment);
            String segmentName = null;
            String segmentNumber = null;
            String parentSegmentNumber = null;
            String segmentDataString = null;
            byte[] segmentDataByteArray = null;
            do {
                switch (dataStructVersion) {
                    case 40: {
                        segmentName = tabData.getString(0);
                        segmentNumber = tabData.getString(3);
                        parentSegmentNumber = tabData.getString(4);
                        if (tabData.getMetaData().getType(6) == 4) {
                            segmentDataByteArray = tabData.getByteArray(6);
                            break;
                        }
                        segmentDataString = tabData.getString(6);
                        break;
                    }
                    case 31: {
                        segmentName = tabData.getString(4);
                        segmentNumber = tabData.getString(3);
                        parentSegmentNumber = tabData.getString(5);
                        if (tabData.getMetaData().getType(8) == 4) {
                            segmentDataByteArray = tabData.getByteArray(8);
                            break;
                        }
                        segmentDataString = tabData.getString(8);
                        break;
                    }
                    default: {
                        segmentName = tabData.getString("SEGNAM");
                        segmentNumber = tabData.getString("SEGNUM");
                        parentSegmentNumber = tabData.getString("PSGNUM");
                        if (tabData.getMetaData().getType("SDATA") == 4) {
                            segmentDataByteArray = tabData.getByteArray("SDATA");
                            break;
                        }
                        segmentDataString = tabData.getString("SDATA");
                    }
                }
                parentSegment = (JCoIDocSegment)segments.get(parentSegmentNumber);
                segmentMetaData = tabDataContainsTypes ? parentSegment.getSegmentMetaData().getChildByType(segmentName) : parentSegment.getSegmentMetaData().getChildMatchingDefinition(segmentName);
                if (segmentMetaData == null) {
                    throw new IDocMetaDataUnavailableException("Matching meta data for segment " + (tabDataContainsTypes ? "type \"" : "definition \"") + segmentName + "\" was not found when processing IDoc no. " + iDocNumber + " of type \"" + idocType + "\" " + (idocTypeExtension.length() > 0 ? "with extension \"" + idocTypeExtension + "\"." : "."));
                }
                try {
                    segment = segmentDataString != null ? new JCoIDocSegment(document, segmentMetaData, false, segmentDataString) : new JCoIDocSegment(document, segmentMetaData, false, segmentDataByteArray, binaryDataCharset);
                }
                catch (IDocConversionException exc) {
                    throw new IDocRuntimeException(exc);
                }
                catch (IDocSyntaxException exc) {
                    throw new IDocRuntimeException(exc);
                }
                segments.put(segmentNumber, segment);
                parentSegment.addChild(segment);
                if (tabData.nextRow()) {
                    switch (dataStructVersion) {
                        case 40: {
                            segmentIDocNumber = tabData.getString(2);
                            break;
                        }
                        case 31: {
                            segmentIDocNumber = tabData.getString(2);
                            break;
                        }
                        default: {
                            segmentIDocNumber = tabData.getString("DOCNUM");
                            break;
                        }
                    }
                    continue;
                }
                segmentIDocNumber = null;
            } while (iDocNumber.equals(segmentIDocNumber));
        }
        return document;
    }

    protected static JCoFunction createJCoFunction(IDocDocument document, char iDocVersion, int options, JCoAttributes attributes, String queueName) {
        JCoFunction function = null;
        String systemRelease = null;
        String codepage = null;
        boolean isUnicode = false;
        boolean isNonAbapPartner = true;
        if (attributes != null) {
            systemRelease = attributes.getPartnerRelease();
            codepage = attributes.getPartnerCodepage();
            isUnicode = JCoStaticRepositories.isPartnerSystemUnicode(attributes);
            char partnerType = attributes.getPartnerType();
            boolean bl = isNonAbapPartner = partnerType != '2' && partnerType != '3';
        }
        if (iDocVersion != '0' && iDocVersion != '2' && iDocVersion != '3' && iDocVersion != 'Q' && iDocVersion != 'I' && iDocVersion != '8') {
            iDocVersion = (char)48;
        }
        boolean useInQueue = false;
        if (queueName != null && queueName.length() > 0 && (iDocVersion == 'Q' || iDocVersion == 'I' || iDocVersion == '8')) {
            if (systemRelease != null && systemRelease.length() > 0 && systemRelease.compareTo("64") >= 0 || isNonAbapPartner) {
                useInQueue = true;
            } else {
                throw new IDocRuntimeException("Queueing of IDocs at application layer requires an SAP AS ABAP backend system of at least release 6.40 (SAP_BASIS)." + (attributes != null ? " The release of system " + attributes.getSystemID() + " is only " + systemRelease : ""));
            }
        }
        JCoStaticRepository jcoStaticRepository = JCoStaticRepositories.getJCoStaticRepository(systemRelease);
        RawTable controlTable = null;
        RawTable dataTable = null;
        if (iDocVersion != '2' && (systemRelease == null || systemRelease.length() == 0 || systemRelease.compareTo("4") >= 0 || isNonAbapPartner)) {
            if (isUnicode || attributes == null || attributes.getOwnBytesPerChar() <= 1) {
                function = jcoStaticRepository.getFunction(useInQueue ? "IDOC_INBOUND_IN_QUEUE" : "IDOC_INBOUND_ASYNCHRONOUS");
            } else {
                if (Trace.isOn(16)) {
                    Trace.fireTrace(16, new StringBuilder(100).append("[IDocRFC] Faking binary meta data for client. Will do conversion for codepage " + codepage + " in IDocLibrary").toString());
                }
                function = jcoStaticRepository.getFunction(useInQueue ? "IDOC_INBOUND_IN_QUEUE_WITH_BINARY_DATA" : "IDOC_INBOUND_ASYNCHRONOUS_WITH_BINARY_DATA");
            }
            controlTable = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL_REC_40");
            if (useInQueue) {
                dataTable = (RawTable)function.getTableParameterList().getTable("IDOC_DATA_QUEUE");
                function.getImportParameterList().setValue(0, queueName);
            } else {
                dataTable = (RawTable)function.getTableParameterList().getTable("IDOC_DATA_REC_40");
            }
        } else {
            if (isUnicode || attributes == null || attributes.getOwnBytesPerChar() <= 1) {
                function = jcoStaticRepository.getFunction("INBOUND_IDOC_PROCESS");
            } else {
                if (Trace.isOn(16)) {
                    Trace.fireTrace(16, new StringBuilder(100).append("[IDocRFC] Faking binary meta data for client. Will do conversion for codepage " + codepage + " in IDocLibrary").toString());
                }
                function = jcoStaticRepository.getFunction("INBOUND_IDOC_PROCESS_WITH_BINARY_DATA");
            }
            controlTable = (RawTable)function.getTableParameterList().getTable("IDOC_CONTROL");
            dataTable = (RawTable)function.getTableParameterList().getTable("IDOC_DATA");
        }
        int numSegments = document.getNumSegments() - 1;
        if (numSegments > 0) {
            String iDocNumber = JCoIDocDocument.createJCoIDocNumber(document);
            controlTable.ensureBufferCapacity(1);
            if (document instanceof JCoIDocDocument) {
                JCoIDocDocument.appendRowToJCoControlTable(controlTable, (JCoIDocDocument)document, iDocNumber);
            } else {
                JCoIDocDocument.copyControlDataToJCoControlTable((JCoTable)controlTable, document, iDocNumber);
            }
            dataTable.ensureBufferCapacity(numSegments);
            JCoIDocDocument.appendRowsToJCoDataTable(dataTable, useInQueue, document, iDocNumber, codepage);
        }
        return function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String createJCoIDocNumber(IDocDocument document) {
        String iDocNumber = document.getIDocNumber();
        if (iDocNumber == null || iDocNumber.length() == 0) {
            Int intVal = m_greatestJCoIDocNumber;
            synchronized (intVal) {
                m_greatestJCoIDocNumber.increment();
                iDocNumber = m_greatestJCoIDocNumber.toString();
            }
        }
        return iDocNumber;
    }

    protected static boolean copyControlDataToJCoControlTable(JCoTable table, IDocDocument document, String iDocNumber) {
        String client;
        String tableName = table.getMetaData().getName();
        boolean retSuccess = false;
        if (iDocNumber.length() < 16) {
            StringBuilder strBld = new StringBuilder(16);
            strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 16 - iDocNumber.length());
            strBld.append(iDocNumber);
            iDocNumber = strBld.toString();
        }
        if ("EDI_DC".equals(tableName)) {
            table.appendRow();
            client = document.getClient();
            if (client.length() > 0 && client.length() < 3) {
                StringBuilder strBld = new StringBuilder(3);
                strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 3 - client.length());
                strBld.append(client);
                client = strBld.toString();
            }
            table.setValue(0, "EDI_DC");
            table.setValue(1, client);
            table.setValue(2, iDocNumber);
            table.setValue(3, document.getIDocSAPRelease());
            table.setValue(4, document.getStatus());
            table.setValue(5, document.getIDocCompoundType());
            table.setValue(6, document.getDirection());
            table.setValue(7, document.getRecipientPort());
            table.setValue(8, document.getRecipientPartnerType());
            table.setValue(9, document.getRecipientPartnerNumber());
            table.setValue(10, document.getRecipientAddress());
            table.setValue(11, document.getRecipientLogicalAddress());
            table.setValue(12, document.getEDIStandardFlag());
            table.setValue(13, document.getEDIStandardVersion());
            table.setValue(14, document.getEDIMessageType());
            table.setValue(15, document.getMessageCode());
            table.setValue(16, document.getMessageFunction());
            table.setValue(17, document.getOutputMode());
            table.setValue(18, document.getTestFlag());
            table.setValue(19, document.getSenderPort());
            table.setValue(20, document.getSenderPartnerType());
            table.setValue(21, document.getSenderPartnerNumber());
            table.setValue(22, document.getSenderAddress());
            table.setValue(23, document.getSenderLogicalAddress());
            table.setValue(24, document.getEDITransmissionFile());
            table.setValue(25, document.getEDIMessageGroup());
            table.setValue(26, document.getEDIMessage());
            table.setValue(27, document.getArchiveKey());
            table.setValue(28, document.getCreationDateAsString());
            table.setValue(29, document.getCreationTimeAsString());
            table.setValue(30, document.getMessageType());
            table.setValue(31, document.getIDocType());
            table.setValue(32, document.getIDocTypeExtension());
            table.setValue(33, document.getRecipientPartnerFunction());
            table.setValue(34, document.getSenderPartnerFunction());
            table.setValue(35, document.getSerialization());
            table.setValue(36, document.getExpressFlag());
            retSuccess = true;
        } else if ("EDI_DC40".equals(tableName)) {
            table.appendRow();
            client = document.getClient();
            if (client.length() > 0 && client.length() < 3) {
                StringBuilder strBld = new StringBuilder(3);
                strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 3 - client.length());
                strBld.append(client);
                client = strBld.toString();
            }
            table.setValue(0, "EDI_DC40");
            table.setValue(1, client);
            table.setValue(2, iDocNumber);
            table.setValue(3, document.getIDocSAPRelease());
            table.setValue(4, document.getStatus());
            table.setValue(5, document.getDirection());
            table.setValue(6, document.getOutputMode());
            table.setValue(7, document.getExpressFlag());
            table.setValue(8, document.getTestFlag());
            table.setValue(9, document.getIDocType());
            table.setValue(10, document.getIDocTypeExtension());
            table.setValue(11, document.getMessageType());
            table.setValue(12, document.getMessageCode());
            table.setValue(13, document.getMessageFunction());
            table.setValue(14, document.getEDIStandardFlag());
            table.setValue(15, document.getEDIStandardVersion());
            table.setValue(16, document.getEDIMessageType());
            table.setValue(17, document.getSenderPort());
            table.setValue(18, document.getSenderPartnerType());
            table.setValue(19, document.getSenderPartnerFunction());
            table.setValue(20, document.getSenderPartnerNumber());
            table.setValue(21, document.getSenderAddress());
            table.setValue(22, document.getSenderLogicalAddress());
            table.setValue(23, document.getRecipientPort());
            table.setValue(24, document.getRecipientPartnerType());
            table.setValue(25, document.getRecipientPartnerFunction());
            table.setValue(26, document.getRecipientPartnerNumber());
            table.setValue(27, document.getRecipientAddress());
            table.setValue(28, document.getRecipientLogicalAddress());
            table.setValue(29, document.getCreationDateAsString());
            table.setValue(30, document.getCreationTimeAsString());
            table.setValue(31, document.getEDITransmissionFile());
            table.setValue(32, document.getEDIMessageGroup());
            table.setValue(33, document.getEDIMessage());
            table.setValue(34, document.getArchiveKey());
            table.setValue(35, document.getSerialization());
            retSuccess = true;
        }
        return retSuccess;
    }

    protected static boolean appendRowToJCoControlTable(RawTable table, JCoIDocDocument document, String iDocNumber) {
        boolean retSuccess = false;
        String name = document.getBaseMetaData().getName();
        if (name != null && name.equals(table.getMetaData().getName())) {
            table.appendRawRow(document.getRawBuffer());
            if (iDocNumber.length() < 16) {
                StringBuilder strBld = new StringBuilder(16);
                strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 16 - iDocNumber.length());
                strBld.append(iDocNumber);
                iDocNumber = strBld.toString();
            }
            switch (document.m_controlStructVersion) {
                case 40: {
                    table.setValue(2, iDocNumber);
                    break;
                }
                case 31: {
                    table.setValue(2, iDocNumber);
                    break;
                }
                default: {
                    table.setValue("DOCNUM", iDocNumber);
                }
            }
            String client = document.getClient();
            if (client.length() > 0 && client.length() < 3) {
                StringBuilder strBld = new StringBuilder(3);
                strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 3 - client.length());
                strBld.append(client);
                client = strBld.toString();
                switch (document.m_controlStructVersion) {
                    case 40: {
                        table.setValue(1, client);
                        break;
                    }
                    case 31: {
                        table.setValue(1, client);
                        break;
                    }
                    default: {
                        table.setValue("MANDT", client);
                    }
                }
            }
            retSuccess = true;
        } else {
            retSuccess = JCoIDocDocument.copyControlDataToJCoControlTable((JCoTable)table, document, iDocNumber);
        }
        return retSuccess;
    }

    protected static boolean appendRowsToJCoDataTable(RawTable table, boolean fillTableWithTypes, IDocDocument document, String iDocNumber, String binaryDataCharset) {
        String tableName = table.getMetaData().getName();
        IDocSegment rootSegment = document.getRootSegment();
        boolean retSuccess = false;
        if ("EDI_DD40".equals(tableName) || "EDI_DD40_WITH_BINARY_DATA".equals(tableName)) {
            if (rootSegment != null && rootSegment.getNumChildren() > 0) {
                StringBuilder strBld;
                String client = document.getClient();
                if (client.length() > 0 && client.length() < 3) {
                    strBld = new StringBuilder(3);
                    strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 3 - client.length());
                    strBld.append(client);
                    client = strBld.toString();
                }
                if (iDocNumber.length() < 16) {
                    strBld = new StringBuilder(16);
                    strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 16 - iDocNumber.length());
                    strBld.append(iDocNumber);
                    iDocNumber = strBld.toString();
                }
                JCoIDocDocument.appendChildRowsToJCoDataTable40(table, fillTableWithTypes, client, iDocNumber, rootSegment, 0, binaryDataCharset);
            }
            retSuccess = true;
        } else if ("EDI_DD".equals(tableName) || "EDI_DD_WITH_BINARY_DATA".equals(tableName)) {
            if (rootSegment != null && rootSegment.getNumChildren() > 0) {
                StringBuilder strBld;
                String client = document.getClient();
                if (client.length() > 0 && client.length() < 3) {
                    strBld = new StringBuilder(3);
                    strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 3 - client.length());
                    strBld.append(client);
                    client = strBld.toString();
                }
                if (iDocNumber.length() < 16) {
                    strBld = new StringBuilder(16);
                    strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 16 - iDocNumber.length());
                    strBld.append(iDocNumber);
                    iDocNumber = strBld.toString();
                }
                JCoIDocDocument.appendChildRowsToJCoDataTable31(table, client, iDocNumber, rootSegment, 0, binaryDataCharset);
            }
            retSuccess = true;
        }
        return retSuccess;
    }

    private static int appendChildRowsToJCoDataTable31(RawTable table, String client, String iDocNumber, IDocSegment parent, int parentSegmentNumber, String binaryDataCharset) {
        IDocSegment segment = null;
        String segmentName = null;
        int segmentNumber = parentSegmentNumber;
        int numChilds = parent.getNumChildren();
        String str = null;
        StringBuilder strBld = new StringBuilder(6);
        for (int i = 0; i < numChilds; ++i) {
            segment = parent.getChild(i);
            ++segmentNumber;
            segmentName = segment.getDefinition();
            if ((segmentName == null || segmentName.length() == 0) && segment.getSegmentMetaData() != null) {
                segmentName = segment.getSegmentMetaData().getDefinition();
            }
            if (segmentName == null || segmentName.length() == 0) {
                IDocRuntimeException ire = new IDocRuntimeException(new StringBuilder(120).append("Segment definition name for child segment no. ").append(i + 1).append(" of parent segment ").append(parent.getDefinition()).append(" is ").append(segmentName == null ? "null" : "an empty string").toString());
                if (Trace.isOn(2)) {
                    Trace.fireTraceCritical("[IDocAPI] IDoc send operation failed because required meta data is unavailable", ire);
                }
                throw ire;
            }
            table.appendRow();
            table.setValue(0, "EDI_DD");
            table.setValue(1, client);
            table.setValue(2, iDocNumber);
            str = Integer.toString(segmentNumber);
            strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 6 - str.length());
            strBld.append(str);
            table.setValue(3, strBld.toString());
            strBld.setLength(0);
            table.setValue(4, segmentName);
            str = Integer.toString(parentSegmentNumber);
            strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 6 - str.length());
            strBld.append(str);
            table.setValue(5, strBld.toString());
            strBld.setLength(0);
            str = Integer.toString(segment.getHierarchyLevel());
            strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 2 - str.length());
            strBld.append(str);
            table.setValue(6, strBld.toString());
            strBld.setLength(0);
            table.setValue(7, "");
            if (segment instanceof JCoIDocSegment) {
                if (table.getMetaData().getType(8) == 4) {
                    ((JCoIDocSegment)segment).copyDataToByteArray(table.getRowBuffer(), table.getJavaBufferOffset(8), table.getJavaBufferLength(8), binaryDataCharset);
                } else {
                    ((JCoIDocSegment)segment).copyDataToCharArray(table.getRowBuffer(), table.getJavaBufferOffset(8), table.getJavaBufferLength(8));
                }
            } else if (table.getMetaData().getType(8) == 4) {
                JCoIDocSegment.copyDataToByteArray(segment, table.getRowBuffer(), table.getJavaBufferOffset(8), table.getJavaBufferLength(8), binaryDataCharset);
            } else {
                JCoIDocSegment.copyDataToCharArray(segment, table.getRowBuffer(), table.getJavaBufferOffset(8), table.getJavaBufferLength(8));
            }
            if (segment.getNumChildren() <= 0) continue;
            segmentNumber = JCoIDocDocument.appendChildRowsToJCoDataTable31(table, client, iDocNumber, segment, segmentNumber, binaryDataCharset);
        }
        return segmentNumber;
    }

    private static int appendChildRowsToJCoDataTable40(RawTable table, boolean fillTableWithTypes, String client, String iDocNumber, IDocSegment parent, int parentSegmentNumber, String binaryDataCharset) {
        IDocSegment segment = null;
        String segmentName = null;
        int segmentNumber = parentSegmentNumber;
        int numChilds = parent.getNumChildren();
        String str = null;
        StringBuilder strBld = new StringBuilder(6);
        for (int i = 0; i < numChilds; ++i) {
            segment = parent.getChild(i);
            ++segmentNumber;
            if (fillTableWithTypes) {
                segmentName = segment.getType();
                if ((segmentName == null || segmentName.length() == 0) && segment.getSegmentMetaData() != null) {
                    segmentName = segment.getSegmentMetaData().getType();
                }
            } else {
                segmentName = segment.getDefinition();
                if ((segmentName == null || segmentName.length() == 0) && segment.getSegmentMetaData() != null) {
                    segmentName = segment.getSegmentMetaData().getDefinition();
                }
            }
            if (segmentName == null || segmentName.length() == 0) {
                IDocRuntimeException ire = new IDocRuntimeException(new StringBuilder(120).append("Segment ").append(fillTableWithTypes ? "type" : "definition").append(" name for child segment no. ").append(i + 1).append(" of parent segment ").append(parent.getDefinition()).append(" is ").append(segmentName == null ? "null" : "an empty string").toString());
                if (Trace.isOn(2)) {
                    Trace.fireTraceCritical("[IDocAPI] IDoc send operation failed because required meta data is unavailable", ire);
                }
                throw ire;
            }
            table.appendRow();
            table.setValue(0, segmentName);
            table.setValue(1, client);
            table.setValue(2, iDocNumber);
            str = Integer.toString(segmentNumber);
            strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 6 - str.length());
            strBld.append(str);
            table.setValue(3, strBld.toString());
            strBld.setLength(0);
            table.setValue(4, parentSegmentNumber);
            str = Integer.toString(segment.getHierarchyLevel());
            strBld.append(DefaultIDocRuntime.ZERO_CHARARRAY, 0, 2 - str.length());
            strBld.append(str);
            table.setValue(5, strBld.toString());
            strBld.setLength(0);
            if (segment instanceof JCoIDocSegment) {
                if (table.getMetaData().getType(6) == 4) {
                    ((JCoIDocSegment)segment).copyDataToByteArray(table.getRowBuffer(), table.getJavaBufferOffset(6), table.getJavaBufferLength(6), binaryDataCharset);
                } else {
                    ((JCoIDocSegment)segment).copyDataToCharArray(table.getRowBuffer(), table.getJavaBufferOffset(6), table.getJavaBufferLength(6));
                }
            } else if (table.getMetaData().getType(6) == 4) {
                JCoIDocSegment.copyDataToByteArray(segment, table.getRowBuffer(), table.getJavaBufferOffset(6), table.getJavaBufferLength(6), binaryDataCharset);
            } else {
                JCoIDocSegment.copyDataToCharArray(segment, table.getRowBuffer(), table.getJavaBufferOffset(6), table.getJavaBufferLength(6));
            }
            if (segment.getNumChildren() <= 0) continue;
            segmentNumber = JCoIDocDocument.appendChildRowsToJCoDataTable40(table, fillTableWithTypes, client, iDocNumber, segment, segmentNumber, binaryDataCharset);
        }
        return segmentNumber;
    }

    protected DefaultIDocSegment createDefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
        return new JCoIDocSegment(document, segmentMetaData, checkFieldValuesOnSet);
    }
}

