/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was automatically generated by lister-gen

package internalversion

import (
	servicecatalog "github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// BindingLister helps list Bindings.
type BindingLister interface {
	// List lists all Bindings in the indexer.
	List(selector labels.Selector) (ret []*servicecatalog.Binding, err error)
	// Bindings returns an object that can list and get Bindings.
	Bindings(namespace string) BindingNamespaceLister
	BindingListerExpansion
}

// bindingLister implements the BindingLister interface.
type bindingLister struct {
	indexer cache.Indexer
}

// NewBindingLister returns a new BindingLister.
func NewBindingLister(indexer cache.Indexer) BindingLister {
	return &bindingLister{indexer: indexer}
}

// List lists all Bindings in the indexer.
func (s *bindingLister) List(selector labels.Selector) (ret []*servicecatalog.Binding, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*servicecatalog.Binding))
	})
	return ret, err
}

// Bindings returns an object that can list and get Bindings.
func (s *bindingLister) Bindings(namespace string) BindingNamespaceLister {
	return bindingNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// BindingNamespaceLister helps list and get Bindings.
type BindingNamespaceLister interface {
	// List lists all Bindings in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*servicecatalog.Binding, err error)
	// Get retrieves the Binding from the indexer for a given namespace and name.
	Get(name string) (*servicecatalog.Binding, error)
	BindingNamespaceListerExpansion
}

// bindingNamespaceLister implements the BindingNamespaceLister
// interface.
type bindingNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Bindings in the indexer for a given namespace.
func (s bindingNamespaceLister) List(selector labels.Selector) (ret []*servicecatalog.Binding, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*servicecatalog.Binding))
	})
	return ret, err
}

// Get retrieves the Binding from the indexer for a given namespace and name.
func (s bindingNamespaceLister) Get(name string) (*servicecatalog.Binding, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(servicecatalog.Resource("binding"), name)
	}
	return obj.(*servicecatalog.Binding), nil
}
