// +build !ignore_autogenerated

/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by openapi-gen. Do not edit it manually!

package openapi

import (
	spec "github.com/go-openapi/spec"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	openapi "k8s.io/apimachinery/pkg/openapi"
)

func GetOpenAPIDefinitions(ref openapi.ReferenceCallback) map[string]openapi.OpenAPIDefinition {
	return map[string]openapi.OpenAPIDefinition{
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BasicAuthConfig": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BasicAuthConfig provides config for the basic authentication.",
					Properties: map[string]spec.Schema{
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "SecretRef is a reference to a Secret containing information the catalog should use to authenticate to this Broker.\n\nRequired at least one of the fields: - Secret.Data[\"username\"] - username used for authentication - Secret.Data[\"password\"] - password or token needed for authentication",
								Ref:         ref("k8s.io/client-go/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/client-go/pkg/api/v1.ObjectReference"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BearerTokenAuthConfig": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BearerTokenAuthConfig provides config for the bearer token authentication.",
					Properties: map[string]spec.Schema{
						"secretRef": {
							SchemaProps: spec.SchemaProps{
								Description: "SecretRef is a reference to a Secret containing information the catalog should use to authenticate to this Broker.\n\nRequired field: - Secret.Data[\"token\"] - bearer token for authentication",
								Ref:         ref("k8s.io/client-go/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/client-go/pkg/api/v1.ObjectReference"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Binding": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Binding represents a \"used by\" relationship between an application and an Instance.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingStatus"),
							},
						},
					},
					Required: []string{"spec", "status"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingSpec", "github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BindingCondition condition information for a Binding.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of the condition, currently ('Ready').",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of ('True', 'False', 'Unknown').",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "LastTransitionTime is the timestamp corresponding to the last status change of this condition.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Reason is a brief machine readable explanation for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message is a human readable description of the details of the last transition, complementing reason.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status", "lastTransitionTime", "reason", "message"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BindingList is a list of Bindings.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Binding"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Binding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BindingSpec represents the desired state of a Binding.",
					Properties: map[string]spec.Schema{
						"instanceRef": {
							SchemaProps: spec.SchemaProps{
								Description: "InstanceRef is the reference to the Instance this Binding is to.\n\nImmutable.",
								Ref:         ref("k8s.io/client-go/pkg/api/v1.LocalObjectReference"),
							},
						},
						"parameters": {
							SchemaProps: spec.SchemaProps{
								Description: "Parameters is a set of the parameters to be passed to the underlying broker. The inline YAML/JSON payload to be translated into equivalent JSON object. If a top-level parameter name exists in multiples sources among `Parameters` and `ParametersFrom` fields, it is considered to be a user error in the specification",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"parametersFrom": {
							SchemaProps: spec.SchemaProps{
								Description: "List of sources to populate parameters. If a top-level parameter name exists in multiples sources among `Parameters` and `ParametersFrom` fields, it is considered to be a user error in the specification",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ParametersFromSource"),
										},
									},
								},
							},
						},
						"secretName": {
							SchemaProps: spec.SchemaProps{
								Description: "SecretName is the name of the secret to create in the Binding's namespace that will hold the credentials associated with the Binding.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"externalID": {
							SchemaProps: spec.SchemaProps{
								Description: "ExternalID is the identity of this object for use with the OSB API.\n\nImmutable.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"instanceRef", "externalID"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ParametersFromSource", "k8s.io/apimachinery/pkg/runtime.RawExtension", "k8s.io/client-go/pkg/api/v1.LocalObjectReference"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BindingStatus represents the current status of a Binding.",
					Properties: map[string]spec.Schema{
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingCondition"),
										},
									},
								},
							},
						},
						"checksum": {
							SchemaProps: spec.SchemaProps{
								Description: "Checksum is the checksum of the BindingSpec that was last successfully reconciled against the broker.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"conditions"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BindingCondition"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Broker": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Broker represents an entity that provides ServiceClasses for use in the service catalog.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Non-namespaced.  The name of this resource in etcd is in ObjectMeta.Name.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerStatus"),
							},
						},
					},
					Required: []string{"spec", "status"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerSpec", "github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerAuthInfo": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BrokerAuthInfo is a union type that contains information on one of the authentication methods the the service catalog and brokers may support, according to the OpenServiceBroker API specification (https://github.com/openservicebrokerapi/servicebroker/blob/master/spec.md).",
					Properties: map[string]spec.Schema{
						"basic": {
							SchemaProps: spec.SchemaProps{
								Description: "Basic provides configuration for basic authentication.",
								Ref:         ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BasicAuthConfig"),
							},
						},
						"bearer": {
							SchemaProps: spec.SchemaProps{
								Description: "BearerTokenAuthConfig provides configuration to send an opaque value as a bearer token. The value is referenced from the 'token' field of the given secret.  This value should only contain the token value and not the `Bearer` scheme.",
								Ref:         ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BearerTokenAuthConfig"),
							},
						},
						"basicAuthSecret": {
							SchemaProps: spec.SchemaProps{
								Description: "DEPRECATED: use `Basic` field for configuring basic authentication instead. BasicAuthSecret is a reference to a Secret containing auth information the catalog should use to authenticate to this Broker using basic auth.",
								Ref:         ref("k8s.io/client-go/pkg/api/v1.ObjectReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BasicAuthConfig", "github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BearerTokenAuthConfig", "k8s.io/client-go/pkg/api/v1.ObjectReference"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BrokerCondition contains condition information for a Broker.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of the condition, currently ('Ready').",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of ('True', 'False', 'Unknown').",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "LastTransitionTime is the timestamp corresponding to the last status change of this condition.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Reason is a brief machine readable explanation for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message is a human readable description of the details of the last transition, complementing reason.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status", "lastTransitionTime", "reason", "message"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BrokerList is a list of Brokers.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Broker"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Broker", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BrokerSpec represents a description of a Broker.",
					Properties: map[string]spec.Schema{
						"url": {
							SchemaProps: spec.SchemaProps{
								Description: "URL is the address used to communicate with the Broker.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"authInfo": {
							SchemaProps: spec.SchemaProps{
								Description: "AuthInfo contains the data that the service catalog should use to authenticate with the Broker.",
								Ref:         ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerAuthInfo"),
							},
						},
					},
					Required: []string{"url"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerAuthInfo"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "BrokerStatus represents the current status of a Broker.",
					Properties: map[string]spec.Schema{
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerCondition"),
										},
									},
								},
							},
						},
						"checksum": {
							SchemaProps: spec.SchemaProps{
								Description: "Checksum is the sha hash of the BrokerSpec that was last successfully reconciled against the broker.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"conditions"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.BrokerCondition"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Instance": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Instance represents a provisioned instance of a ServiceClass.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"spec": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceSpec"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceStatus"),
							},
						},
					},
					Required: []string{"spec", "status"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceSpec", "github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceCondition": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "InstanceCondition contains condition information about an Instance.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Description: "Type of the condition, currently ('Ready').",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the condition, one of ('True', 'False', 'Unknown').",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"lastTransitionTime": {
							SchemaProps: spec.SchemaProps{
								Description: "LastTransitionTime is the timestamp corresponding to the last status change of this condition.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "Reason is a brief machine readable explanation for the condition's last transition.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "Message is a human readable description of the details of the last transition, complementing reason.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"type", "status", "lastTransitionTime", "reason", "message"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "InstanceList is a list of instances.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Instance"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.Instance", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceSpec": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "InstanceSpec represents the desired state of an Instance.",
					Properties: map[string]spec.Schema{
						"serviceClassName": {
							SchemaProps: spec.SchemaProps{
								Description: "ServiceClassName is the reference to the ServiceClass this Instance should be provisioned from.\n\nImmutable.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"planName": {
							SchemaProps: spec.SchemaProps{
								Description: "PlanName is the name of the ServicePlan this Instance should be provisioned from. If omitted and there is only one plan in the specified ServiceClass it will be used. If omitted and there are more than one plan in the specified ServiceClass the request will be rejected.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"parameters": {
							SchemaProps: spec.SchemaProps{
								Description: "Parameters is a set of the parameters to be passed to the underlying broker. The inline YAML/JSON payload to be translated into equivalent JSON object. If a top-level parameter name exists in multiples sources among `Parameters` and `ParametersFrom` fields, it is considered to be a user error in the specification",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"parametersFrom": {
							SchemaProps: spec.SchemaProps{
								Description: "List of sources to populate parameters. If a top-level parameter name exists in multiples sources among `Parameters` and `ParametersFrom` fields, it is considered to be a user error in the specification",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ParametersFromSource"),
										},
									},
								},
							},
						},
						"externalID": {
							SchemaProps: spec.SchemaProps{
								Description: "ExternalID is the identity of this object for use with the OSB SB API.\n\nImmutable.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"serviceClassName", "externalID"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ParametersFromSource", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceStatus": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "InstanceStatus represents the current status of an Instance.",
					Properties: map[string]spec.Schema{
						"conditions": {
							SchemaProps: spec.SchemaProps{
								Description: "Conditions is an array of InstanceConditions capturing aspects of an Instance's status.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceCondition"),
										},
									},
								},
							},
						},
						"asyncOpInProgress": {
							SchemaProps: spec.SchemaProps{
								Description: "AsyncOpInProgress is set to true if there is an ongoing async operation against this Service Instance in progress.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"lastOperation": {
							SchemaProps: spec.SchemaProps{
								Description: "LastOperation is the string that the broker may have returned when an async operation started, it should be sent back to the broker on poll requests as a query param.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"dashboardURL": {
							SchemaProps: spec.SchemaProps{
								Description: "DashboardURL is the URL of a web-based management user interface for the service instance.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"checksum": {
							SchemaProps: spec.SchemaProps{
								Description: "Checksum is the checksum of the InstanceSpec that was last successfully reconciled against the broker.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"conditions", "asyncOpInProgress"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.InstanceCondition"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ParametersFromSource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ParametersFromSource represents the source of a set of Parameters",
					Properties: map[string]spec.Schema{
						"secretKeyRef": {
							SchemaProps: spec.SchemaProps{
								Description: "The Secret key to select from. The value must be a JSON object.",
								Ref:         ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.SecretKeyReference"),
							},
						},
					},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.SecretKeyReference"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.SecretKeyReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "SecretKeyReference references a key of a Secret.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of the secret in the pod's namespace to select from.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"key": {
							SchemaProps: spec.SchemaProps{
								Description: "The key of the secret to select from.  Must be a valid secret key.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name", "key"},
				},
			},
			Dependencies: []string{},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ServiceClass": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceClass represents an offering in the service catalog.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
							},
						},
						"brokerName": {
							SchemaProps: spec.SchemaProps{
								Description: "BrokerName is the reference to the Broker that provides this ServiceClass.\n\nImmutable.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"description": {
							SchemaProps: spec.SchemaProps{
								Description: "Description is a short description of this ServiceClass.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"bindable": {
							SchemaProps: spec.SchemaProps{
								Description: "Bindable indicates whether a user can create bindings to an Instance provisioned from this service. ServicePlan has an optional field called Bindable which overrides the value of this field.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"plans": {
							SchemaProps: spec.SchemaProps{
								Description: "Plans is the list of ServicePlans for this ServiceClass.  All ServiceClasses have at least one ServicePlan.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ServicePlan"),
										},
									},
								},
							},
						},
						"planUpdatable": {
							SchemaProps: spec.SchemaProps{
								Description: "PlanUpdatable indicates whether instances provisioned from this ServiceClass may change ServicePlans after being provisioned.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"externalID": {
							SchemaProps: spec.SchemaProps{
								Description: "ExternalID is the identity of this object for use with the OSB API.\n\nImmutable.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"externalMetadata": {
							SchemaProps: spec.SchemaProps{
								Description: "ExternalMetadata is a blob of information about the ServiceClass, meant to be user-facing content and display instructions.  This field may contain platform-specific conventional values.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"alphaTags": {
							SchemaProps: spec.SchemaProps{
								Description: "Currently, this field is ALPHA: it may change or disappear at any time and its data will not be migrated.\n\nTags is a list of strings that represent different classification attributes of the ServiceClass.  These are used in Cloud Foundry in a way similar to Kubernetes labels, but they currently have no special meaning in Kubernetes.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"alphaRequires": {
							SchemaProps: spec.SchemaProps{
								Description: "Currently, this field is ALPHA: it may change or disappear at any time and its data will not be migrated.\n\nAlphaRequires exposes a list of Cloud Foundry-specific 'permissions' that must be granted to an instance of this service within Cloud Foundry.  These 'permissions' have no meaning within Kubernetes and an Instance provisioned from this ServiceClass will not work correctly.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"brokerName", "description", "bindable", "plans", "planUpdatable", "externalID"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ServicePlan", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ServiceClassList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServiceClassList is a list of ServiceClasses.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"items": {
							SchemaProps: spec.SchemaProps{
								Type: []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ServiceClass"),
										},
									},
								},
							},
						},
					},
					Required: []string{"items"},
				},
			},
			Dependencies: []string{
				"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ServiceClass", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
		},
		"github.com/kubernetes-incubator/service-catalog/pkg/apis/servicecatalog/v1alpha1.ServicePlan": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServicePlan represents a tier of a ServiceClass.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name is the CLI-friendly name of this ServicePlan.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"externalID": {
							SchemaProps: spec.SchemaProps{
								Description: "ExternalID is the identity of this object for use with the OSB API.\n\nImmutable.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"description": {
							SchemaProps: spec.SchemaProps{
								Description: "Description is a short description of this ServicePlan.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"bindable": {
							SchemaProps: spec.SchemaProps{
								Description: "Bindable indicates whether a user can create bindings to an Instance using this ServicePlan.  If set, overrides the value of the ServiceClass.Bindable field.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"free": {
							SchemaProps: spec.SchemaProps{
								Description: "Free indicates whether this plan is available at no cost.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"externalMetadata": {
							SchemaProps: spec.SchemaProps{
								Description: "ExternalMetadata is a blob of information about the plan, meant to be user-facing content and display instructions.  This field may contain platform-specific conventional values.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"alphaInstanceCreateParameterSchema": {
							SchemaProps: spec.SchemaProps{
								Description: "Currently, this field is ALPHA: it may change or disappear at any time and its data will not be migrated.\n\nAlphaInstanceCreateParameterSchema is the schema for the parameters that may be supplied when provisioning a new Instance on this plan.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"alphaInstanceUpdateParameterSchema": {
							SchemaProps: spec.SchemaProps{
								Description: "Currently, this field is ALPHA: it may change or disappear at any time and its data will not be migrated.\n\nAlphaInstanceUpdateParameterSchema is the schema for the parameters that may be updated once an Instance has been provisioned on this plan. This field only has meaning if the ServiceClass is PlanUpdatable.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
						"alphaBindingCreateParameterSchema": {
							SchemaProps: spec.SchemaProps{
								Description: "Currently, this field is ALPHA: it may change or disappear at any time and its data will not be migrated.\n\nAlphaBindingCreateParameterSchema is the schema for the parameters that may be supplied binding to an Instance on this plan.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
					},
					Required: []string{"name", "externalID", "description", "free"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIGroup contains the name, the supported versions, and the preferred version of a group.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name is the name of the group.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"versions": {
							SchemaProps: spec.SchemaProps{
								Description: "versions are the versions supported in this group.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery"),
										},
									},
								},
							},
						},
						"preferredVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "preferredVersion is the version preferred by the API server, which probably is the storage version.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery"),
							},
						},
						"serverAddressByClientCIDRs": {
							SchemaProps: spec.SchemaProps{
								Description: "a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"),
										},
									},
								},
							},
						},
					},
					Required: []string{"name", "versions", "serverAddressByClientCIDRs"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery", "k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroupList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groups": {
							SchemaProps: spec.SchemaProps{
								Description: "groups is a list of APIGroup.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup"),
										},
									},
								},
							},
						},
					},
					Required: []string{"groups"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIResource specifies the name of a resource and whether it is namespaced.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name is the plural name of the resource.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"singularName": {
							SchemaProps: spec.SchemaProps{
								Description: "singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespaced": {
							SchemaProps: spec.SchemaProps{
								Description: "namespaced indicates if a resource is namespaced or not.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"verbs": {
							SchemaProps: spec.SchemaProps{
								Description: "verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"shortNames": {
							SchemaProps: spec.SchemaProps{
								Description: "shortNames is a list of suggested short names of the resource.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"categories": {
							SchemaProps: spec.SchemaProps{
								Description: "categories is a list of the grouped resources this resource belongs to (e.g. 'all')",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"name", "singularName", "namespaced", "kind", "verbs"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResourceList": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"groupVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "groupVersion is the group and version this APIResourceList is for.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resources": {
							SchemaProps: spec.SchemaProps{
								Description: "resources contains the name of the resources and if they are namespaced.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.APIResource"),
										},
									},
								},
							},
						},
					},
					Required: []string{"groupVersion", "resources"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.APIResource"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIVersions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "APIVersions lists the versions that are available, to allow clients to discover the API at /api, which is the root path of the legacy v1 API.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"versions": {
							SchemaProps: spec.SchemaProps{
								Description: "versions are the api versions that are available.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"serverAddressByClientCIDRs": {
							SchemaProps: spec.SchemaProps{
								Description: "a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"),
										},
									},
								},
							},
						},
					},
					Required: []string{"versions", "serverAddressByClientCIDRs"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.DeleteOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "DeleteOptions may be provided when deleting an API object.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"gracePeriodSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"preconditions": {
							SchemaProps: spec.SchemaProps{
								Description: "Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be returned.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions"),
							},
						},
						"orphanDependents": {
							SchemaProps: spec.SchemaProps{
								Description: "Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"propagationPolicy": {
							SchemaProps: spec.SchemaProps{
								Description: "Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Duration": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Duration is a wrapper around time.Duration which supports correct marshaling to YAML and JSON. In particular, it marshals into strings, which can be used as map keys in json.",
					Properties: map[string]spec.Schema{
						"Duration": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"integer"},
								Format: "int64",
							},
						},
					},
					Required: []string{"Duration"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.ExportOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ExportOptions is the query options to the standard REST get call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"export": {
							SchemaProps: spec.SchemaProps{
								Description: "Should this value be exported.  Export strips fields that a user can not specify.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"exact": {
							SchemaProps: spec.SchemaProps{
								Description: "Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"export", "exact"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GetOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GetOptions is the standard query options to the standard REST get call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "When specified: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"includeUninitialized": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, partially initialized resources are included in the response.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupKind": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupKind specifies a Group and a Kind, but does not force a version.  This is useful for identifying concepts during lookup stages without having partially valid types",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "kind"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupResource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupResource specifies a Group and a Resource, but does not force a version.  This is useful for identifying concepts during lookup stages without having partially valid types",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "resource"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersion": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupVersion contains the \"group\" and the \"version\", which uniquely identifies the API.",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "version"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupVersion contains the \"group/version\" and \"version\" string of a version. It is made a struct to keep extensibility.",
					Properties: map[string]spec.Schema{
						"groupVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "groupVersion specifies the API group and version in the form \"group/version\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Description: "version specifies the version in the form of \"version\". This is to save the clients the trouble of splitting the GroupVersion.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"groupVersion", "version"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupVersionKind unambiguously identifies a kind.  It doesn't anonymously include GroupVersion to avoid automatic coersion.  It doesn't use a GroupVersion to avoid custom marshalling",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "version", "kind"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionResource": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "GroupVersionResource unambiguously identifies a resource.  It doesn't anonymously include GroupVersion to avoid automatic coersion.  It doesn't use a GroupVersion to avoid custom marshalling",
					Properties: map[string]spec.Schema{
						"group": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"version": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"resource": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
					},
					Required: []string{"group", "version", "resource"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Initializer": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Initializer is information about an initializer that has not yet completed.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "name of the process that is responsible for initializing this object.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"name"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Initializers": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Initializers tracks the progress of initialization.",
					Properties: map[string]spec.Schema{
						"pending": {
							SchemaProps: spec.SchemaProps{
								Description: "Pending is a list of initializers that must execute in order before this object is visible. When the last pending initializer is removed, and no failing result is set, the initializers struct will be set to nil and the object is considered as initialized and visible to all clients.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Initializer"),
										},
									},
								},
							},
						},
						"result": {
							SchemaProps: spec.SchemaProps{
								Description: "If result is set with the Failure field, the object will be persisted to storage and then deleted, ensuring that other clients can observe the deletion.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Status"),
							},
						},
					},
					Required: []string{"pending"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Initializer", "k8s.io/apimachinery/pkg/apis/meta/v1.Status"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.InternalEvent": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "InternalEvent makes watch.Event versioned",
					Properties: map[string]spec.Schema{
						"Type": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"Object": {
							SchemaProps: spec.SchemaProps{
								Description: "Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *api.Status is recommended; other types may make sense\n   depending on context.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.Object"),
							},
						},
					},
					Required: []string{"Type", "Object"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.Object"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.",
					Properties: map[string]spec.Schema{
						"matchLabels": {
							SchemaProps: spec.SchemaProps{
								Description: "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"matchExpressions": {
							SchemaProps: spec.SchemaProps{
								Description: "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"),
										},
									},
								},
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
					Properties: map[string]spec.Schema{
						"key": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "key",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "key is the label key that the selector applies to.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"operator": {
							SchemaProps: spec.SchemaProps{
								Description: "operator represents a key's relationship to a set of values. Valid operators ard In, NotIn, Exists and DoesNotExist.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"values": {
							SchemaProps: spec.SchemaProps{
								Description: "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"key", "operator"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ListMeta describes metadata that synthetic resources must have, including lists and various status objects. A resource may have only one of {ObjectMeta, ListMeta}.",
					Properties: map[string]spec.Schema{
						"selfLink": {
							SchemaProps: spec.SchemaProps{
								Description: "SelfLink is a URL representing this object. Populated by the system. Read-only.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListOptions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ListOptions is the query options to a standard REST list call.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"labelSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "A selector to restrict the list of returned objects by their labels. Defaults to everything.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"fieldSelector": {
							SchemaProps: spec.SchemaProps{
								Description: "A selector to restrict the list of returned objects by their fields. Defaults to everything.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"includeUninitialized": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, partially initialized resources are included in the response.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"watch": {
							SchemaProps: spec.SchemaProps{
								Description: "Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"timeoutSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Timeout for the list/watch call.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime": v1.MicroTime{}.OpenAPIDefinition(),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"generateName": {
							SchemaProps: spec.SchemaProps{
								Description: "GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.\n\nIf this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header).\n\nApplied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"namespace": {
							SchemaProps: spec.SchemaProps{
								Description: "Namespace defines the space within each name must be unique. An empty namespace is equivalent to the \"default\" namespace, but \"default\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.\n\nMust be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"selfLink": {
							SchemaProps: spec.SchemaProps{
								Description: "SelfLink is a URL representing this object. Populated by the system. Read-only.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.\n\nPopulated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"resourceVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.\n\nPopulated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"generation": {
							SchemaProps: spec.SchemaProps{
								Description: "A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"creationTimestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.\n\nPopulated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"deletionTimestamp": {
							SchemaProps: spec.SchemaProps{
								Description: "DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field. Once set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.\n\nPopulated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
							},
						},
						"deletionGracePeriodSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"labels": {
							SchemaProps: spec.SchemaProps{
								Description: "Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"annotations": {
							SchemaProps: spec.SchemaProps{
								Description: "Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations",
								Type:        []string{"object"},
								AdditionalProperties: &spec.SchemaOrBool{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"ownerReferences": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-merge-key": "uid",
									"x-kubernetes-patch-strategy":  "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference"),
										},
									},
								},
							},
						},
						"initializers": {
							SchemaProps: spec.SchemaProps{
								Description: "An initializer is a controller which enforces some system invariant at object creation time. This field is a list of initializers that have not yet acted on this object. If nil or empty, this object has been completely initialized. Otherwise, the object is considered uninitialized and is hidden (in list/watch and get calls) from clients that haven't explicitly asked to observe uninitialized objects.\n\nWhen an object is created, the system will populate this list with the current set of initializers. Only privileged users may set or modify this list. Once it is empty, it may not be modified further by any user.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Initializers"),
							},
						},
						"finalizers": {
							VendorExtensible: spec.VendorExtensible{
								Extensions: spec.Extensions{
									"x-kubernetes-patch-strategy": "merge",
								},
							},
							SchemaProps: spec.SchemaProps{
								Description: "Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
						"clusterName": {
							SchemaProps: spec.SchemaProps{
								Description: "The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.Initializers", "k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.",
					Properties: map[string]spec.Schema{
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "API version of the referent.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"controller": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, this reference points to the managing controller.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
						"blockOwnerDeletion": {
							SchemaProps: spec.SchemaProps{
								Description: "If true, AND if the owner has the \"foregroundDeletion\" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs \"delete\" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.",
								Type:        []string{"boolean"},
								Format:      "",
							},
						},
					},
					Required: []string{"apiVersion", "kind", "name", "uid"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Patch": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Patch is provided to give a concrete name and type to the Kubernetes PATCH request body.",
					Properties:  map[string]spec.Schema{},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.",
					Properties: map[string]spec.Schema{
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "Specifies the target UID.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.RootPaths": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "RootPaths lists the paths available at root. For example: \"/healthz\", \"/apis\".",
					Properties: map[string]spec.Schema{
						"paths": {
							SchemaProps: spec.SchemaProps{
								Description: "paths are the paths available at root.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Type:   []string{"string"},
											Format: "",
										},
									},
								},
							},
						},
					},
					Required: []string{"paths"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.",
					Properties: map[string]spec.Schema{
						"clientCIDR": {
							SchemaProps: spec.SchemaProps{
								Description: "The CIDR with which clients can match their IP to figure out the server address that they should use.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"serverAddress": {
							SchemaProps: spec.SchemaProps{
								Description: "Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
					Required: []string{"clientCIDR", "serverAddress"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Status": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Status is a return value for calls that don't return other objects.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"metadata": {
							SchemaProps: spec.SchemaProps{
								Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
							},
						},
						"status": {
							SchemaProps: spec.SchemaProps{
								Description: "Status of the operation. One of: \"Success\" or \"Failure\". More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#spec-and-status",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human-readable description of the status of this operation.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "A machine-readable description of why this operation is in the \"Failure\" status. If this value is empty there is no information available. A Reason clarifies an HTTP status code but does not override it.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"details": {
							SchemaProps: spec.SchemaProps{
								Description: "Extended data associated with the reason.  Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type.",
								Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails"),
							},
						},
						"code": {
							SchemaProps: spec.SchemaProps{
								Description: "Suggested HTTP return code for this status, 0 if not set.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered.",
					Properties: map[string]spec.Schema{
						"reason": {
							SchemaProps: spec.SchemaProps{
								Description: "A machine-readable description of the cause of the error. If this value is empty there is no information available.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"message": {
							SchemaProps: spec.SchemaProps{
								Description: "A human-readable description of the cause of the error.  This field may be presented as-is to a reader.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"field": {
							SchemaProps: spec.SchemaProps{
								Description: "The field of the resource that has caused this error, as named by its JSON serialization. May include dot and postfix notation for nested attributes. Arrays are zero-indexed.  Fields may appear more than once in an array of causes due to fields having multiple errors. Optional.\n\nExamples:\n  \"name\" - the field \"name\" on the current resource\n  \"items[0].name\" - the field \"name\" on the first array entry in \"items\"",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "StatusDetails is a set of additional properties that MAY be set by the server to provide additional information about a response. The Reason field of a Status object defines what attributes will be set. Clients must ignore fields that do not match the defined type of each attribute, and should assume that any attribute may be empty, invalid, or under defined.",
					Properties: map[string]spec.Schema{
						"name": {
							SchemaProps: spec.SchemaProps{
								Description: "The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described).",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"group": {
							SchemaProps: spec.SchemaProps{
								Description: "The group attribute of the resource associated with the status StatusReason.",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"uid": {
							SchemaProps: spec.SchemaProps{
								Description: "UID of the resource. (when there is a single resource which can be described). More info: http://kubernetes.io/docs/user-guide/identifiers#uids",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"causes": {
							SchemaProps: spec.SchemaProps{
								Description: "The Causes array includes more details associated with the StatusReason failure. Not all StatusReasons may provide detailed causes.",
								Type:        []string{"array"},
								Items: &spec.SchemaOrArray{
									Schema: &spec.Schema{
										SchemaProps: spec.SchemaProps{
											Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause"),
										},
									},
								},
							},
						},
						"retryAfterSeconds": {
							SchemaProps: spec.SchemaProps{
								Description: "If specified, the time in seconds before the operation should be retried.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause"},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.Time": v1.Time{}.OpenAPIDefinition(),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Timestamp": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Timestamp is a struct that is equivalent to Time, but intended for protobuf marshalling/unmarshalling. It is generated into a serialization that matches Time. Do not use in Go structs.",
					Properties: map[string]spec.Schema{
						"seconds": {
							SchemaProps: spec.SchemaProps{
								Description: "Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.",
								Type:        []string{"integer"},
								Format:      "int64",
							},
						},
						"nanos": {
							SchemaProps: spec.SchemaProps{
								Description: "Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive. This field may be limited in precision depending on context.",
								Type:        []string{"integer"},
								Format:      "int32",
							},
						},
					},
					Required: []string{"seconds", "nanos"},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "TypeMeta describes an individual object in an API response or request with strings representing the type of the object and its API schema version. Structures that are versioned or persisted should inline TypeMeta.",
					Properties: map[string]spec.Schema{
						"kind": {
							SchemaProps: spec.SchemaProps{
								Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds",
								Type:        []string{"string"},
								Format:      "",
							},
						},
						"apiVersion": {
							SchemaProps: spec.SchemaProps{
								Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources",
								Type:        []string{"string"},
								Format:      "",
							},
						},
					},
				},
			},
			Dependencies: []string{},
		},
		"k8s.io/apimachinery/pkg/apis/meta/v1.WatchEvent": {
			Schema: spec.Schema{
				SchemaProps: spec.SchemaProps{
					Description: "Event represents a single event to a watched resource.",
					Properties: map[string]spec.Schema{
						"type": {
							SchemaProps: spec.SchemaProps{
								Type:   []string{"string"},
								Format: "",
							},
						},
						"object": {
							SchemaProps: spec.SchemaProps{
								Description: "Object is:\n * If Type is Added or Modified: the new state of the object.\n * If Type is Deleted: the state of the object immediately before deletion.\n * If Type is Error: *Status is recommended; other types may make sense\n   depending on context.",
								Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
							},
						},
					},
					Required: []string{"type", "object"},
				},
			},
			Dependencies: []string{
				"k8s.io/apimachinery/pkg/runtime.RawExtension"},
		},
	}
}
