// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	authorization "github.com/openshift/origin/pkg/authorization/apis/authorization"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	api "k8s.io/kubernetes/pkg/api"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	unsafe "unsafe"
)

func init() {
	SchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_Action_To_authorization_Action,
		Convert_authorization_Action_To_v1_Action,
		Convert_v1_ClusterPolicy_To_authorization_ClusterPolicy,
		Convert_authorization_ClusterPolicy_To_v1_ClusterPolicy,
		Convert_v1_ClusterPolicyBinding_To_authorization_ClusterPolicyBinding,
		Convert_authorization_ClusterPolicyBinding_To_v1_ClusterPolicyBinding,
		Convert_v1_ClusterPolicyBindingList_To_authorization_ClusterPolicyBindingList,
		Convert_authorization_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList,
		Convert_v1_ClusterPolicyList_To_authorization_ClusterPolicyList,
		Convert_authorization_ClusterPolicyList_To_v1_ClusterPolicyList,
		Convert_v1_ClusterRole_To_authorization_ClusterRole,
		Convert_authorization_ClusterRole_To_v1_ClusterRole,
		Convert_v1_ClusterRoleBinding_To_authorization_ClusterRoleBinding,
		Convert_authorization_ClusterRoleBinding_To_v1_ClusterRoleBinding,
		Convert_v1_ClusterRoleBindingList_To_authorization_ClusterRoleBindingList,
		Convert_authorization_ClusterRoleBindingList_To_v1_ClusterRoleBindingList,
		Convert_v1_ClusterRoleList_To_authorization_ClusterRoleList,
		Convert_authorization_ClusterRoleList_To_v1_ClusterRoleList,
		Convert_v1_GroupRestriction_To_authorization_GroupRestriction,
		Convert_authorization_GroupRestriction_To_v1_GroupRestriction,
		Convert_v1_IsPersonalSubjectAccessReview_To_authorization_IsPersonalSubjectAccessReview,
		Convert_authorization_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview,
		Convert_v1_LocalResourceAccessReview_To_authorization_LocalResourceAccessReview,
		Convert_authorization_LocalResourceAccessReview_To_v1_LocalResourceAccessReview,
		Convert_v1_LocalSubjectAccessReview_To_authorization_LocalSubjectAccessReview,
		Convert_authorization_LocalSubjectAccessReview_To_v1_LocalSubjectAccessReview,
		Convert_v1_Policy_To_authorization_Policy,
		Convert_authorization_Policy_To_v1_Policy,
		Convert_v1_PolicyBinding_To_authorization_PolicyBinding,
		Convert_authorization_PolicyBinding_To_v1_PolicyBinding,
		Convert_v1_PolicyBindingList_To_authorization_PolicyBindingList,
		Convert_authorization_PolicyBindingList_To_v1_PolicyBindingList,
		Convert_v1_PolicyList_To_authorization_PolicyList,
		Convert_authorization_PolicyList_To_v1_PolicyList,
		Convert_v1_PolicyRule_To_authorization_PolicyRule,
		Convert_authorization_PolicyRule_To_v1_PolicyRule,
		Convert_v1_ResourceAccessReview_To_authorization_ResourceAccessReview,
		Convert_authorization_ResourceAccessReview_To_v1_ResourceAccessReview,
		Convert_v1_ResourceAccessReviewResponse_To_authorization_ResourceAccessReviewResponse,
		Convert_authorization_ResourceAccessReviewResponse_To_v1_ResourceAccessReviewResponse,
		Convert_v1_Role_To_authorization_Role,
		Convert_authorization_Role_To_v1_Role,
		Convert_v1_RoleBinding_To_authorization_RoleBinding,
		Convert_authorization_RoleBinding_To_v1_RoleBinding,
		Convert_v1_RoleBindingList_To_authorization_RoleBindingList,
		Convert_authorization_RoleBindingList_To_v1_RoleBindingList,
		Convert_v1_RoleBindingRestriction_To_authorization_RoleBindingRestriction,
		Convert_authorization_RoleBindingRestriction_To_v1_RoleBindingRestriction,
		Convert_v1_RoleBindingRestrictionList_To_authorization_RoleBindingRestrictionList,
		Convert_authorization_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList,
		Convert_v1_RoleBindingRestrictionSpec_To_authorization_RoleBindingRestrictionSpec,
		Convert_authorization_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec,
		Convert_v1_RoleList_To_authorization_RoleList,
		Convert_authorization_RoleList_To_v1_RoleList,
		Convert_v1_SelfSubjectRulesReview_To_authorization_SelfSubjectRulesReview,
		Convert_authorization_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview,
		Convert_v1_SelfSubjectRulesReviewSpec_To_authorization_SelfSubjectRulesReviewSpec,
		Convert_authorization_SelfSubjectRulesReviewSpec_To_v1_SelfSubjectRulesReviewSpec,
		Convert_v1_ServiceAccountReference_To_authorization_ServiceAccountReference,
		Convert_authorization_ServiceAccountReference_To_v1_ServiceAccountReference,
		Convert_v1_ServiceAccountRestriction_To_authorization_ServiceAccountRestriction,
		Convert_authorization_ServiceAccountRestriction_To_v1_ServiceAccountRestriction,
		Convert_v1_SubjectAccessReview_To_authorization_SubjectAccessReview,
		Convert_authorization_SubjectAccessReview_To_v1_SubjectAccessReview,
		Convert_v1_SubjectAccessReviewResponse_To_authorization_SubjectAccessReviewResponse,
		Convert_authorization_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse,
		Convert_v1_SubjectRulesReview_To_authorization_SubjectRulesReview,
		Convert_authorization_SubjectRulesReview_To_v1_SubjectRulesReview,
		Convert_v1_SubjectRulesReviewSpec_To_authorization_SubjectRulesReviewSpec,
		Convert_authorization_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec,
		Convert_v1_SubjectRulesReviewStatus_To_authorization_SubjectRulesReviewStatus,
		Convert_authorization_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus,
		Convert_v1_UserRestriction_To_authorization_UserRestriction,
		Convert_authorization_UserRestriction_To_v1_UserRestriction,
	)
}

func autoConvert_v1_Action_To_authorization_Action(in *Action, out *authorization.Action, s conversion.Scope) error {
	out.Namespace = in.Namespace
	out.Verb = in.Verb
	out.Group = in.Group
	out.Version = in.Version
	out.Resource = in.Resource
	out.ResourceName = in.ResourceName
	out.Path = in.Path
	out.IsNonResourceURL = in.IsNonResourceURL
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.Content, &out.Content, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Action_To_authorization_Action is an autogenerated conversion function.
func Convert_v1_Action_To_authorization_Action(in *Action, out *authorization.Action, s conversion.Scope) error {
	return autoConvert_v1_Action_To_authorization_Action(in, out, s)
}

func autoConvert_authorization_Action_To_v1_Action(in *authorization.Action, out *Action, s conversion.Scope) error {
	out.Namespace = in.Namespace
	out.Verb = in.Verb
	out.Group = in.Group
	out.Version = in.Version
	out.Resource = in.Resource
	out.ResourceName = in.ResourceName
	out.Path = in.Path
	out.IsNonResourceURL = in.IsNonResourceURL
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.Content, &out.Content, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_Action_To_v1_Action is an autogenerated conversion function.
func Convert_authorization_Action_To_v1_Action(in *authorization.Action, out *Action, s conversion.Scope) error {
	return autoConvert_authorization_Action_To_v1_Action(in, out, s)
}

func autoConvert_v1_ClusterPolicy_To_authorization_ClusterPolicy(in *ClusterPolicy, out *authorization.ClusterPolicy, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.LastModified = in.LastModified
	if err := Convert_v1_NamedClusterRoles_To_authorization_ClusterRolesByName(&in.Roles, &out.Roles, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_authorization_ClusterPolicy_To_v1_ClusterPolicy(in *authorization.ClusterPolicy, out *ClusterPolicy, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.LastModified = in.LastModified
	if err := Convert_authorization_ClusterRolesByName_To_v1_NamedClusterRoles(&in.Roles, &out.Roles, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_ClusterPolicy_To_v1_ClusterPolicy is an autogenerated conversion function.
func Convert_authorization_ClusterPolicy_To_v1_ClusterPolicy(in *authorization.ClusterPolicy, out *ClusterPolicy, s conversion.Scope) error {
	return autoConvert_authorization_ClusterPolicy_To_v1_ClusterPolicy(in, out, s)
}

func autoConvert_v1_ClusterPolicyBinding_To_authorization_ClusterPolicyBinding(in *ClusterPolicyBinding, out *authorization.ClusterPolicyBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.LastModified = in.LastModified
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.PolicyRef, &out.PolicyRef, s); err != nil {
		return err
	}
	if err := Convert_v1_NamedClusterRoleBindings_To_authorization_ClusterRoleBindingsByName(&in.RoleBindings, &out.RoleBindings, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_authorization_ClusterPolicyBinding_To_v1_ClusterPolicyBinding(in *authorization.ClusterPolicyBinding, out *ClusterPolicyBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.LastModified = in.LastModified
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.PolicyRef, &out.PolicyRef, s); err != nil {
		return err
	}
	if err := Convert_authorization_ClusterRoleBindingsByName_To_v1_NamedClusterRoleBindings(&in.RoleBindings, &out.RoleBindings, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_ClusterPolicyBinding_To_v1_ClusterPolicyBinding is an autogenerated conversion function.
func Convert_authorization_ClusterPolicyBinding_To_v1_ClusterPolicyBinding(in *authorization.ClusterPolicyBinding, out *ClusterPolicyBinding, s conversion.Scope) error {
	return autoConvert_authorization_ClusterPolicyBinding_To_v1_ClusterPolicyBinding(in, out, s)
}

func autoConvert_v1_ClusterPolicyBindingList_To_authorization_ClusterPolicyBindingList(in *ClusterPolicyBindingList, out *authorization.ClusterPolicyBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]authorization.ClusterPolicyBinding, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterPolicyBinding_To_authorization_ClusterPolicyBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ClusterPolicyBindingList_To_authorization_ClusterPolicyBindingList is an autogenerated conversion function.
func Convert_v1_ClusterPolicyBindingList_To_authorization_ClusterPolicyBindingList(in *ClusterPolicyBindingList, out *authorization.ClusterPolicyBindingList, s conversion.Scope) error {
	return autoConvert_v1_ClusterPolicyBindingList_To_authorization_ClusterPolicyBindingList(in, out, s)
}

func autoConvert_authorization_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList(in *authorization.ClusterPolicyBindingList, out *ClusterPolicyBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterPolicyBinding, len(*in))
		for i := range *in {
			if err := Convert_authorization_ClusterPolicyBinding_To_v1_ClusterPolicyBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]ClusterPolicyBinding, 0)
	}
	return nil
}

// Convert_authorization_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList is an autogenerated conversion function.
func Convert_authorization_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList(in *authorization.ClusterPolicyBindingList, out *ClusterPolicyBindingList, s conversion.Scope) error {
	return autoConvert_authorization_ClusterPolicyBindingList_To_v1_ClusterPolicyBindingList(in, out, s)
}

func autoConvert_v1_ClusterPolicyList_To_authorization_ClusterPolicyList(in *ClusterPolicyList, out *authorization.ClusterPolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]authorization.ClusterPolicy, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterPolicy_To_authorization_ClusterPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ClusterPolicyList_To_authorization_ClusterPolicyList is an autogenerated conversion function.
func Convert_v1_ClusterPolicyList_To_authorization_ClusterPolicyList(in *ClusterPolicyList, out *authorization.ClusterPolicyList, s conversion.Scope) error {
	return autoConvert_v1_ClusterPolicyList_To_authorization_ClusterPolicyList(in, out, s)
}

func autoConvert_authorization_ClusterPolicyList_To_v1_ClusterPolicyList(in *authorization.ClusterPolicyList, out *ClusterPolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterPolicy, len(*in))
		for i := range *in {
			if err := Convert_authorization_ClusterPolicy_To_v1_ClusterPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]ClusterPolicy, 0)
	}
	return nil
}

// Convert_authorization_ClusterPolicyList_To_v1_ClusterPolicyList is an autogenerated conversion function.
func Convert_authorization_ClusterPolicyList_To_v1_ClusterPolicyList(in *authorization.ClusterPolicyList, out *ClusterPolicyList, s conversion.Scope) error {
	return autoConvert_authorization_ClusterPolicyList_To_v1_ClusterPolicyList(in, out, s)
}

func autoConvert_v1_ClusterRole_To_authorization_ClusterRole(in *ClusterRole, out *authorization.ClusterRole, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]authorization.PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_v1_PolicyRule_To_authorization_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	return nil
}

// Convert_v1_ClusterRole_To_authorization_ClusterRole is an autogenerated conversion function.
func Convert_v1_ClusterRole_To_authorization_ClusterRole(in *ClusterRole, out *authorization.ClusterRole, s conversion.Scope) error {
	return autoConvert_v1_ClusterRole_To_authorization_ClusterRole(in, out, s)
}

func autoConvert_authorization_ClusterRole_To_v1_ClusterRole(in *authorization.ClusterRole, out *ClusterRole, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_authorization_PolicyRule_To_v1_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = make([]PolicyRule, 0)
	}
	return nil
}

// Convert_authorization_ClusterRole_To_v1_ClusterRole is an autogenerated conversion function.
func Convert_authorization_ClusterRole_To_v1_ClusterRole(in *authorization.ClusterRole, out *ClusterRole, s conversion.Scope) error {
	return autoConvert_authorization_ClusterRole_To_v1_ClusterRole(in, out, s)
}

func autoConvert_v1_ClusterRoleBinding_To_authorization_ClusterRoleBinding(in *ClusterRoleBinding, out *authorization.ClusterRoleBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	// INFO: in.UserNames opted out of conversion generation
	// INFO: in.GroupNames opted out of conversion generation
	if in.Subjects != nil {
		in, out := &in.Subjects, &out.Subjects
		*out = make([]api.ObjectReference, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subjects = nil
	}
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.RoleRef, &out.RoleRef, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_authorization_ClusterRoleBinding_To_v1_ClusterRoleBinding(in *authorization.ClusterRoleBinding, out *ClusterRoleBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Subjects != nil {
		in, out := &in.Subjects, &out.Subjects
		*out = make([]api_v1.ObjectReference, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subjects = make([]api_v1.ObjectReference, 0)
	}
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.RoleRef, &out.RoleRef, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_ClusterRoleBindingList_To_authorization_ClusterRoleBindingList(in *ClusterRoleBindingList, out *authorization.ClusterRoleBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]authorization.ClusterRoleBinding, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterRoleBinding_To_authorization_ClusterRoleBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ClusterRoleBindingList_To_authorization_ClusterRoleBindingList is an autogenerated conversion function.
func Convert_v1_ClusterRoleBindingList_To_authorization_ClusterRoleBindingList(in *ClusterRoleBindingList, out *authorization.ClusterRoleBindingList, s conversion.Scope) error {
	return autoConvert_v1_ClusterRoleBindingList_To_authorization_ClusterRoleBindingList(in, out, s)
}

func autoConvert_authorization_ClusterRoleBindingList_To_v1_ClusterRoleBindingList(in *authorization.ClusterRoleBindingList, out *ClusterRoleBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterRoleBinding, len(*in))
		for i := range *in {
			if err := Convert_authorization_ClusterRoleBinding_To_v1_ClusterRoleBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]ClusterRoleBinding, 0)
	}
	return nil
}

// Convert_authorization_ClusterRoleBindingList_To_v1_ClusterRoleBindingList is an autogenerated conversion function.
func Convert_authorization_ClusterRoleBindingList_To_v1_ClusterRoleBindingList(in *authorization.ClusterRoleBindingList, out *ClusterRoleBindingList, s conversion.Scope) error {
	return autoConvert_authorization_ClusterRoleBindingList_To_v1_ClusterRoleBindingList(in, out, s)
}

func autoConvert_v1_ClusterRoleList_To_authorization_ClusterRoleList(in *ClusterRoleList, out *authorization.ClusterRoleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]authorization.ClusterRole, len(*in))
		for i := range *in {
			if err := Convert_v1_ClusterRole_To_authorization_ClusterRole(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_ClusterRoleList_To_authorization_ClusterRoleList is an autogenerated conversion function.
func Convert_v1_ClusterRoleList_To_authorization_ClusterRoleList(in *ClusterRoleList, out *authorization.ClusterRoleList, s conversion.Scope) error {
	return autoConvert_v1_ClusterRoleList_To_authorization_ClusterRoleList(in, out, s)
}

func autoConvert_authorization_ClusterRoleList_To_v1_ClusterRoleList(in *authorization.ClusterRoleList, out *ClusterRoleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ClusterRole, len(*in))
		for i := range *in {
			if err := Convert_authorization_ClusterRole_To_v1_ClusterRole(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]ClusterRole, 0)
	}
	return nil
}

// Convert_authorization_ClusterRoleList_To_v1_ClusterRoleList is an autogenerated conversion function.
func Convert_authorization_ClusterRoleList_To_v1_ClusterRoleList(in *authorization.ClusterRoleList, out *ClusterRoleList, s conversion.Scope) error {
	return autoConvert_authorization_ClusterRoleList_To_v1_ClusterRoleList(in, out, s)
}

func autoConvert_v1_GroupRestriction_To_authorization_GroupRestriction(in *GroupRestriction, out *authorization.GroupRestriction, s conversion.Scope) error {
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Selectors = *(*[]meta_v1.LabelSelector)(unsafe.Pointer(&in.Selectors))
	return nil
}

// Convert_v1_GroupRestriction_To_authorization_GroupRestriction is an autogenerated conversion function.
func Convert_v1_GroupRestriction_To_authorization_GroupRestriction(in *GroupRestriction, out *authorization.GroupRestriction, s conversion.Scope) error {
	return autoConvert_v1_GroupRestriction_To_authorization_GroupRestriction(in, out, s)
}

func autoConvert_authorization_GroupRestriction_To_v1_GroupRestriction(in *authorization.GroupRestriction, out *GroupRestriction, s conversion.Scope) error {
	if in.Groups == nil {
		out.Groups = make([]string, 0)
	} else {
		out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	}
	if in.Selectors == nil {
		out.Selectors = make([]meta_v1.LabelSelector, 0)
	} else {
		out.Selectors = *(*[]meta_v1.LabelSelector)(unsafe.Pointer(&in.Selectors))
	}
	return nil
}

// Convert_authorization_GroupRestriction_To_v1_GroupRestriction is an autogenerated conversion function.
func Convert_authorization_GroupRestriction_To_v1_GroupRestriction(in *authorization.GroupRestriction, out *GroupRestriction, s conversion.Scope) error {
	return autoConvert_authorization_GroupRestriction_To_v1_GroupRestriction(in, out, s)
}

func autoConvert_v1_IsPersonalSubjectAccessReview_To_authorization_IsPersonalSubjectAccessReview(in *IsPersonalSubjectAccessReview, out *authorization.IsPersonalSubjectAccessReview, s conversion.Scope) error {
	return nil
}

// Convert_v1_IsPersonalSubjectAccessReview_To_authorization_IsPersonalSubjectAccessReview is an autogenerated conversion function.
func Convert_v1_IsPersonalSubjectAccessReview_To_authorization_IsPersonalSubjectAccessReview(in *IsPersonalSubjectAccessReview, out *authorization.IsPersonalSubjectAccessReview, s conversion.Scope) error {
	return autoConvert_v1_IsPersonalSubjectAccessReview_To_authorization_IsPersonalSubjectAccessReview(in, out, s)
}

func autoConvert_authorization_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview(in *authorization.IsPersonalSubjectAccessReview, out *IsPersonalSubjectAccessReview, s conversion.Scope) error {
	return nil
}

// Convert_authorization_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview is an autogenerated conversion function.
func Convert_authorization_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview(in *authorization.IsPersonalSubjectAccessReview, out *IsPersonalSubjectAccessReview, s conversion.Scope) error {
	return autoConvert_authorization_IsPersonalSubjectAccessReview_To_v1_IsPersonalSubjectAccessReview(in, out, s)
}

func autoConvert_v1_LocalResourceAccessReview_To_authorization_LocalResourceAccessReview(in *LocalResourceAccessReview, out *authorization.LocalResourceAccessReview, s conversion.Scope) error {
	if err := Convert_v1_Action_To_authorization_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_LocalResourceAccessReview_To_authorization_LocalResourceAccessReview is an autogenerated conversion function.
func Convert_v1_LocalResourceAccessReview_To_authorization_LocalResourceAccessReview(in *LocalResourceAccessReview, out *authorization.LocalResourceAccessReview, s conversion.Scope) error {
	return autoConvert_v1_LocalResourceAccessReview_To_authorization_LocalResourceAccessReview(in, out, s)
}

func autoConvert_authorization_LocalResourceAccessReview_To_v1_LocalResourceAccessReview(in *authorization.LocalResourceAccessReview, out *LocalResourceAccessReview, s conversion.Scope) error {
	if err := Convert_authorization_Action_To_v1_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_LocalResourceAccessReview_To_v1_LocalResourceAccessReview is an autogenerated conversion function.
func Convert_authorization_LocalResourceAccessReview_To_v1_LocalResourceAccessReview(in *authorization.LocalResourceAccessReview, out *LocalResourceAccessReview, s conversion.Scope) error {
	return autoConvert_authorization_LocalResourceAccessReview_To_v1_LocalResourceAccessReview(in, out, s)
}

func autoConvert_v1_LocalSubjectAccessReview_To_authorization_LocalSubjectAccessReview(in *LocalSubjectAccessReview, out *authorization.LocalSubjectAccessReview, s conversion.Scope) error {
	if err := Convert_v1_Action_To_authorization_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	out.User = in.User
	// INFO: in.GroupsSlice opted out of conversion generation
	// INFO: in.Scopes opted out of conversion generation
	return nil
}

func autoConvert_authorization_LocalSubjectAccessReview_To_v1_LocalSubjectAccessReview(in *authorization.LocalSubjectAccessReview, out *LocalSubjectAccessReview, s conversion.Scope) error {
	if err := Convert_authorization_Action_To_v1_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	out.User = in.User
	// INFO: in.Groups opted out of conversion generation
	// INFO: in.Scopes opted out of conversion generation
	return nil
}

func autoConvert_v1_Policy_To_authorization_Policy(in *Policy, out *authorization.Policy, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.LastModified = in.LastModified
	if err := Convert_v1_NamedRoles_To_authorization_RolesByName(&in.Roles, &out.Roles, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_authorization_Policy_To_v1_Policy(in *authorization.Policy, out *Policy, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.LastModified = in.LastModified
	if err := Convert_authorization_RolesByName_To_v1_NamedRoles(&in.Roles, &out.Roles, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_Policy_To_v1_Policy is an autogenerated conversion function.
func Convert_authorization_Policy_To_v1_Policy(in *authorization.Policy, out *Policy, s conversion.Scope) error {
	return autoConvert_authorization_Policy_To_v1_Policy(in, out, s)
}

func autoConvert_v1_PolicyBinding_To_authorization_PolicyBinding(in *PolicyBinding, out *authorization.PolicyBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.LastModified = in.LastModified
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.PolicyRef, &out.PolicyRef, s); err != nil {
		return err
	}
	if err := Convert_v1_NamedRoleBindings_To_authorization_RoleBindingsByName(&in.RoleBindings, &out.RoleBindings, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_authorization_PolicyBinding_To_v1_PolicyBinding(in *authorization.PolicyBinding, out *PolicyBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.LastModified = in.LastModified
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.PolicyRef, &out.PolicyRef, s); err != nil {
		return err
	}
	if err := Convert_authorization_RoleBindingsByName_To_v1_NamedRoleBindings(&in.RoleBindings, &out.RoleBindings, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_PolicyBinding_To_v1_PolicyBinding is an autogenerated conversion function.
func Convert_authorization_PolicyBinding_To_v1_PolicyBinding(in *authorization.PolicyBinding, out *PolicyBinding, s conversion.Scope) error {
	return autoConvert_authorization_PolicyBinding_To_v1_PolicyBinding(in, out, s)
}

func autoConvert_v1_PolicyBindingList_To_authorization_PolicyBindingList(in *PolicyBindingList, out *authorization.PolicyBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]authorization.PolicyBinding, len(*in))
		for i := range *in {
			if err := Convert_v1_PolicyBinding_To_authorization_PolicyBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_PolicyBindingList_To_authorization_PolicyBindingList is an autogenerated conversion function.
func Convert_v1_PolicyBindingList_To_authorization_PolicyBindingList(in *PolicyBindingList, out *authorization.PolicyBindingList, s conversion.Scope) error {
	return autoConvert_v1_PolicyBindingList_To_authorization_PolicyBindingList(in, out, s)
}

func autoConvert_authorization_PolicyBindingList_To_v1_PolicyBindingList(in *authorization.PolicyBindingList, out *PolicyBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]PolicyBinding, len(*in))
		for i := range *in {
			if err := Convert_authorization_PolicyBinding_To_v1_PolicyBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]PolicyBinding, 0)
	}
	return nil
}

// Convert_authorization_PolicyBindingList_To_v1_PolicyBindingList is an autogenerated conversion function.
func Convert_authorization_PolicyBindingList_To_v1_PolicyBindingList(in *authorization.PolicyBindingList, out *PolicyBindingList, s conversion.Scope) error {
	return autoConvert_authorization_PolicyBindingList_To_v1_PolicyBindingList(in, out, s)
}

func autoConvert_v1_PolicyList_To_authorization_PolicyList(in *PolicyList, out *authorization.PolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]authorization.Policy, len(*in))
		for i := range *in {
			if err := Convert_v1_Policy_To_authorization_Policy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_PolicyList_To_authorization_PolicyList is an autogenerated conversion function.
func Convert_v1_PolicyList_To_authorization_PolicyList(in *PolicyList, out *authorization.PolicyList, s conversion.Scope) error {
	return autoConvert_v1_PolicyList_To_authorization_PolicyList(in, out, s)
}

func autoConvert_authorization_PolicyList_To_v1_PolicyList(in *authorization.PolicyList, out *PolicyList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Policy, len(*in))
		for i := range *in {
			if err := Convert_authorization_Policy_To_v1_Policy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]Policy, 0)
	}
	return nil
}

// Convert_authorization_PolicyList_To_v1_PolicyList is an autogenerated conversion function.
func Convert_authorization_PolicyList_To_v1_PolicyList(in *authorization.PolicyList, out *PolicyList, s conversion.Scope) error {
	return autoConvert_authorization_PolicyList_To_v1_PolicyList(in, out, s)
}

func autoConvert_v1_PolicyRule_To_authorization_PolicyRule(in *PolicyRule, out *authorization.PolicyRule, s conversion.Scope) error {
	// WARNING: in.Verbs requires manual conversion: inconvertible types ([]string vs k8s.io/apimachinery/pkg/util/sets.String)
	if err := runtime.Convert_runtime_RawExtension_To_runtime_Object(&in.AttributeRestrictions, &out.AttributeRestrictions, s); err != nil {
		return err
	}
	out.APIGroups = *(*[]string)(unsafe.Pointer(&in.APIGroups))
	// WARNING: in.Resources requires manual conversion: inconvertible types ([]string vs k8s.io/apimachinery/pkg/util/sets.String)
	// WARNING: in.ResourceNames requires manual conversion: inconvertible types ([]string vs k8s.io/apimachinery/pkg/util/sets.String)
	// WARNING: in.NonResourceURLsSlice requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_authorization_PolicyRule_To_v1_PolicyRule(in *authorization.PolicyRule, out *PolicyRule, s conversion.Scope) error {
	// WARNING: in.Verbs requires manual conversion: inconvertible types (k8s.io/apimachinery/pkg/util/sets.String vs []string)
	if err := runtime.Convert_runtime_Object_To_runtime_RawExtension(&in.AttributeRestrictions, &out.AttributeRestrictions, s); err != nil {
		return err
	}
	if in.APIGroups == nil {
		out.APIGroups = make([]string, 0)
	} else {
		out.APIGroups = *(*[]string)(unsafe.Pointer(&in.APIGroups))
	}
	// WARNING: in.Resources requires manual conversion: inconvertible types (k8s.io/apimachinery/pkg/util/sets.String vs []string)
	// WARNING: in.ResourceNames requires manual conversion: inconvertible types (k8s.io/apimachinery/pkg/util/sets.String vs []string)
	// WARNING: in.NonResourceURLs requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1_ResourceAccessReview_To_authorization_ResourceAccessReview(in *ResourceAccessReview, out *authorization.ResourceAccessReview, s conversion.Scope) error {
	if err := Convert_v1_Action_To_authorization_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ResourceAccessReview_To_authorization_ResourceAccessReview is an autogenerated conversion function.
func Convert_v1_ResourceAccessReview_To_authorization_ResourceAccessReview(in *ResourceAccessReview, out *authorization.ResourceAccessReview, s conversion.Scope) error {
	return autoConvert_v1_ResourceAccessReview_To_authorization_ResourceAccessReview(in, out, s)
}

func autoConvert_authorization_ResourceAccessReview_To_v1_ResourceAccessReview(in *authorization.ResourceAccessReview, out *ResourceAccessReview, s conversion.Scope) error {
	if err := Convert_authorization_Action_To_v1_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_ResourceAccessReview_To_v1_ResourceAccessReview is an autogenerated conversion function.
func Convert_authorization_ResourceAccessReview_To_v1_ResourceAccessReview(in *authorization.ResourceAccessReview, out *ResourceAccessReview, s conversion.Scope) error {
	return autoConvert_authorization_ResourceAccessReview_To_v1_ResourceAccessReview(in, out, s)
}

func autoConvert_v1_ResourceAccessReviewResponse_To_authorization_ResourceAccessReviewResponse(in *ResourceAccessReviewResponse, out *authorization.ResourceAccessReviewResponse, s conversion.Scope) error {
	out.Namespace = in.Namespace
	// INFO: in.UsersSlice opted out of conversion generation
	// INFO: in.GroupsSlice opted out of conversion generation
	out.EvaluationError = in.EvaluationError
	return nil
}

func autoConvert_authorization_ResourceAccessReviewResponse_To_v1_ResourceAccessReviewResponse(in *authorization.ResourceAccessReviewResponse, out *ResourceAccessReviewResponse, s conversion.Scope) error {
	out.Namespace = in.Namespace
	// INFO: in.Users opted out of conversion generation
	// INFO: in.Groups opted out of conversion generation
	out.EvaluationError = in.EvaluationError
	return nil
}

func autoConvert_v1_Role_To_authorization_Role(in *Role, out *authorization.Role, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]authorization.PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_v1_PolicyRule_To_authorization_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	return nil
}

// Convert_v1_Role_To_authorization_Role is an autogenerated conversion function.
func Convert_v1_Role_To_authorization_Role(in *Role, out *authorization.Role, s conversion.Scope) error {
	return autoConvert_v1_Role_To_authorization_Role(in, out, s)
}

func autoConvert_authorization_Role_To_v1_Role(in *authorization.Role, out *Role, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_authorization_PolicyRule_To_v1_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = make([]PolicyRule, 0)
	}
	return nil
}

// Convert_authorization_Role_To_v1_Role is an autogenerated conversion function.
func Convert_authorization_Role_To_v1_Role(in *authorization.Role, out *Role, s conversion.Scope) error {
	return autoConvert_authorization_Role_To_v1_Role(in, out, s)
}

func autoConvert_v1_RoleBinding_To_authorization_RoleBinding(in *RoleBinding, out *authorization.RoleBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	// INFO: in.UserNames opted out of conversion generation
	// INFO: in.GroupNames opted out of conversion generation
	if in.Subjects != nil {
		in, out := &in.Subjects, &out.Subjects
		*out = make([]api.ObjectReference, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subjects = nil
	}
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.RoleRef, &out.RoleRef, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_authorization_RoleBinding_To_v1_RoleBinding(in *authorization.RoleBinding, out *RoleBinding, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Subjects != nil {
		in, out := &in.Subjects, &out.Subjects
		*out = make([]api_v1.ObjectReference, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subjects = make([]api_v1.ObjectReference, 0)
	}
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.RoleRef, &out.RoleRef, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_RoleBindingList_To_authorization_RoleBindingList(in *RoleBindingList, out *authorization.RoleBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]authorization.RoleBinding, len(*in))
		for i := range *in {
			if err := Convert_v1_RoleBinding_To_authorization_RoleBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_RoleBindingList_To_authorization_RoleBindingList is an autogenerated conversion function.
func Convert_v1_RoleBindingList_To_authorization_RoleBindingList(in *RoleBindingList, out *authorization.RoleBindingList, s conversion.Scope) error {
	return autoConvert_v1_RoleBindingList_To_authorization_RoleBindingList(in, out, s)
}

func autoConvert_authorization_RoleBindingList_To_v1_RoleBindingList(in *authorization.RoleBindingList, out *RoleBindingList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]RoleBinding, len(*in))
		for i := range *in {
			if err := Convert_authorization_RoleBinding_To_v1_RoleBinding(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]RoleBinding, 0)
	}
	return nil
}

// Convert_authorization_RoleBindingList_To_v1_RoleBindingList is an autogenerated conversion function.
func Convert_authorization_RoleBindingList_To_v1_RoleBindingList(in *authorization.RoleBindingList, out *RoleBindingList, s conversion.Scope) error {
	return autoConvert_authorization_RoleBindingList_To_v1_RoleBindingList(in, out, s)
}

func autoConvert_v1_RoleBindingRestriction_To_authorization_RoleBindingRestriction(in *RoleBindingRestriction, out *authorization.RoleBindingRestriction, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_RoleBindingRestrictionSpec_To_authorization_RoleBindingRestrictionSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_RoleBindingRestriction_To_authorization_RoleBindingRestriction is an autogenerated conversion function.
func Convert_v1_RoleBindingRestriction_To_authorization_RoleBindingRestriction(in *RoleBindingRestriction, out *authorization.RoleBindingRestriction, s conversion.Scope) error {
	return autoConvert_v1_RoleBindingRestriction_To_authorization_RoleBindingRestriction(in, out, s)
}

func autoConvert_authorization_RoleBindingRestriction_To_v1_RoleBindingRestriction(in *authorization.RoleBindingRestriction, out *RoleBindingRestriction, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_authorization_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_RoleBindingRestriction_To_v1_RoleBindingRestriction is an autogenerated conversion function.
func Convert_authorization_RoleBindingRestriction_To_v1_RoleBindingRestriction(in *authorization.RoleBindingRestriction, out *RoleBindingRestriction, s conversion.Scope) error {
	return autoConvert_authorization_RoleBindingRestriction_To_v1_RoleBindingRestriction(in, out, s)
}

func autoConvert_v1_RoleBindingRestrictionList_To_authorization_RoleBindingRestrictionList(in *RoleBindingRestrictionList, out *authorization.RoleBindingRestrictionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]authorization.RoleBindingRestriction)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_RoleBindingRestrictionList_To_authorization_RoleBindingRestrictionList is an autogenerated conversion function.
func Convert_v1_RoleBindingRestrictionList_To_authorization_RoleBindingRestrictionList(in *RoleBindingRestrictionList, out *authorization.RoleBindingRestrictionList, s conversion.Scope) error {
	return autoConvert_v1_RoleBindingRestrictionList_To_authorization_RoleBindingRestrictionList(in, out, s)
}

func autoConvert_authorization_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList(in *authorization.RoleBindingRestrictionList, out *RoleBindingRestrictionList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items == nil {
		out.Items = make([]RoleBindingRestriction, 0)
	} else {
		out.Items = *(*[]RoleBindingRestriction)(unsafe.Pointer(&in.Items))
	}
	return nil
}

// Convert_authorization_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList is an autogenerated conversion function.
func Convert_authorization_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList(in *authorization.RoleBindingRestrictionList, out *RoleBindingRestrictionList, s conversion.Scope) error {
	return autoConvert_authorization_RoleBindingRestrictionList_To_v1_RoleBindingRestrictionList(in, out, s)
}

func autoConvert_v1_RoleBindingRestrictionSpec_To_authorization_RoleBindingRestrictionSpec(in *RoleBindingRestrictionSpec, out *authorization.RoleBindingRestrictionSpec, s conversion.Scope) error {
	out.UserRestriction = (*authorization.UserRestriction)(unsafe.Pointer(in.UserRestriction))
	out.GroupRestriction = (*authorization.GroupRestriction)(unsafe.Pointer(in.GroupRestriction))
	out.ServiceAccountRestriction = (*authorization.ServiceAccountRestriction)(unsafe.Pointer(in.ServiceAccountRestriction))
	return nil
}

// Convert_v1_RoleBindingRestrictionSpec_To_authorization_RoleBindingRestrictionSpec is an autogenerated conversion function.
func Convert_v1_RoleBindingRestrictionSpec_To_authorization_RoleBindingRestrictionSpec(in *RoleBindingRestrictionSpec, out *authorization.RoleBindingRestrictionSpec, s conversion.Scope) error {
	return autoConvert_v1_RoleBindingRestrictionSpec_To_authorization_RoleBindingRestrictionSpec(in, out, s)
}

func autoConvert_authorization_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec(in *authorization.RoleBindingRestrictionSpec, out *RoleBindingRestrictionSpec, s conversion.Scope) error {
	out.UserRestriction = (*UserRestriction)(unsafe.Pointer(in.UserRestriction))
	out.GroupRestriction = (*GroupRestriction)(unsafe.Pointer(in.GroupRestriction))
	out.ServiceAccountRestriction = (*ServiceAccountRestriction)(unsafe.Pointer(in.ServiceAccountRestriction))
	return nil
}

// Convert_authorization_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec is an autogenerated conversion function.
func Convert_authorization_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec(in *authorization.RoleBindingRestrictionSpec, out *RoleBindingRestrictionSpec, s conversion.Scope) error {
	return autoConvert_authorization_RoleBindingRestrictionSpec_To_v1_RoleBindingRestrictionSpec(in, out, s)
}

func autoConvert_v1_RoleList_To_authorization_RoleList(in *RoleList, out *authorization.RoleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]authorization.Role, len(*in))
		for i := range *in {
			if err := Convert_v1_Role_To_authorization_Role(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_RoleList_To_authorization_RoleList is an autogenerated conversion function.
func Convert_v1_RoleList_To_authorization_RoleList(in *RoleList, out *authorization.RoleList, s conversion.Scope) error {
	return autoConvert_v1_RoleList_To_authorization_RoleList(in, out, s)
}

func autoConvert_authorization_RoleList_To_v1_RoleList(in *authorization.RoleList, out *RoleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Role, len(*in))
		for i := range *in {
			if err := Convert_authorization_Role_To_v1_Role(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]Role, 0)
	}
	return nil
}

// Convert_authorization_RoleList_To_v1_RoleList is an autogenerated conversion function.
func Convert_authorization_RoleList_To_v1_RoleList(in *authorization.RoleList, out *RoleList, s conversion.Scope) error {
	return autoConvert_authorization_RoleList_To_v1_RoleList(in, out, s)
}

func autoConvert_v1_SelfSubjectRulesReview_To_authorization_SelfSubjectRulesReview(in *SelfSubjectRulesReview, out *authorization.SelfSubjectRulesReview, s conversion.Scope) error {
	if err := Convert_v1_SelfSubjectRulesReviewSpec_To_authorization_SelfSubjectRulesReviewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_SubjectRulesReviewStatus_To_authorization_SubjectRulesReviewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_SelfSubjectRulesReview_To_authorization_SelfSubjectRulesReview is an autogenerated conversion function.
func Convert_v1_SelfSubjectRulesReview_To_authorization_SelfSubjectRulesReview(in *SelfSubjectRulesReview, out *authorization.SelfSubjectRulesReview, s conversion.Scope) error {
	return autoConvert_v1_SelfSubjectRulesReview_To_authorization_SelfSubjectRulesReview(in, out, s)
}

func autoConvert_authorization_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview(in *authorization.SelfSubjectRulesReview, out *SelfSubjectRulesReview, s conversion.Scope) error {
	if err := Convert_authorization_SelfSubjectRulesReviewSpec_To_v1_SelfSubjectRulesReviewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_authorization_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview is an autogenerated conversion function.
func Convert_authorization_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview(in *authorization.SelfSubjectRulesReview, out *SelfSubjectRulesReview, s conversion.Scope) error {
	return autoConvert_authorization_SelfSubjectRulesReview_To_v1_SelfSubjectRulesReview(in, out, s)
}

func autoConvert_v1_SelfSubjectRulesReviewSpec_To_authorization_SelfSubjectRulesReviewSpec(in *SelfSubjectRulesReviewSpec, out *authorization.SelfSubjectRulesReviewSpec, s conversion.Scope) error {
	// INFO: in.Scopes opted out of conversion generation
	return nil
}

func autoConvert_authorization_SelfSubjectRulesReviewSpec_To_v1_SelfSubjectRulesReviewSpec(in *authorization.SelfSubjectRulesReviewSpec, out *SelfSubjectRulesReviewSpec, s conversion.Scope) error {
	// INFO: in.Scopes opted out of conversion generation
	return nil
}

func autoConvert_v1_ServiceAccountReference_To_authorization_ServiceAccountReference(in *ServiceAccountReference, out *authorization.ServiceAccountReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_v1_ServiceAccountReference_To_authorization_ServiceAccountReference is an autogenerated conversion function.
func Convert_v1_ServiceAccountReference_To_authorization_ServiceAccountReference(in *ServiceAccountReference, out *authorization.ServiceAccountReference, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccountReference_To_authorization_ServiceAccountReference(in, out, s)
}

func autoConvert_authorization_ServiceAccountReference_To_v1_ServiceAccountReference(in *authorization.ServiceAccountReference, out *ServiceAccountReference, s conversion.Scope) error {
	out.Name = in.Name
	out.Namespace = in.Namespace
	return nil
}

// Convert_authorization_ServiceAccountReference_To_v1_ServiceAccountReference is an autogenerated conversion function.
func Convert_authorization_ServiceAccountReference_To_v1_ServiceAccountReference(in *authorization.ServiceAccountReference, out *ServiceAccountReference, s conversion.Scope) error {
	return autoConvert_authorization_ServiceAccountReference_To_v1_ServiceAccountReference(in, out, s)
}

func autoConvert_v1_ServiceAccountRestriction_To_authorization_ServiceAccountRestriction(in *ServiceAccountRestriction, out *authorization.ServiceAccountRestriction, s conversion.Scope) error {
	out.ServiceAccounts = *(*[]authorization.ServiceAccountReference)(unsafe.Pointer(&in.ServiceAccounts))
	out.Namespaces = *(*[]string)(unsafe.Pointer(&in.Namespaces))
	return nil
}

// Convert_v1_ServiceAccountRestriction_To_authorization_ServiceAccountRestriction is an autogenerated conversion function.
func Convert_v1_ServiceAccountRestriction_To_authorization_ServiceAccountRestriction(in *ServiceAccountRestriction, out *authorization.ServiceAccountRestriction, s conversion.Scope) error {
	return autoConvert_v1_ServiceAccountRestriction_To_authorization_ServiceAccountRestriction(in, out, s)
}

func autoConvert_authorization_ServiceAccountRestriction_To_v1_ServiceAccountRestriction(in *authorization.ServiceAccountRestriction, out *ServiceAccountRestriction, s conversion.Scope) error {
	if in.ServiceAccounts == nil {
		out.ServiceAccounts = make([]ServiceAccountReference, 0)
	} else {
		out.ServiceAccounts = *(*[]ServiceAccountReference)(unsafe.Pointer(&in.ServiceAccounts))
	}
	if in.Namespaces == nil {
		out.Namespaces = make([]string, 0)
	} else {
		out.Namespaces = *(*[]string)(unsafe.Pointer(&in.Namespaces))
	}
	return nil
}

// Convert_authorization_ServiceAccountRestriction_To_v1_ServiceAccountRestriction is an autogenerated conversion function.
func Convert_authorization_ServiceAccountRestriction_To_v1_ServiceAccountRestriction(in *authorization.ServiceAccountRestriction, out *ServiceAccountRestriction, s conversion.Scope) error {
	return autoConvert_authorization_ServiceAccountRestriction_To_v1_ServiceAccountRestriction(in, out, s)
}

func autoConvert_v1_SubjectAccessReview_To_authorization_SubjectAccessReview(in *SubjectAccessReview, out *authorization.SubjectAccessReview, s conversion.Scope) error {
	if err := Convert_v1_Action_To_authorization_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	out.User = in.User
	// INFO: in.GroupsSlice opted out of conversion generation
	// INFO: in.Scopes opted out of conversion generation
	return nil
}

func autoConvert_authorization_SubjectAccessReview_To_v1_SubjectAccessReview(in *authorization.SubjectAccessReview, out *SubjectAccessReview, s conversion.Scope) error {
	if err := Convert_authorization_Action_To_v1_Action(&in.Action, &out.Action, s); err != nil {
		return err
	}
	out.User = in.User
	// INFO: in.Groups opted out of conversion generation
	// INFO: in.Scopes opted out of conversion generation
	return nil
}

func autoConvert_v1_SubjectAccessReviewResponse_To_authorization_SubjectAccessReviewResponse(in *SubjectAccessReviewResponse, out *authorization.SubjectAccessReviewResponse, s conversion.Scope) error {
	out.Namespace = in.Namespace
	out.Allowed = in.Allowed
	out.Reason = in.Reason
	out.EvaluationError = in.EvaluationError
	return nil
}

// Convert_v1_SubjectAccessReviewResponse_To_authorization_SubjectAccessReviewResponse is an autogenerated conversion function.
func Convert_v1_SubjectAccessReviewResponse_To_authorization_SubjectAccessReviewResponse(in *SubjectAccessReviewResponse, out *authorization.SubjectAccessReviewResponse, s conversion.Scope) error {
	return autoConvert_v1_SubjectAccessReviewResponse_To_authorization_SubjectAccessReviewResponse(in, out, s)
}

func autoConvert_authorization_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse(in *authorization.SubjectAccessReviewResponse, out *SubjectAccessReviewResponse, s conversion.Scope) error {
	out.Namespace = in.Namespace
	out.Allowed = in.Allowed
	out.Reason = in.Reason
	out.EvaluationError = in.EvaluationError
	return nil
}

// Convert_authorization_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse is an autogenerated conversion function.
func Convert_authorization_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse(in *authorization.SubjectAccessReviewResponse, out *SubjectAccessReviewResponse, s conversion.Scope) error {
	return autoConvert_authorization_SubjectAccessReviewResponse_To_v1_SubjectAccessReviewResponse(in, out, s)
}

func autoConvert_v1_SubjectRulesReview_To_authorization_SubjectRulesReview(in *SubjectRulesReview, out *authorization.SubjectRulesReview, s conversion.Scope) error {
	if err := Convert_v1_SubjectRulesReviewSpec_To_authorization_SubjectRulesReviewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_SubjectRulesReviewStatus_To_authorization_SubjectRulesReviewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_SubjectRulesReview_To_authorization_SubjectRulesReview is an autogenerated conversion function.
func Convert_v1_SubjectRulesReview_To_authorization_SubjectRulesReview(in *SubjectRulesReview, out *authorization.SubjectRulesReview, s conversion.Scope) error {
	return autoConvert_v1_SubjectRulesReview_To_authorization_SubjectRulesReview(in, out, s)
}

func autoConvert_authorization_SubjectRulesReview_To_v1_SubjectRulesReview(in *authorization.SubjectRulesReview, out *SubjectRulesReview, s conversion.Scope) error {
	if err := Convert_authorization_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_authorization_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_authorization_SubjectRulesReview_To_v1_SubjectRulesReview is an autogenerated conversion function.
func Convert_authorization_SubjectRulesReview_To_v1_SubjectRulesReview(in *authorization.SubjectRulesReview, out *SubjectRulesReview, s conversion.Scope) error {
	return autoConvert_authorization_SubjectRulesReview_To_v1_SubjectRulesReview(in, out, s)
}

func autoConvert_v1_SubjectRulesReviewSpec_To_authorization_SubjectRulesReviewSpec(in *SubjectRulesReviewSpec, out *authorization.SubjectRulesReviewSpec, s conversion.Scope) error {
	out.User = in.User
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Scopes = *(*[]string)(unsafe.Pointer(&in.Scopes))
	return nil
}

// Convert_v1_SubjectRulesReviewSpec_To_authorization_SubjectRulesReviewSpec is an autogenerated conversion function.
func Convert_v1_SubjectRulesReviewSpec_To_authorization_SubjectRulesReviewSpec(in *SubjectRulesReviewSpec, out *authorization.SubjectRulesReviewSpec, s conversion.Scope) error {
	return autoConvert_v1_SubjectRulesReviewSpec_To_authorization_SubjectRulesReviewSpec(in, out, s)
}

func autoConvert_authorization_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec(in *authorization.SubjectRulesReviewSpec, out *SubjectRulesReviewSpec, s conversion.Scope) error {
	out.User = in.User
	if in.Groups == nil {
		out.Groups = make([]string, 0)
	} else {
		out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	}
	if in.Scopes == nil {
		out.Scopes = make(OptionalScopes, 0)
	} else {
		out.Scopes = *(*OptionalScopes)(unsafe.Pointer(&in.Scopes))
	}
	return nil
}

// Convert_authorization_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec is an autogenerated conversion function.
func Convert_authorization_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec(in *authorization.SubjectRulesReviewSpec, out *SubjectRulesReviewSpec, s conversion.Scope) error {
	return autoConvert_authorization_SubjectRulesReviewSpec_To_v1_SubjectRulesReviewSpec(in, out, s)
}

func autoConvert_v1_SubjectRulesReviewStatus_To_authorization_SubjectRulesReviewStatus(in *SubjectRulesReviewStatus, out *authorization.SubjectRulesReviewStatus, s conversion.Scope) error {
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]authorization.PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_v1_PolicyRule_To_authorization_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = nil
	}
	out.EvaluationError = in.EvaluationError
	return nil
}

// Convert_v1_SubjectRulesReviewStatus_To_authorization_SubjectRulesReviewStatus is an autogenerated conversion function.
func Convert_v1_SubjectRulesReviewStatus_To_authorization_SubjectRulesReviewStatus(in *SubjectRulesReviewStatus, out *authorization.SubjectRulesReviewStatus, s conversion.Scope) error {
	return autoConvert_v1_SubjectRulesReviewStatus_To_authorization_SubjectRulesReviewStatus(in, out, s)
}

func autoConvert_authorization_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(in *authorization.SubjectRulesReviewStatus, out *SubjectRulesReviewStatus, s conversion.Scope) error {
	if in.Rules != nil {
		in, out := &in.Rules, &out.Rules
		*out = make([]PolicyRule, len(*in))
		for i := range *in {
			if err := Convert_authorization_PolicyRule_To_v1_PolicyRule(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Rules = make([]PolicyRule, 0)
	}
	out.EvaluationError = in.EvaluationError
	return nil
}

// Convert_authorization_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus is an autogenerated conversion function.
func Convert_authorization_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(in *authorization.SubjectRulesReviewStatus, out *SubjectRulesReviewStatus, s conversion.Scope) error {
	return autoConvert_authorization_SubjectRulesReviewStatus_To_v1_SubjectRulesReviewStatus(in, out, s)
}

func autoConvert_v1_UserRestriction_To_authorization_UserRestriction(in *UserRestriction, out *authorization.UserRestriction, s conversion.Scope) error {
	out.Users = *(*[]string)(unsafe.Pointer(&in.Users))
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	out.Selectors = *(*[]meta_v1.LabelSelector)(unsafe.Pointer(&in.Selectors))
	return nil
}

// Convert_v1_UserRestriction_To_authorization_UserRestriction is an autogenerated conversion function.
func Convert_v1_UserRestriction_To_authorization_UserRestriction(in *UserRestriction, out *authorization.UserRestriction, s conversion.Scope) error {
	return autoConvert_v1_UserRestriction_To_authorization_UserRestriction(in, out, s)
}

func autoConvert_authorization_UserRestriction_To_v1_UserRestriction(in *authorization.UserRestriction, out *UserRestriction, s conversion.Scope) error {
	if in.Users == nil {
		out.Users = make([]string, 0)
	} else {
		out.Users = *(*[]string)(unsafe.Pointer(&in.Users))
	}
	if in.Groups == nil {
		out.Groups = make([]string, 0)
	} else {
		out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	}
	if in.Selectors == nil {
		out.Selectors = make([]meta_v1.LabelSelector, 0)
	} else {
		out.Selectors = *(*[]meta_v1.LabelSelector)(unsafe.Pointer(&in.Selectors))
	}
	return nil
}

// Convert_authorization_UserRestriction_To_v1_UserRestriction is an autogenerated conversion function.
func Convert_authorization_UserRestriction_To_v1_UserRestriction(in *authorization.UserRestriction, out *UserRestriction, s conversion.Scope) error {
	return autoConvert_authorization_UserRestriction_To_v1_UserRestriction(in, out, s)
}
