// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	build "github.com/openshift/origin/pkg/build/apis/build"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	api "k8s.io/kubernetes/pkg/api"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	time "time"
	unsafe "unsafe"
)

func init() {
	SchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions,
		Convert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions,
		Convert_v1_BinaryBuildSource_To_build_BinaryBuildSource,
		Convert_build_BinaryBuildSource_To_v1_BinaryBuildSource,
		Convert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause,
		Convert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause,
		Convert_v1_Build_To_build_Build,
		Convert_build_Build_To_v1_Build,
		Convert_v1_BuildConfig_To_build_BuildConfig,
		Convert_build_BuildConfig_To_v1_BuildConfig,
		Convert_v1_BuildConfigList_To_build_BuildConfigList,
		Convert_build_BuildConfigList_To_v1_BuildConfigList,
		Convert_v1_BuildConfigSpec_To_build_BuildConfigSpec,
		Convert_build_BuildConfigSpec_To_v1_BuildConfigSpec,
		Convert_v1_BuildConfigStatus_To_build_BuildConfigStatus,
		Convert_build_BuildConfigStatus_To_v1_BuildConfigStatus,
		Convert_v1_BuildList_To_build_BuildList,
		Convert_build_BuildList_To_v1_BuildList,
		Convert_v1_BuildLog_To_build_BuildLog,
		Convert_build_BuildLog_To_v1_BuildLog,
		Convert_v1_BuildLogOptions_To_build_BuildLogOptions,
		Convert_build_BuildLogOptions_To_v1_BuildLogOptions,
		Convert_v1_BuildOutput_To_build_BuildOutput,
		Convert_build_BuildOutput_To_v1_BuildOutput,
		Convert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec,
		Convert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec,
		Convert_v1_BuildRequest_To_build_BuildRequest,
		Convert_build_BuildRequest_To_v1_BuildRequest,
		Convert_v1_BuildSource_To_build_BuildSource,
		Convert_build_BuildSource_To_v1_BuildSource,
		Convert_v1_BuildSpec_To_build_BuildSpec,
		Convert_build_BuildSpec_To_v1_BuildSpec,
		Convert_v1_BuildStatus_To_build_BuildStatus,
		Convert_build_BuildStatus_To_v1_BuildStatus,
		Convert_v1_BuildStatusOutput_To_build_BuildStatusOutput,
		Convert_build_BuildStatusOutput_To_v1_BuildStatusOutput,
		Convert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo,
		Convert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo,
		Convert_v1_BuildStrategy_To_build_BuildStrategy,
		Convert_build_BuildStrategy_To_v1_BuildStrategy,
		Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause,
		Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause,
		Convert_v1_BuildTriggerPolicy_To_build_BuildTriggerPolicy,
		Convert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy,
		Convert_v1_CommonSpec_To_build_CommonSpec,
		Convert_build_CommonSpec_To_v1_CommonSpec,
		Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause,
		Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause,
		Convert_v1_CustomBuildStrategy_To_build_CustomBuildStrategy,
		Convert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy,
		Convert_v1_DockerBuildStrategy_To_build_DockerBuildStrategy,
		Convert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy,
		Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions,
		Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions,
		Convert_v1_GenericWebHookCause_To_build_GenericWebHookCause,
		Convert_build_GenericWebHookCause_To_v1_GenericWebHookCause,
		Convert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent,
		Convert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent,
		Convert_v1_GitBuildSource_To_build_GitBuildSource,
		Convert_build_GitBuildSource_To_v1_GitBuildSource,
		Convert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause,
		Convert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause,
		Convert_v1_GitInfo_To_build_GitInfo,
		Convert_build_GitInfo_To_v1_GitInfo,
		Convert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause,
		Convert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause,
		Convert_v1_GitSourceRevision_To_build_GitSourceRevision,
		Convert_build_GitSourceRevision_To_v1_GitSourceRevision,
		Convert_v1_ImageChangeCause_To_build_ImageChangeCause,
		Convert_build_ImageChangeCause_To_v1_ImageChangeCause,
		Convert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger,
		Convert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger,
		Convert_v1_ImageLabel_To_build_ImageLabel,
		Convert_build_ImageLabel_To_v1_ImageLabel,
		Convert_v1_ImageSource_To_build_ImageSource,
		Convert_build_ImageSource_To_v1_ImageSource,
		Convert_v1_ImageSourcePath_To_build_ImageSourcePath,
		Convert_build_ImageSourcePath_To_v1_ImageSourcePath,
		Convert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy,
		Convert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy,
		Convert_v1_ProxyConfig_To_build_ProxyConfig,
		Convert_build_ProxyConfig_To_v1_ProxyConfig,
		Convert_v1_SecretBuildSource_To_build_SecretBuildSource,
		Convert_build_SecretBuildSource_To_v1_SecretBuildSource,
		Convert_v1_SecretSpec_To_build_SecretSpec,
		Convert_build_SecretSpec_To_v1_SecretSpec,
		Convert_v1_SourceBuildStrategy_To_build_SourceBuildStrategy,
		Convert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy,
		Convert_v1_SourceControlUser_To_build_SourceControlUser,
		Convert_build_SourceControlUser_To_v1_SourceControlUser,
		Convert_v1_SourceRevision_To_build_SourceRevision,
		Convert_build_SourceRevision_To_v1_SourceRevision,
		Convert_v1_StageInfo_To_build_StageInfo,
		Convert_build_StageInfo_To_v1_StageInfo,
		Convert_v1_StepInfo_To_build_StepInfo,
		Convert_build_StepInfo_To_v1_StepInfo,
		Convert_v1_WebHookTrigger_To_build_WebHookTrigger,
		Convert_build_WebHookTrigger_To_v1_WebHookTrigger,
	)
}

func autoConvert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions(in *BinaryBuildRequestOptions, out *build.BinaryBuildRequestOptions, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.AsFile = in.AsFile
	out.Commit = in.Commit
	out.Message = in.Message
	out.AuthorName = in.AuthorName
	out.AuthorEmail = in.AuthorEmail
	out.CommitterName = in.CommitterName
	out.CommitterEmail = in.CommitterEmail
	return nil
}

// Convert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions is an autogenerated conversion function.
func Convert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions(in *BinaryBuildRequestOptions, out *build.BinaryBuildRequestOptions, s conversion.Scope) error {
	return autoConvert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions(in, out, s)
}

func autoConvert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in *build.BinaryBuildRequestOptions, out *BinaryBuildRequestOptions, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.AsFile = in.AsFile
	out.Commit = in.Commit
	out.Message = in.Message
	out.AuthorName = in.AuthorName
	out.AuthorEmail = in.AuthorEmail
	out.CommitterName = in.CommitterName
	out.CommitterEmail = in.CommitterEmail
	return nil
}

// Convert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions is an autogenerated conversion function.
func Convert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in *build.BinaryBuildRequestOptions, out *BinaryBuildRequestOptions, s conversion.Scope) error {
	return autoConvert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in, out, s)
}

func autoConvert_v1_BinaryBuildSource_To_build_BinaryBuildSource(in *BinaryBuildSource, out *build.BinaryBuildSource, s conversion.Scope) error {
	out.AsFile = in.AsFile
	return nil
}

// Convert_v1_BinaryBuildSource_To_build_BinaryBuildSource is an autogenerated conversion function.
func Convert_v1_BinaryBuildSource_To_build_BinaryBuildSource(in *BinaryBuildSource, out *build.BinaryBuildSource, s conversion.Scope) error {
	return autoConvert_v1_BinaryBuildSource_To_build_BinaryBuildSource(in, out, s)
}

func autoConvert_build_BinaryBuildSource_To_v1_BinaryBuildSource(in *build.BinaryBuildSource, out *BinaryBuildSource, s conversion.Scope) error {
	out.AsFile = in.AsFile
	return nil
}

// Convert_build_BinaryBuildSource_To_v1_BinaryBuildSource is an autogenerated conversion function.
func Convert_build_BinaryBuildSource_To_v1_BinaryBuildSource(in *build.BinaryBuildSource, out *BinaryBuildSource, s conversion.Scope) error {
	return autoConvert_build_BinaryBuildSource_To_v1_BinaryBuildSource(in, out, s)
}

func autoConvert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause(in *BitbucketWebHookCause, out *build.BitbucketWebHookCause, s conversion.Scope) error {
	if err := Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause(&in.CommonWebHookCause, &out.CommonWebHookCause, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause is an autogenerated conversion function.
func Convert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause(in *BitbucketWebHookCause, out *build.BitbucketWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause(in, out, s)
}

func autoConvert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause(in *build.BitbucketWebHookCause, out *BitbucketWebHookCause, s conversion.Scope) error {
	if err := Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause(&in.CommonWebHookCause, &out.CommonWebHookCause, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause is an autogenerated conversion function.
func Convert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause(in *build.BitbucketWebHookCause, out *BitbucketWebHookCause, s conversion.Scope) error {
	return autoConvert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause(in, out, s)
}

func autoConvert_v1_Build_To_build_Build(in *Build, out *build.Build, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_BuildSpec_To_build_BuildSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildStatus_To_build_BuildStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Build_To_build_Build is an autogenerated conversion function.
func Convert_v1_Build_To_build_Build(in *Build, out *build.Build, s conversion.Scope) error {
	return autoConvert_v1_Build_To_build_Build(in, out, s)
}

func autoConvert_build_Build_To_v1_Build(in *build.Build, out *Build, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_build_BuildSpec_To_v1_BuildSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_build_BuildStatus_To_v1_BuildStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_Build_To_v1_Build is an autogenerated conversion function.
func Convert_build_Build_To_v1_Build(in *build.Build, out *Build, s conversion.Scope) error {
	return autoConvert_build_Build_To_v1_Build(in, out, s)
}

func autoConvert_v1_BuildConfig_To_build_BuildConfig(in *BuildConfig, out *build.BuildConfig, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_BuildConfigSpec_To_build_BuildConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildConfigStatus_To_build_BuildConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_build_BuildConfig_To_v1_BuildConfig(in *build.BuildConfig, out *BuildConfig, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_build_BuildConfigSpec_To_v1_BuildConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_build_BuildConfigStatus_To_v1_BuildConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_BuildConfig_To_v1_BuildConfig is an autogenerated conversion function.
func Convert_build_BuildConfig_To_v1_BuildConfig(in *build.BuildConfig, out *BuildConfig, s conversion.Scope) error {
	return autoConvert_build_BuildConfig_To_v1_BuildConfig(in, out, s)
}

func autoConvert_v1_BuildConfigList_To_build_BuildConfigList(in *BuildConfigList, out *build.BuildConfigList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]build.BuildConfig, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildConfig_To_build_BuildConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_BuildConfigList_To_build_BuildConfigList is an autogenerated conversion function.
func Convert_v1_BuildConfigList_To_build_BuildConfigList(in *BuildConfigList, out *build.BuildConfigList, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigList_To_build_BuildConfigList(in, out, s)
}

func autoConvert_build_BuildConfigList_To_v1_BuildConfigList(in *build.BuildConfigList, out *BuildConfigList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]BuildConfig, len(*in))
		for i := range *in {
			if err := Convert_build_BuildConfig_To_v1_BuildConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]BuildConfig, 0)
	}
	return nil
}

// Convert_build_BuildConfigList_To_v1_BuildConfigList is an autogenerated conversion function.
func Convert_build_BuildConfigList_To_v1_BuildConfigList(in *build.BuildConfigList, out *BuildConfigList, s conversion.Scope) error {
	return autoConvert_build_BuildConfigList_To_v1_BuildConfigList(in, out, s)
}

func autoConvert_v1_BuildConfigSpec_To_build_BuildConfigSpec(in *BuildConfigSpec, out *build.BuildConfigSpec, s conversion.Scope) error {
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]build.BuildTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerPolicy_To_build_BuildTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = nil
	}
	out.RunPolicy = build.BuildRunPolicy(in.RunPolicy)
	if err := Convert_v1_CommonSpec_To_build_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	out.SuccessfulBuildsHistoryLimit = (*int32)(unsafe.Pointer(in.SuccessfulBuildsHistoryLimit))
	out.FailedBuildsHistoryLimit = (*int32)(unsafe.Pointer(in.FailedBuildsHistoryLimit))
	return nil
}

// Convert_v1_BuildConfigSpec_To_build_BuildConfigSpec is an autogenerated conversion function.
func Convert_v1_BuildConfigSpec_To_build_BuildConfigSpec(in *BuildConfigSpec, out *build.BuildConfigSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigSpec_To_build_BuildConfigSpec(in, out, s)
}

func autoConvert_build_BuildConfigSpec_To_v1_BuildConfigSpec(in *build.BuildConfigSpec, out *BuildConfigSpec, s conversion.Scope) error {
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]BuildTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = make([]BuildTriggerPolicy, 0)
	}
	out.RunPolicy = BuildRunPolicy(in.RunPolicy)
	if err := Convert_build_CommonSpec_To_v1_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	out.SuccessfulBuildsHistoryLimit = (*int32)(unsafe.Pointer(in.SuccessfulBuildsHistoryLimit))
	out.FailedBuildsHistoryLimit = (*int32)(unsafe.Pointer(in.FailedBuildsHistoryLimit))
	return nil
}

// Convert_build_BuildConfigSpec_To_v1_BuildConfigSpec is an autogenerated conversion function.
func Convert_build_BuildConfigSpec_To_v1_BuildConfigSpec(in *build.BuildConfigSpec, out *BuildConfigSpec, s conversion.Scope) error {
	return autoConvert_build_BuildConfigSpec_To_v1_BuildConfigSpec(in, out, s)
}

func autoConvert_v1_BuildConfigStatus_To_build_BuildConfigStatus(in *BuildConfigStatus, out *build.BuildConfigStatus, s conversion.Scope) error {
	out.LastVersion = in.LastVersion
	return nil
}

// Convert_v1_BuildConfigStatus_To_build_BuildConfigStatus is an autogenerated conversion function.
func Convert_v1_BuildConfigStatus_To_build_BuildConfigStatus(in *BuildConfigStatus, out *build.BuildConfigStatus, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigStatus_To_build_BuildConfigStatus(in, out, s)
}

func autoConvert_build_BuildConfigStatus_To_v1_BuildConfigStatus(in *build.BuildConfigStatus, out *BuildConfigStatus, s conversion.Scope) error {
	out.LastVersion = in.LastVersion
	return nil
}

// Convert_build_BuildConfigStatus_To_v1_BuildConfigStatus is an autogenerated conversion function.
func Convert_build_BuildConfigStatus_To_v1_BuildConfigStatus(in *build.BuildConfigStatus, out *BuildConfigStatus, s conversion.Scope) error {
	return autoConvert_build_BuildConfigStatus_To_v1_BuildConfigStatus(in, out, s)
}

func autoConvert_v1_BuildList_To_build_BuildList(in *BuildList, out *build.BuildList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]build.Build, len(*in))
		for i := range *in {
			if err := Convert_v1_Build_To_build_Build(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_BuildList_To_build_BuildList is an autogenerated conversion function.
func Convert_v1_BuildList_To_build_BuildList(in *BuildList, out *build.BuildList, s conversion.Scope) error {
	return autoConvert_v1_BuildList_To_build_BuildList(in, out, s)
}

func autoConvert_build_BuildList_To_v1_BuildList(in *build.BuildList, out *BuildList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Build, len(*in))
		for i := range *in {
			if err := Convert_build_Build_To_v1_Build(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]Build, 0)
	}
	return nil
}

// Convert_build_BuildList_To_v1_BuildList is an autogenerated conversion function.
func Convert_build_BuildList_To_v1_BuildList(in *build.BuildList, out *BuildList, s conversion.Scope) error {
	return autoConvert_build_BuildList_To_v1_BuildList(in, out, s)
}

func autoConvert_v1_BuildLog_To_build_BuildLog(in *BuildLog, out *build.BuildLog, s conversion.Scope) error {
	return nil
}

// Convert_v1_BuildLog_To_build_BuildLog is an autogenerated conversion function.
func Convert_v1_BuildLog_To_build_BuildLog(in *BuildLog, out *build.BuildLog, s conversion.Scope) error {
	return autoConvert_v1_BuildLog_To_build_BuildLog(in, out, s)
}

func autoConvert_build_BuildLog_To_v1_BuildLog(in *build.BuildLog, out *BuildLog, s conversion.Scope) error {
	return nil
}

// Convert_build_BuildLog_To_v1_BuildLog is an autogenerated conversion function.
func Convert_build_BuildLog_To_v1_BuildLog(in *build.BuildLog, out *BuildLog, s conversion.Scope) error {
	return autoConvert_build_BuildLog_To_v1_BuildLog(in, out, s)
}

func autoConvert_v1_BuildLogOptions_To_build_BuildLogOptions(in *BuildLogOptions, out *build.BuildLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*meta_v1.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	out.NoWait = in.NoWait
	out.Version = (*int64)(unsafe.Pointer(in.Version))
	return nil
}

// Convert_v1_BuildLogOptions_To_build_BuildLogOptions is an autogenerated conversion function.
func Convert_v1_BuildLogOptions_To_build_BuildLogOptions(in *BuildLogOptions, out *build.BuildLogOptions, s conversion.Scope) error {
	return autoConvert_v1_BuildLogOptions_To_build_BuildLogOptions(in, out, s)
}

func autoConvert_build_BuildLogOptions_To_v1_BuildLogOptions(in *build.BuildLogOptions, out *BuildLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*meta_v1.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	out.NoWait = in.NoWait
	out.Version = (*int64)(unsafe.Pointer(in.Version))
	return nil
}

// Convert_build_BuildLogOptions_To_v1_BuildLogOptions is an autogenerated conversion function.
func Convert_build_BuildLogOptions_To_v1_BuildLogOptions(in *build.BuildLogOptions, out *BuildLogOptions, s conversion.Scope) error {
	return autoConvert_build_BuildLogOptions_To_v1_BuildLogOptions(in, out, s)
}

func autoConvert_v1_BuildOutput_To_build_BuildOutput(in *BuildOutput, out *build.BuildOutput, s conversion.Scope) error {
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if in.PushSecret != nil {
		in, out := &in.PushSecret, &out.PushSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PushSecret = nil
	}
	out.ImageLabels = *(*[]build.ImageLabel)(unsafe.Pointer(&in.ImageLabels))
	return nil
}

func autoConvert_build_BuildOutput_To_v1_BuildOutput(in *build.BuildOutput, out *BuildOutput, s conversion.Scope) error {
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if in.PushSecret != nil {
		in, out := &in.PushSecret, &out.PushSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PushSecret = nil
	}
	out.ImageLabels = *(*[]ImageLabel)(unsafe.Pointer(&in.ImageLabels))
	return nil
}

// Convert_build_BuildOutput_To_v1_BuildOutput is an autogenerated conversion function.
func Convert_build_BuildOutput_To_v1_BuildOutput(in *build.BuildOutput, out *BuildOutput, s conversion.Scope) error {
	return autoConvert_build_BuildOutput_To_v1_BuildOutput(in, out, s)
}

func autoConvert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec(in *BuildPostCommitSpec, out *build.BuildPostCommitSpec, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.Script = in.Script
	return nil
}

// Convert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec is an autogenerated conversion function.
func Convert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec(in *BuildPostCommitSpec, out *build.BuildPostCommitSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec(in, out, s)
}

func autoConvert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in *build.BuildPostCommitSpec, out *BuildPostCommitSpec, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.Script = in.Script
	return nil
}

// Convert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec is an autogenerated conversion function.
func Convert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in *build.BuildPostCommitSpec, out *BuildPostCommitSpec, s conversion.Scope) error {
	return autoConvert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in, out, s)
}

func autoConvert_v1_BuildRequest_To_build_BuildRequest(in *BuildRequest, out *build.BuildRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if in.TriggeredByImage != nil {
		in, out := &in.TriggeredByImage, &out.TriggeredByImage
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TriggeredByImage = nil
	}
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Binary = (*build.BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.LastVersion = (*int64)(unsafe.Pointer(in.LastVersion))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]build.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	if in.DockerStrategyOptions != nil {
		in, out := &in.DockerStrategyOptions, &out.DockerStrategyOptions
		*out = new(build.DockerStrategyOptions)
		if err := Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategyOptions = nil
	}
	return nil
}

// Convert_v1_BuildRequest_To_build_BuildRequest is an autogenerated conversion function.
func Convert_v1_BuildRequest_To_build_BuildRequest(in *BuildRequest, out *build.BuildRequest, s conversion.Scope) error {
	return autoConvert_v1_BuildRequest_To_build_BuildRequest(in, out, s)
}

func autoConvert_build_BuildRequest_To_v1_BuildRequest(in *build.BuildRequest, out *BuildRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if in.TriggeredByImage != nil {
		in, out := &in.TriggeredByImage, &out.TriggeredByImage
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TriggeredByImage = nil
	}
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Binary = (*BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.LastVersion = (*int64)(unsafe.Pointer(in.LastVersion))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = make([]BuildTriggerCause, 0)
	}
	if in.DockerStrategyOptions != nil {
		in, out := &in.DockerStrategyOptions, &out.DockerStrategyOptions
		*out = new(DockerStrategyOptions)
		if err := Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategyOptions = nil
	}
	return nil
}

// Convert_build_BuildRequest_To_v1_BuildRequest is an autogenerated conversion function.
func Convert_build_BuildRequest_To_v1_BuildRequest(in *build.BuildRequest, out *BuildRequest, s conversion.Scope) error {
	return autoConvert_build_BuildRequest_To_v1_BuildRequest(in, out, s)
}

func autoConvert_v1_BuildSource_To_build_BuildSource(in *BuildSource, out *build.BuildSource, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	out.Binary = (*build.BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.Dockerfile = (*string)(unsafe.Pointer(in.Dockerfile))
	out.Git = (*build.GitBuildSource)(unsafe.Pointer(in.Git))
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]build.ImageSource, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageSource_To_build_ImageSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.ContextDir = in.ContextDir
	if in.SourceSecret != nil {
		in, out := &in.SourceSecret, &out.SourceSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceSecret = nil
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]build.SecretBuildSource, len(*in))
		for i := range *in {
			if err := Convert_v1_SecretBuildSource_To_build_SecretBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	return nil
}

// Convert_v1_BuildSource_To_build_BuildSource is an autogenerated conversion function.
func Convert_v1_BuildSource_To_build_BuildSource(in *BuildSource, out *build.BuildSource, s conversion.Scope) error {
	return autoConvert_v1_BuildSource_To_build_BuildSource(in, out, s)
}

func autoConvert_build_BuildSource_To_v1_BuildSource(in *build.BuildSource, out *BuildSource, s conversion.Scope) error {
	out.Binary = (*BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.Dockerfile = (*string)(unsafe.Pointer(in.Dockerfile))
	out.Git = (*GitBuildSource)(unsafe.Pointer(in.Git))
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]ImageSource, len(*in))
		for i := range *in {
			if err := Convert_build_ImageSource_To_v1_ImageSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.ContextDir = in.ContextDir
	if in.SourceSecret != nil {
		in, out := &in.SourceSecret, &out.SourceSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceSecret = nil
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]SecretBuildSource, len(*in))
		for i := range *in {
			if err := Convert_build_SecretBuildSource_To_v1_SecretBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	return nil
}

func autoConvert_v1_BuildSpec_To_build_BuildSpec(in *BuildSpec, out *build.BuildSpec, s conversion.Scope) error {
	if err := Convert_v1_CommonSpec_To_build_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]build.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

// Convert_v1_BuildSpec_To_build_BuildSpec is an autogenerated conversion function.
func Convert_v1_BuildSpec_To_build_BuildSpec(in *BuildSpec, out *build.BuildSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildSpec_To_build_BuildSpec(in, out, s)
}

func autoConvert_build_BuildSpec_To_v1_BuildSpec(in *build.BuildSpec, out *BuildSpec, s conversion.Scope) error {
	if err := Convert_build_CommonSpec_To_v1_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = make([]BuildTriggerCause, 0)
	}
	return nil
}

// Convert_build_BuildSpec_To_v1_BuildSpec is an autogenerated conversion function.
func Convert_build_BuildSpec_To_v1_BuildSpec(in *build.BuildSpec, out *BuildSpec, s conversion.Scope) error {
	return autoConvert_build_BuildSpec_To_v1_BuildSpec(in, out, s)
}

func autoConvert_v1_BuildStatus_To_build_BuildStatus(in *BuildStatus, out *build.BuildStatus, s conversion.Scope) error {
	out.Phase = build.BuildPhase(in.Phase)
	out.Cancelled = in.Cancelled
	out.Reason = build.StatusReason(in.Reason)
	out.Message = in.Message
	out.StartTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.StartTimestamp))
	out.CompletionTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.CompletionTimestamp))
	out.Duration = time.Duration(in.Duration)
	out.OutputDockerImageReference = in.OutputDockerImageReference
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	if err := Convert_v1_BuildStatusOutput_To_build_BuildStatusOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	out.Stages = *(*[]build.StageInfo)(unsafe.Pointer(&in.Stages))
	out.LogSnippet = in.LogSnippet
	return nil
}

// Convert_v1_BuildStatus_To_build_BuildStatus is an autogenerated conversion function.
func Convert_v1_BuildStatus_To_build_BuildStatus(in *BuildStatus, out *build.BuildStatus, s conversion.Scope) error {
	return autoConvert_v1_BuildStatus_To_build_BuildStatus(in, out, s)
}

func autoConvert_build_BuildStatus_To_v1_BuildStatus(in *build.BuildStatus, out *BuildStatus, s conversion.Scope) error {
	out.Phase = BuildPhase(in.Phase)
	out.Cancelled = in.Cancelled
	out.Reason = StatusReason(in.Reason)
	out.Message = in.Message
	out.StartTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.StartTimestamp))
	out.CompletionTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.CompletionTimestamp))
	out.Duration = time.Duration(in.Duration)
	out.OutputDockerImageReference = in.OutputDockerImageReference
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	if err := Convert_build_BuildStatusOutput_To_v1_BuildStatusOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	out.Stages = *(*[]StageInfo)(unsafe.Pointer(&in.Stages))
	out.LogSnippet = in.LogSnippet
	return nil
}

// Convert_build_BuildStatus_To_v1_BuildStatus is an autogenerated conversion function.
func Convert_build_BuildStatus_To_v1_BuildStatus(in *build.BuildStatus, out *BuildStatus, s conversion.Scope) error {
	return autoConvert_build_BuildStatus_To_v1_BuildStatus(in, out, s)
}

func autoConvert_v1_BuildStatusOutput_To_build_BuildStatusOutput(in *BuildStatusOutput, out *build.BuildStatusOutput, s conversion.Scope) error {
	out.To = (*build.BuildStatusOutputTo)(unsafe.Pointer(in.To))
	return nil
}

// Convert_v1_BuildStatusOutput_To_build_BuildStatusOutput is an autogenerated conversion function.
func Convert_v1_BuildStatusOutput_To_build_BuildStatusOutput(in *BuildStatusOutput, out *build.BuildStatusOutput, s conversion.Scope) error {
	return autoConvert_v1_BuildStatusOutput_To_build_BuildStatusOutput(in, out, s)
}

func autoConvert_build_BuildStatusOutput_To_v1_BuildStatusOutput(in *build.BuildStatusOutput, out *BuildStatusOutput, s conversion.Scope) error {
	out.To = (*BuildStatusOutputTo)(unsafe.Pointer(in.To))
	return nil
}

// Convert_build_BuildStatusOutput_To_v1_BuildStatusOutput is an autogenerated conversion function.
func Convert_build_BuildStatusOutput_To_v1_BuildStatusOutput(in *build.BuildStatusOutput, out *BuildStatusOutput, s conversion.Scope) error {
	return autoConvert_build_BuildStatusOutput_To_v1_BuildStatusOutput(in, out, s)
}

func autoConvert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo(in *BuildStatusOutputTo, out *build.BuildStatusOutputTo, s conversion.Scope) error {
	out.ImageDigest = in.ImageDigest
	return nil
}

// Convert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo is an autogenerated conversion function.
func Convert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo(in *BuildStatusOutputTo, out *build.BuildStatusOutputTo, s conversion.Scope) error {
	return autoConvert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo(in, out, s)
}

func autoConvert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in *build.BuildStatusOutputTo, out *BuildStatusOutputTo, s conversion.Scope) error {
	out.ImageDigest = in.ImageDigest
	return nil
}

// Convert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo is an autogenerated conversion function.
func Convert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in *build.BuildStatusOutputTo, out *BuildStatusOutputTo, s conversion.Scope) error {
	return autoConvert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in, out, s)
}

func autoConvert_v1_BuildStrategy_To_build_BuildStrategy(in *BuildStrategy, out *build.BuildStrategy, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	if in.DockerStrategy != nil {
		in, out := &in.DockerStrategy, &out.DockerStrategy
		*out = new(build.DockerBuildStrategy)
		if err := Convert_v1_DockerBuildStrategy_To_build_DockerBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategy = nil
	}
	if in.SourceStrategy != nil {
		in, out := &in.SourceStrategy, &out.SourceStrategy
		*out = new(build.SourceBuildStrategy)
		if err := Convert_v1_SourceBuildStrategy_To_build_SourceBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceStrategy = nil
	}
	if in.CustomStrategy != nil {
		in, out := &in.CustomStrategy, &out.CustomStrategy
		*out = new(build.CustomBuildStrategy)
		if err := Convert_v1_CustomBuildStrategy_To_build_CustomBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomStrategy = nil
	}
	if in.JenkinsPipelineStrategy != nil {
		in, out := &in.JenkinsPipelineStrategy, &out.JenkinsPipelineStrategy
		*out = new(build.JenkinsPipelineBuildStrategy)
		if err := Convert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JenkinsPipelineStrategy = nil
	}
	return nil
}

// Convert_v1_BuildStrategy_To_build_BuildStrategy is an autogenerated conversion function.
func Convert_v1_BuildStrategy_To_build_BuildStrategy(in *BuildStrategy, out *build.BuildStrategy, s conversion.Scope) error {
	return autoConvert_v1_BuildStrategy_To_build_BuildStrategy(in, out, s)
}

func autoConvert_build_BuildStrategy_To_v1_BuildStrategy(in *build.BuildStrategy, out *BuildStrategy, s conversion.Scope) error {
	if in.DockerStrategy != nil {
		in, out := &in.DockerStrategy, &out.DockerStrategy
		*out = new(DockerBuildStrategy)
		if err := Convert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategy = nil
	}
	if in.SourceStrategy != nil {
		in, out := &in.SourceStrategy, &out.SourceStrategy
		*out = new(SourceBuildStrategy)
		if err := Convert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceStrategy = nil
	}
	if in.CustomStrategy != nil {
		in, out := &in.CustomStrategy, &out.CustomStrategy
		*out = new(CustomBuildStrategy)
		if err := Convert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomStrategy = nil
	}
	if in.JenkinsPipelineStrategy != nil {
		in, out := &in.JenkinsPipelineStrategy, &out.JenkinsPipelineStrategy
		*out = new(JenkinsPipelineBuildStrategy)
		if err := Convert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JenkinsPipelineStrategy = nil
	}
	return nil
}

func autoConvert_v1_BuildTriggerCause_To_build_BuildTriggerCause(in *BuildTriggerCause, out *build.BuildTriggerCause, s conversion.Scope) error {
	out.Message = in.Message
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(build.GenericWebHookCause)
		if err := Convert_v1_GenericWebHookCause_To_build_GenericWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(build.GitHubWebHookCause)
		if err := Convert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.ImageChangeBuild != nil {
		in, out := &in.ImageChangeBuild, &out.ImageChangeBuild
		*out = new(build.ImageChangeCause)
		if err := Convert_v1_ImageChangeCause_To_build_ImageChangeCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeBuild = nil
	}
	if in.GitLabWebHook != nil {
		in, out := &in.GitLabWebHook, &out.GitLabWebHook
		*out = new(build.GitLabWebHookCause)
		if err := Convert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitLabWebHook = nil
	}
	if in.BitbucketWebHook != nil {
		in, out := &in.BitbucketWebHook, &out.BitbucketWebHook
		*out = new(build.BitbucketWebHookCause)
		if err := Convert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.BitbucketWebHook = nil
	}
	return nil
}

// Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause is an autogenerated conversion function.
func Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause(in *BuildTriggerCause, out *build.BuildTriggerCause, s conversion.Scope) error {
	return autoConvert_v1_BuildTriggerCause_To_build_BuildTriggerCause(in, out, s)
}

func autoConvert_build_BuildTriggerCause_To_v1_BuildTriggerCause(in *build.BuildTriggerCause, out *BuildTriggerCause, s conversion.Scope) error {
	out.Message = in.Message
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(GenericWebHookCause)
		if err := Convert_build_GenericWebHookCause_To_v1_GenericWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(GitHubWebHookCause)
		if err := Convert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.ImageChangeBuild != nil {
		in, out := &in.ImageChangeBuild, &out.ImageChangeBuild
		*out = new(ImageChangeCause)
		if err := Convert_build_ImageChangeCause_To_v1_ImageChangeCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeBuild = nil
	}
	if in.GitLabWebHook != nil {
		in, out := &in.GitLabWebHook, &out.GitLabWebHook
		*out = new(GitLabWebHookCause)
		if err := Convert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitLabWebHook = nil
	}
	if in.BitbucketWebHook != nil {
		in, out := &in.BitbucketWebHook, &out.BitbucketWebHook
		*out = new(BitbucketWebHookCause)
		if err := Convert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.BitbucketWebHook = nil
	}
	return nil
}

// Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause is an autogenerated conversion function.
func Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause(in *build.BuildTriggerCause, out *BuildTriggerCause, s conversion.Scope) error {
	return autoConvert_build_BuildTriggerCause_To_v1_BuildTriggerCause(in, out, s)
}

func autoConvert_v1_BuildTriggerPolicy_To_build_BuildTriggerPolicy(in *BuildTriggerPolicy, out *build.BuildTriggerPolicy, s conversion.Scope) error {
	out.Type = build.BuildTriggerType(in.Type)
	out.GitHubWebHook = (*build.WebHookTrigger)(unsafe.Pointer(in.GitHubWebHook))
	out.GenericWebHook = (*build.WebHookTrigger)(unsafe.Pointer(in.GenericWebHook))
	if in.ImageChange != nil {
		in, out := &in.ImageChange, &out.ImageChange
		*out = new(build.ImageChangeTrigger)
		if err := Convert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChange = nil
	}
	out.GitLabWebHook = (*build.WebHookTrigger)(unsafe.Pointer(in.GitLabWebHook))
	out.BitbucketWebHook = (*build.WebHookTrigger)(unsafe.Pointer(in.BitbucketWebHook))
	return nil
}

func autoConvert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in *build.BuildTriggerPolicy, out *BuildTriggerPolicy, s conversion.Scope) error {
	out.Type = BuildTriggerType(in.Type)
	out.GitHubWebHook = (*WebHookTrigger)(unsafe.Pointer(in.GitHubWebHook))
	out.GenericWebHook = (*WebHookTrigger)(unsafe.Pointer(in.GenericWebHook))
	if in.ImageChange != nil {
		in, out := &in.ImageChange, &out.ImageChange
		*out = new(ImageChangeTrigger)
		if err := Convert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChange = nil
	}
	out.GitLabWebHook = (*WebHookTrigger)(unsafe.Pointer(in.GitLabWebHook))
	out.BitbucketWebHook = (*WebHookTrigger)(unsafe.Pointer(in.BitbucketWebHook))
	return nil
}

// Convert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy is an autogenerated conversion function.
func Convert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in *build.BuildTriggerPolicy, out *BuildTriggerPolicy, s conversion.Scope) error {
	return autoConvert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in, out, s)
}

func autoConvert_v1_CommonSpec_To_build_CommonSpec(in *CommonSpec, out *build.CommonSpec, s conversion.Scope) error {
	out.ServiceAccount = in.ServiceAccount
	if err := Convert_v1_BuildSource_To_build_BuildSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if err := Convert_v1_BuildStrategy_To_build_BuildStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildOutput_To_build_BuildOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	if err := api_v1.Convert_v1_ResourceRequirements_To_api_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec(&in.PostCommit, &out.PostCommit, s); err != nil {
		return err
	}
	out.CompletionDeadlineSeconds = (*int64)(unsafe.Pointer(in.CompletionDeadlineSeconds))
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	return nil
}

// Convert_v1_CommonSpec_To_build_CommonSpec is an autogenerated conversion function.
func Convert_v1_CommonSpec_To_build_CommonSpec(in *CommonSpec, out *build.CommonSpec, s conversion.Scope) error {
	return autoConvert_v1_CommonSpec_To_build_CommonSpec(in, out, s)
}

func autoConvert_build_CommonSpec_To_v1_CommonSpec(in *build.CommonSpec, out *CommonSpec, s conversion.Scope) error {
	out.ServiceAccount = in.ServiceAccount
	if err := Convert_build_BuildSource_To_v1_BuildSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if err := Convert_build_BuildStrategy_To_v1_BuildStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	if err := Convert_build_BuildOutput_To_v1_BuildOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	if err := api_v1.Convert_api_ResourceRequirements_To_v1_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	if err := Convert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(&in.PostCommit, &out.PostCommit, s); err != nil {
		return err
	}
	out.CompletionDeadlineSeconds = (*int64)(unsafe.Pointer(in.CompletionDeadlineSeconds))
	out.NodeSelector = *(*OptionalNodeSelector)(unsafe.Pointer(&in.NodeSelector))
	return nil
}

// Convert_build_CommonSpec_To_v1_CommonSpec is an autogenerated conversion function.
func Convert_build_CommonSpec_To_v1_CommonSpec(in *build.CommonSpec, out *CommonSpec, s conversion.Scope) error {
	return autoConvert_build_CommonSpec_To_v1_CommonSpec(in, out, s)
}

func autoConvert_v1_CommonWebHookCause_To_build_CommonWebHookCause(in *CommonWebHookCause, out *build.CommonWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause is an autogenerated conversion function.
func Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause(in *CommonWebHookCause, out *build.CommonWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_CommonWebHookCause_To_build_CommonWebHookCause(in, out, s)
}

func autoConvert_build_CommonWebHookCause_To_v1_CommonWebHookCause(in *build.CommonWebHookCause, out *CommonWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause is an autogenerated conversion function.
func Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause(in *build.CommonWebHookCause, out *CommonWebHookCause, s conversion.Scope) error {
	return autoConvert_build_CommonWebHookCause_To_v1_CommonWebHookCause(in, out, s)
}

func autoConvert_v1_CustomBuildStrategy_To_build_CustomBuildStrategy(in *CustomBuildStrategy, out *build.CustomBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ExposeDockerSocket = in.ExposeDockerSocket
	out.ForcePull = in.ForcePull
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]build.SecretSpec, len(*in))
		for i := range *in {
			if err := Convert_v1_SecretSpec_To_build_SecretSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	out.BuildAPIVersion = in.BuildAPIVersion
	return nil
}

func autoConvert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy(in *build.CustomBuildStrategy, out *CustomBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ExposeDockerSocket = in.ExposeDockerSocket
	out.ForcePull = in.ForcePull
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]SecretSpec, len(*in))
		for i := range *in {
			if err := Convert_build_SecretSpec_To_v1_SecretSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	out.BuildAPIVersion = in.BuildAPIVersion
	return nil
}

// Convert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy is an autogenerated conversion function.
func Convert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy(in *build.CustomBuildStrategy, out *CustomBuildStrategy, s conversion.Scope) error {
	return autoConvert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy(in, out, s)
}

func autoConvert_v1_DockerBuildStrategy_To_build_DockerBuildStrategy(in *DockerBuildStrategy, out *build.DockerBuildStrategy, s conversion.Scope) error {
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	out.NoCache = in.NoCache
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ForcePull = in.ForcePull
	out.DockerfilePath = in.DockerfilePath
	if in.BuildArgs != nil {
		in, out := &in.BuildArgs, &out.BuildArgs
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.BuildArgs = nil
	}
	out.ImageOptimizationPolicy = (*build.ImageOptimizationPolicy)(unsafe.Pointer(in.ImageOptimizationPolicy))
	return nil
}

func autoConvert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy(in *build.DockerBuildStrategy, out *DockerBuildStrategy, s conversion.Scope) error {
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	out.NoCache = in.NoCache
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.BuildArgs != nil {
		in, out := &in.BuildArgs, &out.BuildArgs
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.BuildArgs = nil
	}
	out.ForcePull = in.ForcePull
	out.DockerfilePath = in.DockerfilePath
	out.ImageOptimizationPolicy = (*ImageOptimizationPolicy)(unsafe.Pointer(in.ImageOptimizationPolicy))
	return nil
}

// Convert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy is an autogenerated conversion function.
func Convert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy(in *build.DockerBuildStrategy, out *DockerBuildStrategy, s conversion.Scope) error {
	return autoConvert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy(in, out, s)
}

func autoConvert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(in *DockerStrategyOptions, out *build.DockerStrategyOptions, s conversion.Scope) error {
	if in.BuildArgs != nil {
		in, out := &in.BuildArgs, &out.BuildArgs
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.BuildArgs = nil
	}
	return nil
}

// Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions is an autogenerated conversion function.
func Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(in *DockerStrategyOptions, out *build.DockerStrategyOptions, s conversion.Scope) error {
	return autoConvert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(in, out, s)
}

func autoConvert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(in *build.DockerStrategyOptions, out *DockerStrategyOptions, s conversion.Scope) error {
	if in.BuildArgs != nil {
		in, out := &in.BuildArgs, &out.BuildArgs
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.BuildArgs = nil
	}
	return nil
}

// Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions is an autogenerated conversion function.
func Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(in *build.DockerStrategyOptions, out *DockerStrategyOptions, s conversion.Scope) error {
	return autoConvert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(in, out, s)
}

func autoConvert_v1_GenericWebHookCause_To_build_GenericWebHookCause(in *GenericWebHookCause, out *build.GenericWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_v1_GenericWebHookCause_To_build_GenericWebHookCause is an autogenerated conversion function.
func Convert_v1_GenericWebHookCause_To_build_GenericWebHookCause(in *GenericWebHookCause, out *build.GenericWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GenericWebHookCause_To_build_GenericWebHookCause(in, out, s)
}

func autoConvert_build_GenericWebHookCause_To_v1_GenericWebHookCause(in *build.GenericWebHookCause, out *GenericWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_build_GenericWebHookCause_To_v1_GenericWebHookCause is an autogenerated conversion function.
func Convert_build_GenericWebHookCause_To_v1_GenericWebHookCause(in *build.GenericWebHookCause, out *GenericWebHookCause, s conversion.Scope) error {
	return autoConvert_build_GenericWebHookCause_To_v1_GenericWebHookCause(in, out, s)
}

func autoConvert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent(in *GenericWebHookEvent, out *build.GenericWebHookEvent, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(build.GitInfo)
		if err := Convert_v1_GitInfo_To_build_GitInfo(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.DockerStrategyOptions != nil {
		in, out := &in.DockerStrategyOptions, &out.DockerStrategyOptions
		*out = new(build.DockerStrategyOptions)
		if err := Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategyOptions = nil
	}
	return nil
}

// Convert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent is an autogenerated conversion function.
func Convert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent(in *GenericWebHookEvent, out *build.GenericWebHookEvent, s conversion.Scope) error {
	return autoConvert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent(in, out, s)
}

func autoConvert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent(in *build.GenericWebHookEvent, out *GenericWebHookEvent, s conversion.Scope) error {
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(GitInfo)
		if err := Convert_build_GitInfo_To_v1_GitInfo(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Git = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.DockerStrategyOptions != nil {
		in, out := &in.DockerStrategyOptions, &out.DockerStrategyOptions
		*out = new(DockerStrategyOptions)
		if err := Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategyOptions = nil
	}
	return nil
}

// Convert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent is an autogenerated conversion function.
func Convert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent(in *build.GenericWebHookEvent, out *GenericWebHookEvent, s conversion.Scope) error {
	return autoConvert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent(in, out, s)
}

func autoConvert_v1_GitBuildSource_To_build_GitBuildSource(in *GitBuildSource, out *build.GitBuildSource, s conversion.Scope) error {
	out.URI = in.URI
	out.Ref = in.Ref
	if err := Convert_v1_ProxyConfig_To_build_ProxyConfig(&in.ProxyConfig, &out.ProxyConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_GitBuildSource_To_build_GitBuildSource is an autogenerated conversion function.
func Convert_v1_GitBuildSource_To_build_GitBuildSource(in *GitBuildSource, out *build.GitBuildSource, s conversion.Scope) error {
	return autoConvert_v1_GitBuildSource_To_build_GitBuildSource(in, out, s)
}

func autoConvert_build_GitBuildSource_To_v1_GitBuildSource(in *build.GitBuildSource, out *GitBuildSource, s conversion.Scope) error {
	out.URI = in.URI
	out.Ref = in.Ref
	if err := Convert_build_ProxyConfig_To_v1_ProxyConfig(&in.ProxyConfig, &out.ProxyConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_GitBuildSource_To_v1_GitBuildSource is an autogenerated conversion function.
func Convert_build_GitBuildSource_To_v1_GitBuildSource(in *build.GitBuildSource, out *GitBuildSource, s conversion.Scope) error {
	return autoConvert_build_GitBuildSource_To_v1_GitBuildSource(in, out, s)
}

func autoConvert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause(in *GitHubWebHookCause, out *build.GitHubWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause is an autogenerated conversion function.
func Convert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause(in *GitHubWebHookCause, out *build.GitHubWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause(in, out, s)
}

func autoConvert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause(in *build.GitHubWebHookCause, out *GitHubWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause is an autogenerated conversion function.
func Convert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause(in *build.GitHubWebHookCause, out *GitHubWebHookCause, s conversion.Scope) error {
	return autoConvert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause(in, out, s)
}

func autoConvert_v1_GitInfo_To_build_GitInfo(in *GitInfo, out *build.GitInfo, s conversion.Scope) error {
	if err := Convert_v1_GitBuildSource_To_build_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_v1_GitSourceRevision_To_build_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_GitInfo_To_build_GitInfo is an autogenerated conversion function.
func Convert_v1_GitInfo_To_build_GitInfo(in *GitInfo, out *build.GitInfo, s conversion.Scope) error {
	return autoConvert_v1_GitInfo_To_build_GitInfo(in, out, s)
}

func autoConvert_build_GitInfo_To_v1_GitInfo(in *build.GitInfo, out *GitInfo, s conversion.Scope) error {
	if err := Convert_build_GitBuildSource_To_v1_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_build_GitSourceRevision_To_v1_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	// INFO: in.Refs opted out of conversion generation
	return nil
}

// Convert_build_GitInfo_To_v1_GitInfo is an autogenerated conversion function.
func Convert_build_GitInfo_To_v1_GitInfo(in *build.GitInfo, out *GitInfo, s conversion.Scope) error {
	return autoConvert_build_GitInfo_To_v1_GitInfo(in, out, s)
}

func autoConvert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause(in *GitLabWebHookCause, out *build.GitLabWebHookCause, s conversion.Scope) error {
	if err := Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause(&in.CommonWebHookCause, &out.CommonWebHookCause, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause is an autogenerated conversion function.
func Convert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause(in *GitLabWebHookCause, out *build.GitLabWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause(in, out, s)
}

func autoConvert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause(in *build.GitLabWebHookCause, out *GitLabWebHookCause, s conversion.Scope) error {
	if err := Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause(&in.CommonWebHookCause, &out.CommonWebHookCause, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause is an autogenerated conversion function.
func Convert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause(in *build.GitLabWebHookCause, out *GitLabWebHookCause, s conversion.Scope) error {
	return autoConvert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause(in, out, s)
}

func autoConvert_v1_GitSourceRevision_To_build_GitSourceRevision(in *GitSourceRevision, out *build.GitSourceRevision, s conversion.Scope) error {
	out.Commit = in.Commit
	if err := Convert_v1_SourceControlUser_To_build_SourceControlUser(&in.Author, &out.Author, s); err != nil {
		return err
	}
	if err := Convert_v1_SourceControlUser_To_build_SourceControlUser(&in.Committer, &out.Committer, s); err != nil {
		return err
	}
	out.Message = in.Message
	return nil
}

// Convert_v1_GitSourceRevision_To_build_GitSourceRevision is an autogenerated conversion function.
func Convert_v1_GitSourceRevision_To_build_GitSourceRevision(in *GitSourceRevision, out *build.GitSourceRevision, s conversion.Scope) error {
	return autoConvert_v1_GitSourceRevision_To_build_GitSourceRevision(in, out, s)
}

func autoConvert_build_GitSourceRevision_To_v1_GitSourceRevision(in *build.GitSourceRevision, out *GitSourceRevision, s conversion.Scope) error {
	out.Commit = in.Commit
	if err := Convert_build_SourceControlUser_To_v1_SourceControlUser(&in.Author, &out.Author, s); err != nil {
		return err
	}
	if err := Convert_build_SourceControlUser_To_v1_SourceControlUser(&in.Committer, &out.Committer, s); err != nil {
		return err
	}
	out.Message = in.Message
	return nil
}

// Convert_build_GitSourceRevision_To_v1_GitSourceRevision is an autogenerated conversion function.
func Convert_build_GitSourceRevision_To_v1_GitSourceRevision(in *build.GitSourceRevision, out *GitSourceRevision, s conversion.Scope) error {
	return autoConvert_build_GitSourceRevision_To_v1_GitSourceRevision(in, out, s)
}

func autoConvert_v1_ImageChangeCause_To_build_ImageChangeCause(in *ImageChangeCause, out *build.ImageChangeCause, s conversion.Scope) error {
	out.ImageID = in.ImageID
	if in.FromRef != nil {
		in, out := &in.FromRef, &out.FromRef
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.FromRef = nil
	}
	return nil
}

// Convert_v1_ImageChangeCause_To_build_ImageChangeCause is an autogenerated conversion function.
func Convert_v1_ImageChangeCause_To_build_ImageChangeCause(in *ImageChangeCause, out *build.ImageChangeCause, s conversion.Scope) error {
	return autoConvert_v1_ImageChangeCause_To_build_ImageChangeCause(in, out, s)
}

func autoConvert_build_ImageChangeCause_To_v1_ImageChangeCause(in *build.ImageChangeCause, out *ImageChangeCause, s conversion.Scope) error {
	out.ImageID = in.ImageID
	if in.FromRef != nil {
		in, out := &in.FromRef, &out.FromRef
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.FromRef = nil
	}
	return nil
}

// Convert_build_ImageChangeCause_To_v1_ImageChangeCause is an autogenerated conversion function.
func Convert_build_ImageChangeCause_To_v1_ImageChangeCause(in *build.ImageChangeCause, out *ImageChangeCause, s conversion.Scope) error {
	return autoConvert_build_ImageChangeCause_To_v1_ImageChangeCause(in, out, s)
}

func autoConvert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger(in *ImageChangeTrigger, out *build.ImageChangeTrigger, s conversion.Scope) error {
	out.LastTriggeredImageID = in.LastTriggeredImageID
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	return nil
}

// Convert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger is an autogenerated conversion function.
func Convert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger(in *ImageChangeTrigger, out *build.ImageChangeTrigger, s conversion.Scope) error {
	return autoConvert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger(in, out, s)
}

func autoConvert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger(in *build.ImageChangeTrigger, out *ImageChangeTrigger, s conversion.Scope) error {
	out.LastTriggeredImageID = in.LastTriggeredImageID
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	return nil
}

// Convert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger is an autogenerated conversion function.
func Convert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger(in *build.ImageChangeTrigger, out *ImageChangeTrigger, s conversion.Scope) error {
	return autoConvert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger(in, out, s)
}

func autoConvert_v1_ImageLabel_To_build_ImageLabel(in *ImageLabel, out *build.ImageLabel, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_v1_ImageLabel_To_build_ImageLabel is an autogenerated conversion function.
func Convert_v1_ImageLabel_To_build_ImageLabel(in *ImageLabel, out *build.ImageLabel, s conversion.Scope) error {
	return autoConvert_v1_ImageLabel_To_build_ImageLabel(in, out, s)
}

func autoConvert_build_ImageLabel_To_v1_ImageLabel(in *build.ImageLabel, out *ImageLabel, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_build_ImageLabel_To_v1_ImageLabel is an autogenerated conversion function.
func Convert_build_ImageLabel_To_v1_ImageLabel(in *build.ImageLabel, out *ImageLabel, s conversion.Scope) error {
	return autoConvert_build_ImageLabel_To_v1_ImageLabel(in, out, s)
}

func autoConvert_v1_ImageSource_To_build_ImageSource(in *ImageSource, out *build.ImageSource, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.Paths = *(*[]build.ImageSourcePath)(unsafe.Pointer(&in.Paths))
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	return nil
}

// Convert_v1_ImageSource_To_build_ImageSource is an autogenerated conversion function.
func Convert_v1_ImageSource_To_build_ImageSource(in *ImageSource, out *build.ImageSource, s conversion.Scope) error {
	return autoConvert_v1_ImageSource_To_build_ImageSource(in, out, s)
}

func autoConvert_build_ImageSource_To_v1_ImageSource(in *build.ImageSource, out *ImageSource, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.Paths == nil {
		out.Paths = make([]ImageSourcePath, 0)
	} else {
		out.Paths = *(*[]ImageSourcePath)(unsafe.Pointer(&in.Paths))
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	return nil
}

// Convert_build_ImageSource_To_v1_ImageSource is an autogenerated conversion function.
func Convert_build_ImageSource_To_v1_ImageSource(in *build.ImageSource, out *ImageSource, s conversion.Scope) error {
	return autoConvert_build_ImageSource_To_v1_ImageSource(in, out, s)
}

func autoConvert_v1_ImageSourcePath_To_build_ImageSourcePath(in *ImageSourcePath, out *build.ImageSourcePath, s conversion.Scope) error {
	out.SourcePath = in.SourcePath
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_v1_ImageSourcePath_To_build_ImageSourcePath is an autogenerated conversion function.
func Convert_v1_ImageSourcePath_To_build_ImageSourcePath(in *ImageSourcePath, out *build.ImageSourcePath, s conversion.Scope) error {
	return autoConvert_v1_ImageSourcePath_To_build_ImageSourcePath(in, out, s)
}

func autoConvert_build_ImageSourcePath_To_v1_ImageSourcePath(in *build.ImageSourcePath, out *ImageSourcePath, s conversion.Scope) error {
	out.SourcePath = in.SourcePath
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_build_ImageSourcePath_To_v1_ImageSourcePath is an autogenerated conversion function.
func Convert_build_ImageSourcePath_To_v1_ImageSourcePath(in *build.ImageSourcePath, out *ImageSourcePath, s conversion.Scope) error {
	return autoConvert_build_ImageSourcePath_To_v1_ImageSourcePath(in, out, s)
}

func autoConvert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy(in *JenkinsPipelineBuildStrategy, out *build.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	out.JenkinsfilePath = in.JenkinsfilePath
	out.Jenkinsfile = in.Jenkinsfile
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	return nil
}

// Convert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy is an autogenerated conversion function.
func Convert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy(in *JenkinsPipelineBuildStrategy, out *build.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	return autoConvert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy(in, out, s)
}

func autoConvert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in *build.JenkinsPipelineBuildStrategy, out *JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	out.JenkinsfilePath = in.JenkinsfilePath
	out.Jenkinsfile = in.Jenkinsfile
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	return nil
}

// Convert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy is an autogenerated conversion function.
func Convert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in *build.JenkinsPipelineBuildStrategy, out *JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	return autoConvert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in, out, s)
}

func autoConvert_v1_ProxyConfig_To_build_ProxyConfig(in *ProxyConfig, out *build.ProxyConfig, s conversion.Scope) error {
	out.HTTPProxy = (*string)(unsafe.Pointer(in.HTTPProxy))
	out.HTTPSProxy = (*string)(unsafe.Pointer(in.HTTPSProxy))
	out.NoProxy = (*string)(unsafe.Pointer(in.NoProxy))
	return nil
}

// Convert_v1_ProxyConfig_To_build_ProxyConfig is an autogenerated conversion function.
func Convert_v1_ProxyConfig_To_build_ProxyConfig(in *ProxyConfig, out *build.ProxyConfig, s conversion.Scope) error {
	return autoConvert_v1_ProxyConfig_To_build_ProxyConfig(in, out, s)
}

func autoConvert_build_ProxyConfig_To_v1_ProxyConfig(in *build.ProxyConfig, out *ProxyConfig, s conversion.Scope) error {
	out.HTTPProxy = (*string)(unsafe.Pointer(in.HTTPProxy))
	out.HTTPSProxy = (*string)(unsafe.Pointer(in.HTTPSProxy))
	out.NoProxy = (*string)(unsafe.Pointer(in.NoProxy))
	return nil
}

// Convert_build_ProxyConfig_To_v1_ProxyConfig is an autogenerated conversion function.
func Convert_build_ProxyConfig_To_v1_ProxyConfig(in *build.ProxyConfig, out *ProxyConfig, s conversion.Scope) error {
	return autoConvert_build_ProxyConfig_To_v1_ProxyConfig(in, out, s)
}

func autoConvert_v1_SecretBuildSource_To_build_SecretBuildSource(in *SecretBuildSource, out *build.SecretBuildSource, s conversion.Scope) error {
	if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.Secret, &out.Secret, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_v1_SecretBuildSource_To_build_SecretBuildSource is an autogenerated conversion function.
func Convert_v1_SecretBuildSource_To_build_SecretBuildSource(in *SecretBuildSource, out *build.SecretBuildSource, s conversion.Scope) error {
	return autoConvert_v1_SecretBuildSource_To_build_SecretBuildSource(in, out, s)
}

func autoConvert_build_SecretBuildSource_To_v1_SecretBuildSource(in *build.SecretBuildSource, out *SecretBuildSource, s conversion.Scope) error {
	if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.Secret, &out.Secret, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_build_SecretBuildSource_To_v1_SecretBuildSource is an autogenerated conversion function.
func Convert_build_SecretBuildSource_To_v1_SecretBuildSource(in *build.SecretBuildSource, out *SecretBuildSource, s conversion.Scope) error {
	return autoConvert_build_SecretBuildSource_To_v1_SecretBuildSource(in, out, s)
}

func autoConvert_v1_SecretSpec_To_build_SecretSpec(in *SecretSpec, out *build.SecretSpec, s conversion.Scope) error {
	if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(&in.SecretSource, &out.SecretSource, s); err != nil {
		return err
	}
	out.MountPath = in.MountPath
	return nil
}

// Convert_v1_SecretSpec_To_build_SecretSpec is an autogenerated conversion function.
func Convert_v1_SecretSpec_To_build_SecretSpec(in *SecretSpec, out *build.SecretSpec, s conversion.Scope) error {
	return autoConvert_v1_SecretSpec_To_build_SecretSpec(in, out, s)
}

func autoConvert_build_SecretSpec_To_v1_SecretSpec(in *build.SecretSpec, out *SecretSpec, s conversion.Scope) error {
	if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(&in.SecretSource, &out.SecretSource, s); err != nil {
		return err
	}
	out.MountPath = in.MountPath
	return nil
}

// Convert_build_SecretSpec_To_v1_SecretSpec is an autogenerated conversion function.
func Convert_build_SecretSpec_To_v1_SecretSpec(in *build.SecretSpec, out *SecretSpec, s conversion.Scope) error {
	return autoConvert_build_SecretSpec_To_v1_SecretSpec(in, out, s)
}

func autoConvert_v1_SourceBuildStrategy_To_build_SourceBuildStrategy(in *SourceBuildStrategy, out *build.SourceBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api.LocalObjectReference)
		if err := api_v1.Convert_v1_LocalObjectReference_To_api_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.Scripts = in.Scripts
	out.Incremental = (*bool)(unsafe.Pointer(in.Incremental))
	out.ForcePull = in.ForcePull
	if in.RuntimeImage != nil {
		in, out := &in.RuntimeImage, &out.RuntimeImage
		*out = new(api.ObjectReference)
		if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RuntimeImage = nil
	}
	out.RuntimeArtifacts = *(*[]build.ImageSourcePath)(unsafe.Pointer(&in.RuntimeArtifacts))
	return nil
}

func autoConvert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy(in *build.SourceBuildStrategy, out *SourceBuildStrategy, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_v1.LocalObjectReference)
		if err := api_v1.Convert_api_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.Scripts = in.Scripts
	out.Incremental = (*bool)(unsafe.Pointer(in.Incremental))
	out.ForcePull = in.ForcePull
	if in.RuntimeImage != nil {
		in, out := &in.RuntimeImage, &out.RuntimeImage
		*out = new(api_v1.ObjectReference)
		if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RuntimeImage = nil
	}
	out.RuntimeArtifacts = *(*[]ImageSourcePath)(unsafe.Pointer(&in.RuntimeArtifacts))
	return nil
}

// Convert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy is an autogenerated conversion function.
func Convert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy(in *build.SourceBuildStrategy, out *SourceBuildStrategy, s conversion.Scope) error {
	return autoConvert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy(in, out, s)
}

func autoConvert_v1_SourceControlUser_To_build_SourceControlUser(in *SourceControlUser, out *build.SourceControlUser, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

// Convert_v1_SourceControlUser_To_build_SourceControlUser is an autogenerated conversion function.
func Convert_v1_SourceControlUser_To_build_SourceControlUser(in *SourceControlUser, out *build.SourceControlUser, s conversion.Scope) error {
	return autoConvert_v1_SourceControlUser_To_build_SourceControlUser(in, out, s)
}

func autoConvert_build_SourceControlUser_To_v1_SourceControlUser(in *build.SourceControlUser, out *SourceControlUser, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

// Convert_build_SourceControlUser_To_v1_SourceControlUser is an autogenerated conversion function.
func Convert_build_SourceControlUser_To_v1_SourceControlUser(in *build.SourceControlUser, out *SourceControlUser, s conversion.Scope) error {
	return autoConvert_build_SourceControlUser_To_v1_SourceControlUser(in, out, s)
}

func autoConvert_v1_SourceRevision_To_build_SourceRevision(in *SourceRevision, out *build.SourceRevision, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	out.Git = (*build.GitSourceRevision)(unsafe.Pointer(in.Git))
	return nil
}

// Convert_v1_SourceRevision_To_build_SourceRevision is an autogenerated conversion function.
func Convert_v1_SourceRevision_To_build_SourceRevision(in *SourceRevision, out *build.SourceRevision, s conversion.Scope) error {
	return autoConvert_v1_SourceRevision_To_build_SourceRevision(in, out, s)
}

func autoConvert_build_SourceRevision_To_v1_SourceRevision(in *build.SourceRevision, out *SourceRevision, s conversion.Scope) error {
	out.Git = (*GitSourceRevision)(unsafe.Pointer(in.Git))
	return nil
}

func autoConvert_v1_StageInfo_To_build_StageInfo(in *StageInfo, out *build.StageInfo, s conversion.Scope) error {
	out.Name = build.StageName(in.Name)
	out.StartTime = in.StartTime
	out.DurationMilliseconds = in.DurationMilliseconds
	out.Steps = *(*[]build.StepInfo)(unsafe.Pointer(&in.Steps))
	return nil
}

// Convert_v1_StageInfo_To_build_StageInfo is an autogenerated conversion function.
func Convert_v1_StageInfo_To_build_StageInfo(in *StageInfo, out *build.StageInfo, s conversion.Scope) error {
	return autoConvert_v1_StageInfo_To_build_StageInfo(in, out, s)
}

func autoConvert_build_StageInfo_To_v1_StageInfo(in *build.StageInfo, out *StageInfo, s conversion.Scope) error {
	out.Name = StageName(in.Name)
	out.StartTime = in.StartTime
	out.DurationMilliseconds = in.DurationMilliseconds
	out.Steps = *(*[]StepInfo)(unsafe.Pointer(&in.Steps))
	return nil
}

// Convert_build_StageInfo_To_v1_StageInfo is an autogenerated conversion function.
func Convert_build_StageInfo_To_v1_StageInfo(in *build.StageInfo, out *StageInfo, s conversion.Scope) error {
	return autoConvert_build_StageInfo_To_v1_StageInfo(in, out, s)
}

func autoConvert_v1_StepInfo_To_build_StepInfo(in *StepInfo, out *build.StepInfo, s conversion.Scope) error {
	out.Name = build.StepName(in.Name)
	out.StartTime = in.StartTime
	out.DurationMilliseconds = in.DurationMilliseconds
	return nil
}

// Convert_v1_StepInfo_To_build_StepInfo is an autogenerated conversion function.
func Convert_v1_StepInfo_To_build_StepInfo(in *StepInfo, out *build.StepInfo, s conversion.Scope) error {
	return autoConvert_v1_StepInfo_To_build_StepInfo(in, out, s)
}

func autoConvert_build_StepInfo_To_v1_StepInfo(in *build.StepInfo, out *StepInfo, s conversion.Scope) error {
	out.Name = StepName(in.Name)
	out.StartTime = in.StartTime
	out.DurationMilliseconds = in.DurationMilliseconds
	return nil
}

// Convert_build_StepInfo_To_v1_StepInfo is an autogenerated conversion function.
func Convert_build_StepInfo_To_v1_StepInfo(in *build.StepInfo, out *StepInfo, s conversion.Scope) error {
	return autoConvert_build_StepInfo_To_v1_StepInfo(in, out, s)
}

func autoConvert_v1_WebHookTrigger_To_build_WebHookTrigger(in *WebHookTrigger, out *build.WebHookTrigger, s conversion.Scope) error {
	out.Secret = in.Secret
	out.AllowEnv = in.AllowEnv
	return nil
}

// Convert_v1_WebHookTrigger_To_build_WebHookTrigger is an autogenerated conversion function.
func Convert_v1_WebHookTrigger_To_build_WebHookTrigger(in *WebHookTrigger, out *build.WebHookTrigger, s conversion.Scope) error {
	return autoConvert_v1_WebHookTrigger_To_build_WebHookTrigger(in, out, s)
}

func autoConvert_build_WebHookTrigger_To_v1_WebHookTrigger(in *build.WebHookTrigger, out *WebHookTrigger, s conversion.Scope) error {
	out.Secret = in.Secret
	out.AllowEnv = in.AllowEnv
	return nil
}

// Convert_build_WebHookTrigger_To_v1_WebHookTrigger is an autogenerated conversion function.
func Convert_build_WebHookTrigger_To_v1_WebHookTrigger(in *build.WebHookTrigger, out *WebHookTrigger, s conversion.Scope) error {
	return autoConvert_build_WebHookTrigger_To_v1_WebHookTrigger(in, out, s)
}
