// This file was automatically generated by informer-gen

package internalversion

import (
	project "github.com/openshift/origin/pkg/project/apis/project"
	internalinterfaces "github.com/openshift/origin/pkg/project/generated/informers/internalversion/internalinterfaces"
	internalclientset "github.com/openshift/origin/pkg/project/generated/internalclientset"
	internalversion "github.com/openshift/origin/pkg/project/generated/listers/project/internalversion"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	time "time"
)

// ProjectInformer provides access to a shared informer and lister for
// Projects.
type ProjectInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() internalversion.ProjectLister
}

type projectInformer struct {
	factory internalinterfaces.SharedInformerFactory
}

func newProjectInformer(client internalclientset.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	sharedIndexInformer := cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				return client.Project().Projects().List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				return client.Project().Projects().Watch(options)
			},
		},
		&project.Project{},
		resyncPeriod,
		cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc},
	)

	return sharedIndexInformer
}

func (f *projectInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&project.Project{}, newProjectInformer)
}

func (f *projectInformer) Lister() internalversion.ProjectLister {
	return internalversion.NewProjectLister(f.Informer().GetIndexer())
}
