// This file was automatically generated by informer-gen

package internalversion

import (
	user "github.com/openshift/origin/pkg/user/apis/user"
	internalinterfaces "github.com/openshift/origin/pkg/user/generated/informers/internalversion/internalinterfaces"
	internalclientset "github.com/openshift/origin/pkg/user/generated/internalclientset"
	internalversion "github.com/openshift/origin/pkg/user/generated/listers/user/internalversion"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	time "time"
)

// GroupInformer provides access to a shared informer and lister for
// Groups.
type GroupInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() internalversion.GroupLister
}

type groupInformer struct {
	factory internalinterfaces.SharedInformerFactory
}

func newGroupInformer(client internalclientset.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	sharedIndexInformer := cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				return client.User().Groups(v1.NamespaceAll).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				return client.User().Groups(v1.NamespaceAll).Watch(options)
			},
		},
		&user.Group{},
		resyncPeriod,
		cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc},
	)

	return sharedIndexInformer
}

func (f *groupInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&user.Group{}, newGroupInformer)
}

func (f *groupInformer) Lister() internalversion.GroupLister {
	return internalversion.NewGroupLister(f.Informer().GetIndexer())
}
