// This file was automatically generated by lister-gen

package internalversion

import (
	user "github.com/openshift/origin/pkg/user/apis/user"
	"k8s.io/apimachinery/pkg/api/errors"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// UserLister helps list Users.
type UserLister interface {
	// List lists all Users in the indexer.
	List(selector labels.Selector) (ret []*user.User, err error)
	// Get retrieves the User from the index for a given name.
	Get(name string) (*user.User, error)
	UserListerExpansion
}

// userLister implements the UserLister interface.
type userLister struct {
	indexer cache.Indexer
}

// NewUserLister returns a new UserLister.
func NewUserLister(indexer cache.Indexer) UserLister {
	return &userLister{indexer: indexer}
}

// List lists all Users in the indexer.
func (s *userLister) List(selector labels.Selector) (ret []*user.User, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*user.User))
	})
	return ret, err
}

// Get retrieves the User from the index for a given name.
func (s *userLister) Get(name string) (*user.User, error) {
	key := &user.User{ObjectMeta: v1.ObjectMeta{Name: name}}
	obj, exists, err := s.indexer.Get(key)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(user.Resource("user"), name)
	}
	return obj.(*user.User), nil
}
