#!/bin/bash

while getopts ":b:v:" opt; do
  case "${opt}" in
    b) BRANCH=${OPTARG}
      ;;
    v)
      VERSION=${OPTARG}
      ;;
    :)
      echo "ERROR: Option -$OPTARG requires an argument"
      exit 1
      ;;
    \?)
      echo "ERROR: Invalid option -$OPTARG"
      exit 1
      ;;
  esac
done
shift $((OPTIND-1))

#######################################
#
# Upgrade the fuse-online-install repository
#
#######################################

if [ -z "${BRANCH}" ] || [ -z "${VERSION}" ]; then
  echo "Error: ${0} -b <branch> -v <version>"
  exit 1
fi

#
# Checkout fuse-online-install and upgrade config
#
FUSE_ONLINE_INSTALL=$(mktemp -d -t fuse-online-install-XXXXXX)
pushd ${FUSE_ONLINE_INSTALL} > /dev/null

git clone git@github.com:syndesisio/fuse-online-install.git .
if [ $? != 0 ]; then
  echo "Error: Failed to checkout repository successfully"
  exit 1
fi

#
# Checkout current branch
# Branch to a new version branch
#
git checkout -b "${VERSION}.x" "origin/${BRANCH}"
if [ $? != 0 ]; then
  echo "Error: Failed to branch and checkout successfully"
  exit 1
fi

if [ ! -f common_config.sh ]; then
  echo "Error: Cannot find common configuration file"
  exit 1
fi

sed -i "s/TAG_FUSE_ONLINE_INSTALL=.*/TAG_FUSE_ONLINE_INSTALL=${VERSION}.0/" common_config.sh
sed -i "s/TAG=.*/TAG=${VERSION}/" common_config.sh
sed -i "s/\(.*\)-operator:.*/\1-operator:${VERSION}/g" common_config.sh

sed -i "s/switch to tag .*/switch to tag ${VERSION}/" README.md
sed -i "s/git checkout .*/git checkout ${VERSION}/" README.md
sed -i "s/Update to Fuse Online .*/Update to Fuse Online ${VERSION}/" README.md
sed -i "s/syndesis-operator: .*/syndesis-operator: ${VERSION}/" README.md

git add .
git commit -m "[${VERSION}] Update release config version for ${VERSION}"

#
# Manually check before pushing
#
echo "Please review the latest commit at ${FUSE_ONLINE_INSTALL} before pushing it."
popd > /dev/null
