/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.component.ibatis.strategy;

import java.util.HashMap;
import java.util.Map;

public enum TransactionIsolationLevel {

    TRANSACTION_NONE(0),
    TRANSACTION_READ_UNCOMMITTED(1),
    TRANSACTION_READ_COMMITTED(2),
    TRANSACTION_REPEATABLE_READ(4),
    TRANSACTION_SERIALIZABLE(8);

    protected static final Map<Integer, TransactionIsolationLevel> MAP = new HashMap<>();

    static {
        for (TransactionIsolationLevel transactionIsolationLevel : values()) {
            MAP.put(transactionIsolationLevel.getValue(), transactionIsolationLevel);
        }
    }

    int value;

    TransactionIsolationLevel(int value) {
        this.value = value;
    }

    public static int intValueOf(String name) {
        return valueOf(name).getValue();
    }

    public static String nameOf(int level) {
        return MAP.get(level).name();
    }

    public int getValue() {
        return value;
    }
}