package io.hawt.springboot;

import io.undertow.Undertow;
import io.undertow.server.handlers.CookieSameSiteMode;
import io.undertow.server.handlers.SameSiteCookieHandler;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;

@ManagementContextConfiguration
@ConditionalOnClass(Undertow.class)
public class UndertowConfiguration {

    @Bean
    public WebServerFactoryCustomizer<UndertowServletWebServerFactory> undertowWebServerFactoryCustomizer() {
        return factory -> factory.addDeploymentInfoCustomizers(
            info -> info.addInitialHandlerChainWrapper(handler ->
                new SameSiteCookieHandler(handler, CookieSameSiteMode.STRICT.name(), "JSESSIONID")));
    }
}
