// This file was automatically generated by informer-gen

package externalversions

import (
	"fmt"
	v1 "github.com/openshift/origin/pkg/authorization/apis/authorization/v1"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=Authorization, Version=V1
	case v1.SchemeGroupVersion.WithResource("clusterpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Authorization().V1().ClusterPolicies().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("clusterpolicybindings"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Authorization().V1().ClusterPolicyBindings().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("clusterroles"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Authorization().V1().ClusterRoles().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("clusterrolebindings"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Authorization().V1().ClusterRoleBindings().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("policies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Authorization().V1().Policies().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("policybindings"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Authorization().V1().PolicyBindings().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("roles"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Authorization().V1().Roles().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("rolebindings"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Authorization().V1().RoleBindings().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
