// This file was automatically generated by lister-gen

package v1

import (
	v1 "github.com/openshift/origin/pkg/authorization/apis/authorization/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PolicyBindingLister helps list PolicyBindings.
type PolicyBindingLister interface {
	// List lists all PolicyBindings in the indexer.
	List(selector labels.Selector) (ret []*v1.PolicyBinding, err error)
	// PolicyBindings returns an object that can list and get PolicyBindings.
	PolicyBindings(namespace string) PolicyBindingNamespaceLister
	PolicyBindingListerExpansion
}

// policyBindingLister implements the PolicyBindingLister interface.
type policyBindingLister struct {
	indexer cache.Indexer
}

// NewPolicyBindingLister returns a new PolicyBindingLister.
func NewPolicyBindingLister(indexer cache.Indexer) PolicyBindingLister {
	return &policyBindingLister{indexer: indexer}
}

// List lists all PolicyBindings in the indexer.
func (s *policyBindingLister) List(selector labels.Selector) (ret []*v1.PolicyBinding, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PolicyBinding))
	})
	return ret, err
}

// PolicyBindings returns an object that can list and get PolicyBindings.
func (s *policyBindingLister) PolicyBindings(namespace string) PolicyBindingNamespaceLister {
	return policyBindingNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PolicyBindingNamespaceLister helps list and get PolicyBindings.
type PolicyBindingNamespaceLister interface {
	// List lists all PolicyBindings in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.PolicyBinding, err error)
	// Get retrieves the PolicyBinding from the indexer for a given namespace and name.
	Get(name string) (*v1.PolicyBinding, error)
	PolicyBindingNamespaceListerExpansion
}

// policyBindingNamespaceLister implements the PolicyBindingNamespaceLister
// interface.
type policyBindingNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PolicyBindings in the indexer for a given namespace.
func (s policyBindingNamespaceLister) List(selector labels.Selector) (ret []*v1.PolicyBinding, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PolicyBinding))
	})
	return ret, err
}

// Get retrieves the PolicyBinding from the indexer for a given namespace and name.
func (s policyBindingNamespaceLister) Get(name string) (*v1.PolicyBinding, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("policybinding"), name)
	}
	return obj.(*v1.PolicyBinding), nil
}
