// +build !ignore_autogenerated_openshift

// This file was autogenerated by conversion-gen. Do not edit it manually!

package v1

import (
	apps "github.com/openshift/origin/pkg/deploy/apis/apps"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	api "k8s.io/kubernetes/pkg/api"
	api_v1 "k8s.io/kubernetes/pkg/api/v1"
	unsafe "unsafe"
)

func init() {
	SchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_CustomDeploymentStrategyParams_To_apps_CustomDeploymentStrategyParams,
		Convert_apps_CustomDeploymentStrategyParams_To_v1_CustomDeploymentStrategyParams,
		Convert_v1_DeploymentCause_To_apps_DeploymentCause,
		Convert_apps_DeploymentCause_To_v1_DeploymentCause,
		Convert_v1_DeploymentCauseImageTrigger_To_apps_DeploymentCauseImageTrigger,
		Convert_apps_DeploymentCauseImageTrigger_To_v1_DeploymentCauseImageTrigger,
		Convert_v1_DeploymentCondition_To_apps_DeploymentCondition,
		Convert_apps_DeploymentCondition_To_v1_DeploymentCondition,
		Convert_v1_DeploymentConfig_To_apps_DeploymentConfig,
		Convert_apps_DeploymentConfig_To_v1_DeploymentConfig,
		Convert_v1_DeploymentConfigList_To_apps_DeploymentConfigList,
		Convert_apps_DeploymentConfigList_To_v1_DeploymentConfigList,
		Convert_v1_DeploymentConfigRollback_To_apps_DeploymentConfigRollback,
		Convert_apps_DeploymentConfigRollback_To_v1_DeploymentConfigRollback,
		Convert_v1_DeploymentConfigRollbackSpec_To_apps_DeploymentConfigRollbackSpec,
		Convert_apps_DeploymentConfigRollbackSpec_To_v1_DeploymentConfigRollbackSpec,
		Convert_v1_DeploymentConfigSpec_To_apps_DeploymentConfigSpec,
		Convert_apps_DeploymentConfigSpec_To_v1_DeploymentConfigSpec,
		Convert_v1_DeploymentConfigStatus_To_apps_DeploymentConfigStatus,
		Convert_apps_DeploymentConfigStatus_To_v1_DeploymentConfigStatus,
		Convert_v1_DeploymentDetails_To_apps_DeploymentDetails,
		Convert_apps_DeploymentDetails_To_v1_DeploymentDetails,
		Convert_v1_DeploymentLog_To_apps_DeploymentLog,
		Convert_apps_DeploymentLog_To_v1_DeploymentLog,
		Convert_v1_DeploymentLogOptions_To_apps_DeploymentLogOptions,
		Convert_apps_DeploymentLogOptions_To_v1_DeploymentLogOptions,
		Convert_v1_DeploymentRequest_To_apps_DeploymentRequest,
		Convert_apps_DeploymentRequest_To_v1_DeploymentRequest,
		Convert_v1_DeploymentStrategy_To_apps_DeploymentStrategy,
		Convert_apps_DeploymentStrategy_To_v1_DeploymentStrategy,
		Convert_v1_DeploymentTriggerImageChangeParams_To_apps_DeploymentTriggerImageChangeParams,
		Convert_apps_DeploymentTriggerImageChangeParams_To_v1_DeploymentTriggerImageChangeParams,
		Convert_v1_DeploymentTriggerPolicy_To_apps_DeploymentTriggerPolicy,
		Convert_apps_DeploymentTriggerPolicy_To_v1_DeploymentTriggerPolicy,
		Convert_v1_ExecNewPodHook_To_apps_ExecNewPodHook,
		Convert_apps_ExecNewPodHook_To_v1_ExecNewPodHook,
		Convert_v1_LifecycleHook_To_apps_LifecycleHook,
		Convert_apps_LifecycleHook_To_v1_LifecycleHook,
		Convert_v1_RecreateDeploymentStrategyParams_To_apps_RecreateDeploymentStrategyParams,
		Convert_apps_RecreateDeploymentStrategyParams_To_v1_RecreateDeploymentStrategyParams,
		Convert_v1_RollingDeploymentStrategyParams_To_apps_RollingDeploymentStrategyParams,
		Convert_apps_RollingDeploymentStrategyParams_To_v1_RollingDeploymentStrategyParams,
		Convert_v1_TagImageHook_To_apps_TagImageHook,
		Convert_apps_TagImageHook_To_v1_TagImageHook,
	)
}

func autoConvert_v1_CustomDeploymentStrategyParams_To_apps_CustomDeploymentStrategyParams(in *CustomDeploymentStrategyParams, out *apps.CustomDeploymentStrategyParams, s conversion.Scope) error {
	out.Image = in.Image
	if in.Environment != nil {
		in, out := &in.Environment, &out.Environment
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Environment = nil
	}
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	return nil
}

// Convert_v1_CustomDeploymentStrategyParams_To_apps_CustomDeploymentStrategyParams is an autogenerated conversion function.
func Convert_v1_CustomDeploymentStrategyParams_To_apps_CustomDeploymentStrategyParams(in *CustomDeploymentStrategyParams, out *apps.CustomDeploymentStrategyParams, s conversion.Scope) error {
	return autoConvert_v1_CustomDeploymentStrategyParams_To_apps_CustomDeploymentStrategyParams(in, out, s)
}

func autoConvert_apps_CustomDeploymentStrategyParams_To_v1_CustomDeploymentStrategyParams(in *apps.CustomDeploymentStrategyParams, out *CustomDeploymentStrategyParams, s conversion.Scope) error {
	out.Image = in.Image
	if in.Environment != nil {
		in, out := &in.Environment, &out.Environment
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Environment = nil
	}
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	return nil
}

// Convert_apps_CustomDeploymentStrategyParams_To_v1_CustomDeploymentStrategyParams is an autogenerated conversion function.
func Convert_apps_CustomDeploymentStrategyParams_To_v1_CustomDeploymentStrategyParams(in *apps.CustomDeploymentStrategyParams, out *CustomDeploymentStrategyParams, s conversion.Scope) error {
	return autoConvert_apps_CustomDeploymentStrategyParams_To_v1_CustomDeploymentStrategyParams(in, out, s)
}

func autoConvert_v1_DeploymentCause_To_apps_DeploymentCause(in *DeploymentCause, out *apps.DeploymentCause, s conversion.Scope) error {
	out.Type = apps.DeploymentTriggerType(in.Type)
	if in.ImageTrigger != nil {
		in, out := &in.ImageTrigger, &out.ImageTrigger
		*out = new(apps.DeploymentCauseImageTrigger)
		if err := Convert_v1_DeploymentCauseImageTrigger_To_apps_DeploymentCauseImageTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageTrigger = nil
	}
	return nil
}

// Convert_v1_DeploymentCause_To_apps_DeploymentCause is an autogenerated conversion function.
func Convert_v1_DeploymentCause_To_apps_DeploymentCause(in *DeploymentCause, out *apps.DeploymentCause, s conversion.Scope) error {
	return autoConvert_v1_DeploymentCause_To_apps_DeploymentCause(in, out, s)
}

func autoConvert_apps_DeploymentCause_To_v1_DeploymentCause(in *apps.DeploymentCause, out *DeploymentCause, s conversion.Scope) error {
	out.Type = DeploymentTriggerType(in.Type)
	if in.ImageTrigger != nil {
		in, out := &in.ImageTrigger, &out.ImageTrigger
		*out = new(DeploymentCauseImageTrigger)
		if err := Convert_apps_DeploymentCauseImageTrigger_To_v1_DeploymentCauseImageTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageTrigger = nil
	}
	return nil
}

// Convert_apps_DeploymentCause_To_v1_DeploymentCause is an autogenerated conversion function.
func Convert_apps_DeploymentCause_To_v1_DeploymentCause(in *apps.DeploymentCause, out *DeploymentCause, s conversion.Scope) error {
	return autoConvert_apps_DeploymentCause_To_v1_DeploymentCause(in, out, s)
}

func autoConvert_v1_DeploymentCauseImageTrigger_To_apps_DeploymentCauseImageTrigger(in *DeploymentCauseImageTrigger, out *apps.DeploymentCauseImageTrigger, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DeploymentCauseImageTrigger_To_apps_DeploymentCauseImageTrigger is an autogenerated conversion function.
func Convert_v1_DeploymentCauseImageTrigger_To_apps_DeploymentCauseImageTrigger(in *DeploymentCauseImageTrigger, out *apps.DeploymentCauseImageTrigger, s conversion.Scope) error {
	return autoConvert_v1_DeploymentCauseImageTrigger_To_apps_DeploymentCauseImageTrigger(in, out, s)
}

func autoConvert_apps_DeploymentCauseImageTrigger_To_v1_DeploymentCauseImageTrigger(in *apps.DeploymentCauseImageTrigger, out *DeploymentCauseImageTrigger, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_DeploymentCauseImageTrigger_To_v1_DeploymentCauseImageTrigger is an autogenerated conversion function.
func Convert_apps_DeploymentCauseImageTrigger_To_v1_DeploymentCauseImageTrigger(in *apps.DeploymentCauseImageTrigger, out *DeploymentCauseImageTrigger, s conversion.Scope) error {
	return autoConvert_apps_DeploymentCauseImageTrigger_To_v1_DeploymentCauseImageTrigger(in, out, s)
}

func autoConvert_v1_DeploymentCondition_To_apps_DeploymentCondition(in *DeploymentCondition, out *apps.DeploymentCondition, s conversion.Scope) error {
	out.Type = apps.DeploymentConditionType(in.Type)
	out.Status = api.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = apps.DeploymentConditionReason(in.Reason)
	out.Message = in.Message
	return nil
}

// Convert_v1_DeploymentCondition_To_apps_DeploymentCondition is an autogenerated conversion function.
func Convert_v1_DeploymentCondition_To_apps_DeploymentCondition(in *DeploymentCondition, out *apps.DeploymentCondition, s conversion.Scope) error {
	return autoConvert_v1_DeploymentCondition_To_apps_DeploymentCondition(in, out, s)
}

func autoConvert_apps_DeploymentCondition_To_v1_DeploymentCondition(in *apps.DeploymentCondition, out *DeploymentCondition, s conversion.Scope) error {
	out.Type = DeploymentConditionType(in.Type)
	out.Status = api_v1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = string(in.Reason)
	out.Message = in.Message
	return nil
}

// Convert_apps_DeploymentCondition_To_v1_DeploymentCondition is an autogenerated conversion function.
func Convert_apps_DeploymentCondition_To_v1_DeploymentCondition(in *apps.DeploymentCondition, out *DeploymentCondition, s conversion.Scope) error {
	return autoConvert_apps_DeploymentCondition_To_v1_DeploymentCondition(in, out, s)
}

func autoConvert_v1_DeploymentConfig_To_apps_DeploymentConfig(in *DeploymentConfig, out *apps.DeploymentConfig, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_DeploymentConfigSpec_To_apps_DeploymentConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_DeploymentConfigStatus_To_apps_DeploymentConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DeploymentConfig_To_apps_DeploymentConfig is an autogenerated conversion function.
func Convert_v1_DeploymentConfig_To_apps_DeploymentConfig(in *DeploymentConfig, out *apps.DeploymentConfig, s conversion.Scope) error {
	return autoConvert_v1_DeploymentConfig_To_apps_DeploymentConfig(in, out, s)
}

func autoConvert_apps_DeploymentConfig_To_v1_DeploymentConfig(in *apps.DeploymentConfig, out *DeploymentConfig, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_apps_DeploymentConfigSpec_To_v1_DeploymentConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_apps_DeploymentConfigStatus_To_v1_DeploymentConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_DeploymentConfig_To_v1_DeploymentConfig is an autogenerated conversion function.
func Convert_apps_DeploymentConfig_To_v1_DeploymentConfig(in *apps.DeploymentConfig, out *DeploymentConfig, s conversion.Scope) error {
	return autoConvert_apps_DeploymentConfig_To_v1_DeploymentConfig(in, out, s)
}

func autoConvert_v1_DeploymentConfigList_To_apps_DeploymentConfigList(in *DeploymentConfigList, out *apps.DeploymentConfigList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]apps.DeploymentConfig, len(*in))
		for i := range *in {
			if err := Convert_v1_DeploymentConfig_To_apps_DeploymentConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_DeploymentConfigList_To_apps_DeploymentConfigList is an autogenerated conversion function.
func Convert_v1_DeploymentConfigList_To_apps_DeploymentConfigList(in *DeploymentConfigList, out *apps.DeploymentConfigList, s conversion.Scope) error {
	return autoConvert_v1_DeploymentConfigList_To_apps_DeploymentConfigList(in, out, s)
}

func autoConvert_apps_DeploymentConfigList_To_v1_DeploymentConfigList(in *apps.DeploymentConfigList, out *DeploymentConfigList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DeploymentConfig, len(*in))
		for i := range *in {
			if err := Convert_apps_DeploymentConfig_To_v1_DeploymentConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = make([]DeploymentConfig, 0)
	}
	return nil
}

// Convert_apps_DeploymentConfigList_To_v1_DeploymentConfigList is an autogenerated conversion function.
func Convert_apps_DeploymentConfigList_To_v1_DeploymentConfigList(in *apps.DeploymentConfigList, out *DeploymentConfigList, s conversion.Scope) error {
	return autoConvert_apps_DeploymentConfigList_To_v1_DeploymentConfigList(in, out, s)
}

func autoConvert_v1_DeploymentConfigRollback_To_apps_DeploymentConfigRollback(in *DeploymentConfigRollback, out *apps.DeploymentConfigRollback, s conversion.Scope) error {
	out.Name = in.Name
	out.UpdatedAnnotations = *(*map[string]string)(unsafe.Pointer(&in.UpdatedAnnotations))
	if err := Convert_v1_DeploymentConfigRollbackSpec_To_apps_DeploymentConfigRollbackSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DeploymentConfigRollback_To_apps_DeploymentConfigRollback is an autogenerated conversion function.
func Convert_v1_DeploymentConfigRollback_To_apps_DeploymentConfigRollback(in *DeploymentConfigRollback, out *apps.DeploymentConfigRollback, s conversion.Scope) error {
	return autoConvert_v1_DeploymentConfigRollback_To_apps_DeploymentConfigRollback(in, out, s)
}

func autoConvert_apps_DeploymentConfigRollback_To_v1_DeploymentConfigRollback(in *apps.DeploymentConfigRollback, out *DeploymentConfigRollback, s conversion.Scope) error {
	out.Name = in.Name
	out.UpdatedAnnotations = *(*map[string]string)(unsafe.Pointer(&in.UpdatedAnnotations))
	if err := Convert_apps_DeploymentConfigRollbackSpec_To_v1_DeploymentConfigRollbackSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_DeploymentConfigRollback_To_v1_DeploymentConfigRollback is an autogenerated conversion function.
func Convert_apps_DeploymentConfigRollback_To_v1_DeploymentConfigRollback(in *apps.DeploymentConfigRollback, out *DeploymentConfigRollback, s conversion.Scope) error {
	return autoConvert_apps_DeploymentConfigRollback_To_v1_DeploymentConfigRollback(in, out, s)
}

func autoConvert_v1_DeploymentConfigRollbackSpec_To_apps_DeploymentConfigRollbackSpec(in *DeploymentConfigRollbackSpec, out *apps.DeploymentConfigRollbackSpec, s conversion.Scope) error {
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.Revision = in.Revision
	out.IncludeTriggers = in.IncludeTriggers
	out.IncludeTemplate = in.IncludeTemplate
	out.IncludeReplicationMeta = in.IncludeReplicationMeta
	out.IncludeStrategy = in.IncludeStrategy
	return nil
}

// Convert_v1_DeploymentConfigRollbackSpec_To_apps_DeploymentConfigRollbackSpec is an autogenerated conversion function.
func Convert_v1_DeploymentConfigRollbackSpec_To_apps_DeploymentConfigRollbackSpec(in *DeploymentConfigRollbackSpec, out *apps.DeploymentConfigRollbackSpec, s conversion.Scope) error {
	return autoConvert_v1_DeploymentConfigRollbackSpec_To_apps_DeploymentConfigRollbackSpec(in, out, s)
}

func autoConvert_apps_DeploymentConfigRollbackSpec_To_v1_DeploymentConfigRollbackSpec(in *apps.DeploymentConfigRollbackSpec, out *DeploymentConfigRollbackSpec, s conversion.Scope) error {
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.Revision = in.Revision
	out.IncludeTriggers = in.IncludeTriggers
	out.IncludeTemplate = in.IncludeTemplate
	out.IncludeReplicationMeta = in.IncludeReplicationMeta
	out.IncludeStrategy = in.IncludeStrategy
	return nil
}

// Convert_apps_DeploymentConfigRollbackSpec_To_v1_DeploymentConfigRollbackSpec is an autogenerated conversion function.
func Convert_apps_DeploymentConfigRollbackSpec_To_v1_DeploymentConfigRollbackSpec(in *apps.DeploymentConfigRollbackSpec, out *DeploymentConfigRollbackSpec, s conversion.Scope) error {
	return autoConvert_apps_DeploymentConfigRollbackSpec_To_v1_DeploymentConfigRollbackSpec(in, out, s)
}

func autoConvert_v1_DeploymentConfigSpec_To_apps_DeploymentConfigSpec(in *DeploymentConfigSpec, out *apps.DeploymentConfigSpec, s conversion.Scope) error {
	if err := Convert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]apps.DeploymentTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_v1_DeploymentTriggerPolicy_To_apps_DeploymentTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = nil
	}
	out.Replicas = in.Replicas
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Test = in.Test
	out.Paused = in.Paused
	out.Selector = *(*map[string]string)(unsafe.Pointer(&in.Selector))
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(api.PodTemplateSpec)
		if err := api_v1.Convert_v1_PodTemplateSpec_To_api_PodTemplateSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Template = nil
	}
	return nil
}

// Convert_v1_DeploymentConfigSpec_To_apps_DeploymentConfigSpec is an autogenerated conversion function.
func Convert_v1_DeploymentConfigSpec_To_apps_DeploymentConfigSpec(in *DeploymentConfigSpec, out *apps.DeploymentConfigSpec, s conversion.Scope) error {
	return autoConvert_v1_DeploymentConfigSpec_To_apps_DeploymentConfigSpec(in, out, s)
}

func autoConvert_apps_DeploymentConfigSpec_To_v1_DeploymentConfigSpec(in *apps.DeploymentConfigSpec, out *DeploymentConfigSpec, s conversion.Scope) error {
	if err := Convert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make(DeploymentTriggerPolicies, len(*in))
		for i := range *in {
			if err := Convert_apps_DeploymentTriggerPolicy_To_v1_DeploymentTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = make(DeploymentTriggerPolicies, 0)
	}
	out.Replicas = in.Replicas
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Test = in.Test
	out.Paused = in.Paused
	out.Selector = *(*map[string]string)(unsafe.Pointer(&in.Selector))
	if in.Template != nil {
		in, out := &in.Template, &out.Template
		*out = new(api_v1.PodTemplateSpec)
		if err := api_v1.Convert_api_PodTemplateSpec_To_v1_PodTemplateSpec(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Template = nil
	}
	return nil
}

// Convert_apps_DeploymentConfigSpec_To_v1_DeploymentConfigSpec is an autogenerated conversion function.
func Convert_apps_DeploymentConfigSpec_To_v1_DeploymentConfigSpec(in *apps.DeploymentConfigSpec, out *DeploymentConfigSpec, s conversion.Scope) error {
	return autoConvert_apps_DeploymentConfigSpec_To_v1_DeploymentConfigSpec(in, out, s)
}

func autoConvert_v1_DeploymentConfigStatus_To_apps_DeploymentConfigStatus(in *DeploymentConfigStatus, out *apps.DeploymentConfigStatus, s conversion.Scope) error {
	out.LatestVersion = in.LatestVersion
	out.ObservedGeneration = in.ObservedGeneration
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	if in.Details != nil {
		in, out := &in.Details, &out.Details
		*out = new(apps.DeploymentDetails)
		if err := Convert_v1_DeploymentDetails_To_apps_DeploymentDetails(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Details = nil
	}
	out.Conditions = *(*[]apps.DeploymentCondition)(unsafe.Pointer(&in.Conditions))
	out.ReadyReplicas = in.ReadyReplicas
	return nil
}

// Convert_v1_DeploymentConfigStatus_To_apps_DeploymentConfigStatus is an autogenerated conversion function.
func Convert_v1_DeploymentConfigStatus_To_apps_DeploymentConfigStatus(in *DeploymentConfigStatus, out *apps.DeploymentConfigStatus, s conversion.Scope) error {
	return autoConvert_v1_DeploymentConfigStatus_To_apps_DeploymentConfigStatus(in, out, s)
}

func autoConvert_apps_DeploymentConfigStatus_To_v1_DeploymentConfigStatus(in *apps.DeploymentConfigStatus, out *DeploymentConfigStatus, s conversion.Scope) error {
	out.LatestVersion = in.LatestVersion
	out.ObservedGeneration = in.ObservedGeneration
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	if in.Details != nil {
		in, out := &in.Details, &out.Details
		*out = new(DeploymentDetails)
		if err := Convert_apps_DeploymentDetails_To_v1_DeploymentDetails(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Details = nil
	}
	out.Conditions = *(*[]DeploymentCondition)(unsafe.Pointer(&in.Conditions))
	out.ReadyReplicas = in.ReadyReplicas
	return nil
}

// Convert_apps_DeploymentConfigStatus_To_v1_DeploymentConfigStatus is an autogenerated conversion function.
func Convert_apps_DeploymentConfigStatus_To_v1_DeploymentConfigStatus(in *apps.DeploymentConfigStatus, out *DeploymentConfigStatus, s conversion.Scope) error {
	return autoConvert_apps_DeploymentConfigStatus_To_v1_DeploymentConfigStatus(in, out, s)
}

func autoConvert_v1_DeploymentDetails_To_apps_DeploymentDetails(in *DeploymentDetails, out *apps.DeploymentDetails, s conversion.Scope) error {
	out.Message = in.Message
	if in.Causes != nil {
		in, out := &in.Causes, &out.Causes
		*out = make([]apps.DeploymentCause, len(*in))
		for i := range *in {
			if err := Convert_v1_DeploymentCause_To_apps_DeploymentCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Causes = nil
	}
	return nil
}

// Convert_v1_DeploymentDetails_To_apps_DeploymentDetails is an autogenerated conversion function.
func Convert_v1_DeploymentDetails_To_apps_DeploymentDetails(in *DeploymentDetails, out *apps.DeploymentDetails, s conversion.Scope) error {
	return autoConvert_v1_DeploymentDetails_To_apps_DeploymentDetails(in, out, s)
}

func autoConvert_apps_DeploymentDetails_To_v1_DeploymentDetails(in *apps.DeploymentDetails, out *DeploymentDetails, s conversion.Scope) error {
	out.Message = in.Message
	if in.Causes != nil {
		in, out := &in.Causes, &out.Causes
		*out = make([]DeploymentCause, len(*in))
		for i := range *in {
			if err := Convert_apps_DeploymentCause_To_v1_DeploymentCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Causes = make([]DeploymentCause, 0)
	}
	return nil
}

// Convert_apps_DeploymentDetails_To_v1_DeploymentDetails is an autogenerated conversion function.
func Convert_apps_DeploymentDetails_To_v1_DeploymentDetails(in *apps.DeploymentDetails, out *DeploymentDetails, s conversion.Scope) error {
	return autoConvert_apps_DeploymentDetails_To_v1_DeploymentDetails(in, out, s)
}

func autoConvert_v1_DeploymentLog_To_apps_DeploymentLog(in *DeploymentLog, out *apps.DeploymentLog, s conversion.Scope) error {
	return nil
}

// Convert_v1_DeploymentLog_To_apps_DeploymentLog is an autogenerated conversion function.
func Convert_v1_DeploymentLog_To_apps_DeploymentLog(in *DeploymentLog, out *apps.DeploymentLog, s conversion.Scope) error {
	return autoConvert_v1_DeploymentLog_To_apps_DeploymentLog(in, out, s)
}

func autoConvert_apps_DeploymentLog_To_v1_DeploymentLog(in *apps.DeploymentLog, out *DeploymentLog, s conversion.Scope) error {
	return nil
}

// Convert_apps_DeploymentLog_To_v1_DeploymentLog is an autogenerated conversion function.
func Convert_apps_DeploymentLog_To_v1_DeploymentLog(in *apps.DeploymentLog, out *DeploymentLog, s conversion.Scope) error {
	return autoConvert_apps_DeploymentLog_To_v1_DeploymentLog(in, out, s)
}

func autoConvert_v1_DeploymentLogOptions_To_apps_DeploymentLogOptions(in *DeploymentLogOptions, out *apps.DeploymentLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*meta_v1.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	out.NoWait = in.NoWait
	out.Version = (*int64)(unsafe.Pointer(in.Version))
	return nil
}

// Convert_v1_DeploymentLogOptions_To_apps_DeploymentLogOptions is an autogenerated conversion function.
func Convert_v1_DeploymentLogOptions_To_apps_DeploymentLogOptions(in *DeploymentLogOptions, out *apps.DeploymentLogOptions, s conversion.Scope) error {
	return autoConvert_v1_DeploymentLogOptions_To_apps_DeploymentLogOptions(in, out, s)
}

func autoConvert_apps_DeploymentLogOptions_To_v1_DeploymentLogOptions(in *apps.DeploymentLogOptions, out *DeploymentLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*meta_v1.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	out.NoWait = in.NoWait
	out.Version = (*int64)(unsafe.Pointer(in.Version))
	return nil
}

// Convert_apps_DeploymentLogOptions_To_v1_DeploymentLogOptions is an autogenerated conversion function.
func Convert_apps_DeploymentLogOptions_To_v1_DeploymentLogOptions(in *apps.DeploymentLogOptions, out *DeploymentLogOptions, s conversion.Scope) error {
	return autoConvert_apps_DeploymentLogOptions_To_v1_DeploymentLogOptions(in, out, s)
}

func autoConvert_v1_DeploymentRequest_To_apps_DeploymentRequest(in *DeploymentRequest, out *apps.DeploymentRequest, s conversion.Scope) error {
	out.Name = in.Name
	out.Latest = in.Latest
	out.Force = in.Force
	out.ExcludeTriggers = *(*[]apps.DeploymentTriggerType)(unsafe.Pointer(&in.ExcludeTriggers))
	return nil
}

// Convert_v1_DeploymentRequest_To_apps_DeploymentRequest is an autogenerated conversion function.
func Convert_v1_DeploymentRequest_To_apps_DeploymentRequest(in *DeploymentRequest, out *apps.DeploymentRequest, s conversion.Scope) error {
	return autoConvert_v1_DeploymentRequest_To_apps_DeploymentRequest(in, out, s)
}

func autoConvert_apps_DeploymentRequest_To_v1_DeploymentRequest(in *apps.DeploymentRequest, out *DeploymentRequest, s conversion.Scope) error {
	out.Name = in.Name
	out.Latest = in.Latest
	out.Force = in.Force
	out.ExcludeTriggers = *(*[]DeploymentTriggerType)(unsafe.Pointer(&in.ExcludeTriggers))
	return nil
}

// Convert_apps_DeploymentRequest_To_v1_DeploymentRequest is an autogenerated conversion function.
func Convert_apps_DeploymentRequest_To_v1_DeploymentRequest(in *apps.DeploymentRequest, out *DeploymentRequest, s conversion.Scope) error {
	return autoConvert_apps_DeploymentRequest_To_v1_DeploymentRequest(in, out, s)
}

func autoConvert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(in *DeploymentStrategy, out *apps.DeploymentStrategy, s conversion.Scope) error {
	out.Type = apps.DeploymentStrategyType(in.Type)
	if in.CustomParams != nil {
		in, out := &in.CustomParams, &out.CustomParams
		*out = new(apps.CustomDeploymentStrategyParams)
		if err := Convert_v1_CustomDeploymentStrategyParams_To_apps_CustomDeploymentStrategyParams(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomParams = nil
	}
	if in.RecreateParams != nil {
		in, out := &in.RecreateParams, &out.RecreateParams
		*out = new(apps.RecreateDeploymentStrategyParams)
		if err := Convert_v1_RecreateDeploymentStrategyParams_To_apps_RecreateDeploymentStrategyParams(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RecreateParams = nil
	}
	if in.RollingParams != nil {
		in, out := &in.RollingParams, &out.RollingParams
		*out = new(apps.RollingDeploymentStrategyParams)
		if err := Convert_v1_RollingDeploymentStrategyParams_To_apps_RollingDeploymentStrategyParams(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingParams = nil
	}
	if err := api_v1.Convert_v1_ResourceRequirements_To_api_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.ActiveDeadlineSeconds = (*int64)(unsafe.Pointer(in.ActiveDeadlineSeconds))
	return nil
}

// Convert_v1_DeploymentStrategy_To_apps_DeploymentStrategy is an autogenerated conversion function.
func Convert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(in *DeploymentStrategy, out *apps.DeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1_DeploymentStrategy_To_apps_DeploymentStrategy(in, out, s)
}

func autoConvert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(in *apps.DeploymentStrategy, out *DeploymentStrategy, s conversion.Scope) error {
	out.Type = DeploymentStrategyType(in.Type)
	if in.CustomParams != nil {
		in, out := &in.CustomParams, &out.CustomParams
		*out = new(CustomDeploymentStrategyParams)
		if err := Convert_apps_CustomDeploymentStrategyParams_To_v1_CustomDeploymentStrategyParams(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomParams = nil
	}
	if in.RecreateParams != nil {
		in, out := &in.RecreateParams, &out.RecreateParams
		*out = new(RecreateDeploymentStrategyParams)
		if err := Convert_apps_RecreateDeploymentStrategyParams_To_v1_RecreateDeploymentStrategyParams(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RecreateParams = nil
	}
	if in.RollingParams != nil {
		in, out := &in.RollingParams, &out.RollingParams
		*out = new(RollingDeploymentStrategyParams)
		if err := Convert_apps_RollingDeploymentStrategyParams_To_v1_RollingDeploymentStrategyParams(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.RollingParams = nil
	}
	if err := api_v1.Convert_api_ResourceRequirements_To_v1_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.ActiveDeadlineSeconds = (*int64)(unsafe.Pointer(in.ActiveDeadlineSeconds))
	return nil
}

// Convert_apps_DeploymentStrategy_To_v1_DeploymentStrategy is an autogenerated conversion function.
func Convert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(in *apps.DeploymentStrategy, out *DeploymentStrategy, s conversion.Scope) error {
	return autoConvert_apps_DeploymentStrategy_To_v1_DeploymentStrategy(in, out, s)
}

func autoConvert_v1_DeploymentTriggerImageChangeParams_To_apps_DeploymentTriggerImageChangeParams(in *DeploymentTriggerImageChangeParams, out *apps.DeploymentTriggerImageChangeParams, s conversion.Scope) error {
	out.Automatic = in.Automatic
	out.ContainerNames = *(*[]string)(unsafe.Pointer(&in.ContainerNames))
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.LastTriggeredImage = in.LastTriggeredImage
	return nil
}

func autoConvert_apps_DeploymentTriggerImageChangeParams_To_v1_DeploymentTriggerImageChangeParams(in *apps.DeploymentTriggerImageChangeParams, out *DeploymentTriggerImageChangeParams, s conversion.Scope) error {
	out.Automatic = in.Automatic
	out.ContainerNames = *(*[]string)(unsafe.Pointer(&in.ContainerNames))
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.LastTriggeredImage = in.LastTriggeredImage
	return nil
}

func autoConvert_v1_DeploymentTriggerPolicy_To_apps_DeploymentTriggerPolicy(in *DeploymentTriggerPolicy, out *apps.DeploymentTriggerPolicy, s conversion.Scope) error {
	out.Type = apps.DeploymentTriggerType(in.Type)
	if in.ImageChangeParams != nil {
		in, out := &in.ImageChangeParams, &out.ImageChangeParams
		*out = new(apps.DeploymentTriggerImageChangeParams)
		if err := Convert_v1_DeploymentTriggerImageChangeParams_To_apps_DeploymentTriggerImageChangeParams(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeParams = nil
	}
	return nil
}

// Convert_v1_DeploymentTriggerPolicy_To_apps_DeploymentTriggerPolicy is an autogenerated conversion function.
func Convert_v1_DeploymentTriggerPolicy_To_apps_DeploymentTriggerPolicy(in *DeploymentTriggerPolicy, out *apps.DeploymentTriggerPolicy, s conversion.Scope) error {
	return autoConvert_v1_DeploymentTriggerPolicy_To_apps_DeploymentTriggerPolicy(in, out, s)
}

func autoConvert_apps_DeploymentTriggerPolicy_To_v1_DeploymentTriggerPolicy(in *apps.DeploymentTriggerPolicy, out *DeploymentTriggerPolicy, s conversion.Scope) error {
	out.Type = DeploymentTriggerType(in.Type)
	if in.ImageChangeParams != nil {
		in, out := &in.ImageChangeParams, &out.ImageChangeParams
		*out = new(DeploymentTriggerImageChangeParams)
		if err := Convert_apps_DeploymentTriggerImageChangeParams_To_v1_DeploymentTriggerImageChangeParams(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeParams = nil
	}
	return nil
}

// Convert_apps_DeploymentTriggerPolicy_To_v1_DeploymentTriggerPolicy is an autogenerated conversion function.
func Convert_apps_DeploymentTriggerPolicy_To_v1_DeploymentTriggerPolicy(in *apps.DeploymentTriggerPolicy, out *DeploymentTriggerPolicy, s conversion.Scope) error {
	return autoConvert_apps_DeploymentTriggerPolicy_To_v1_DeploymentTriggerPolicy(in, out, s)
}

func autoConvert_v1_ExecNewPodHook_To_apps_ExecNewPodHook(in *ExecNewPodHook, out *apps.ExecNewPodHook, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_v1_EnvVar_To_api_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ContainerName = in.ContainerName
	out.Volumes = *(*[]string)(unsafe.Pointer(&in.Volumes))
	return nil
}

// Convert_v1_ExecNewPodHook_To_apps_ExecNewPodHook is an autogenerated conversion function.
func Convert_v1_ExecNewPodHook_To_apps_ExecNewPodHook(in *ExecNewPodHook, out *apps.ExecNewPodHook, s conversion.Scope) error {
	return autoConvert_v1_ExecNewPodHook_To_apps_ExecNewPodHook(in, out, s)
}

func autoConvert_apps_ExecNewPodHook_To_v1_ExecNewPodHook(in *apps.ExecNewPodHook, out *ExecNewPodHook, s conversion.Scope) error {
	if in.Command == nil {
		out.Command = make([]string, 0)
	} else {
		out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_v1.EnvVar, len(*in))
		for i := range *in {
			if err := api_v1.Convert_api_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ContainerName = in.ContainerName
	out.Volumes = *(*[]string)(unsafe.Pointer(&in.Volumes))
	return nil
}

// Convert_apps_ExecNewPodHook_To_v1_ExecNewPodHook is an autogenerated conversion function.
func Convert_apps_ExecNewPodHook_To_v1_ExecNewPodHook(in *apps.ExecNewPodHook, out *ExecNewPodHook, s conversion.Scope) error {
	return autoConvert_apps_ExecNewPodHook_To_v1_ExecNewPodHook(in, out, s)
}

func autoConvert_v1_LifecycleHook_To_apps_LifecycleHook(in *LifecycleHook, out *apps.LifecycleHook, s conversion.Scope) error {
	out.FailurePolicy = apps.LifecycleHookFailurePolicy(in.FailurePolicy)
	if in.ExecNewPod != nil {
		in, out := &in.ExecNewPod, &out.ExecNewPod
		*out = new(apps.ExecNewPodHook)
		if err := Convert_v1_ExecNewPodHook_To_apps_ExecNewPodHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExecNewPod = nil
	}
	if in.TagImages != nil {
		in, out := &in.TagImages, &out.TagImages
		*out = make([]apps.TagImageHook, len(*in))
		for i := range *in {
			if err := Convert_v1_TagImageHook_To_apps_TagImageHook(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TagImages = nil
	}
	return nil
}

// Convert_v1_LifecycleHook_To_apps_LifecycleHook is an autogenerated conversion function.
func Convert_v1_LifecycleHook_To_apps_LifecycleHook(in *LifecycleHook, out *apps.LifecycleHook, s conversion.Scope) error {
	return autoConvert_v1_LifecycleHook_To_apps_LifecycleHook(in, out, s)
}

func autoConvert_apps_LifecycleHook_To_v1_LifecycleHook(in *apps.LifecycleHook, out *LifecycleHook, s conversion.Scope) error {
	out.FailurePolicy = LifecycleHookFailurePolicy(in.FailurePolicy)
	if in.ExecNewPod != nil {
		in, out := &in.ExecNewPod, &out.ExecNewPod
		*out = new(ExecNewPodHook)
		if err := Convert_apps_ExecNewPodHook_To_v1_ExecNewPodHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExecNewPod = nil
	}
	if in.TagImages != nil {
		in, out := &in.TagImages, &out.TagImages
		*out = make([]TagImageHook, len(*in))
		for i := range *in {
			if err := Convert_apps_TagImageHook_To_v1_TagImageHook(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TagImages = nil
	}
	return nil
}

// Convert_apps_LifecycleHook_To_v1_LifecycleHook is an autogenerated conversion function.
func Convert_apps_LifecycleHook_To_v1_LifecycleHook(in *apps.LifecycleHook, out *LifecycleHook, s conversion.Scope) error {
	return autoConvert_apps_LifecycleHook_To_v1_LifecycleHook(in, out, s)
}

func autoConvert_v1_RecreateDeploymentStrategyParams_To_apps_RecreateDeploymentStrategyParams(in *RecreateDeploymentStrategyParams, out *apps.RecreateDeploymentStrategyParams, s conversion.Scope) error {
	out.TimeoutSeconds = (*int64)(unsafe.Pointer(in.TimeoutSeconds))
	if in.Pre != nil {
		in, out := &in.Pre, &out.Pre
		*out = new(apps.LifecycleHook)
		if err := Convert_v1_LifecycleHook_To_apps_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Pre = nil
	}
	if in.Mid != nil {
		in, out := &in.Mid, &out.Mid
		*out = new(apps.LifecycleHook)
		if err := Convert_v1_LifecycleHook_To_apps_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Mid = nil
	}
	if in.Post != nil {
		in, out := &in.Post, &out.Post
		*out = new(apps.LifecycleHook)
		if err := Convert_v1_LifecycleHook_To_apps_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Post = nil
	}
	return nil
}

// Convert_v1_RecreateDeploymentStrategyParams_To_apps_RecreateDeploymentStrategyParams is an autogenerated conversion function.
func Convert_v1_RecreateDeploymentStrategyParams_To_apps_RecreateDeploymentStrategyParams(in *RecreateDeploymentStrategyParams, out *apps.RecreateDeploymentStrategyParams, s conversion.Scope) error {
	return autoConvert_v1_RecreateDeploymentStrategyParams_To_apps_RecreateDeploymentStrategyParams(in, out, s)
}

func autoConvert_apps_RecreateDeploymentStrategyParams_To_v1_RecreateDeploymentStrategyParams(in *apps.RecreateDeploymentStrategyParams, out *RecreateDeploymentStrategyParams, s conversion.Scope) error {
	out.TimeoutSeconds = (*int64)(unsafe.Pointer(in.TimeoutSeconds))
	if in.Pre != nil {
		in, out := &in.Pre, &out.Pre
		*out = new(LifecycleHook)
		if err := Convert_apps_LifecycleHook_To_v1_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Pre = nil
	}
	if in.Mid != nil {
		in, out := &in.Mid, &out.Mid
		*out = new(LifecycleHook)
		if err := Convert_apps_LifecycleHook_To_v1_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Mid = nil
	}
	if in.Post != nil {
		in, out := &in.Post, &out.Post
		*out = new(LifecycleHook)
		if err := Convert_apps_LifecycleHook_To_v1_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Post = nil
	}
	return nil
}

// Convert_apps_RecreateDeploymentStrategyParams_To_v1_RecreateDeploymentStrategyParams is an autogenerated conversion function.
func Convert_apps_RecreateDeploymentStrategyParams_To_v1_RecreateDeploymentStrategyParams(in *apps.RecreateDeploymentStrategyParams, out *RecreateDeploymentStrategyParams, s conversion.Scope) error {
	return autoConvert_apps_RecreateDeploymentStrategyParams_To_v1_RecreateDeploymentStrategyParams(in, out, s)
}

func autoConvert_v1_RollingDeploymentStrategyParams_To_apps_RollingDeploymentStrategyParams(in *RollingDeploymentStrategyParams, out *apps.RollingDeploymentStrategyParams, s conversion.Scope) error {
	out.UpdatePeriodSeconds = (*int64)(unsafe.Pointer(in.UpdatePeriodSeconds))
	out.IntervalSeconds = (*int64)(unsafe.Pointer(in.IntervalSeconds))
	out.TimeoutSeconds = (*int64)(unsafe.Pointer(in.TimeoutSeconds))
	// WARNING: in.MaxUnavailable requires manual conversion: inconvertible types (*k8s.io/apimachinery/pkg/util/intstr.IntOrString vs k8s.io/apimachinery/pkg/util/intstr.IntOrString)
	// WARNING: in.MaxSurge requires manual conversion: inconvertible types (*k8s.io/apimachinery/pkg/util/intstr.IntOrString vs k8s.io/apimachinery/pkg/util/intstr.IntOrString)
	if in.Pre != nil {
		in, out := &in.Pre, &out.Pre
		*out = new(apps.LifecycleHook)
		if err := Convert_v1_LifecycleHook_To_apps_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Pre = nil
	}
	if in.Post != nil {
		in, out := &in.Post, &out.Post
		*out = new(apps.LifecycleHook)
		if err := Convert_v1_LifecycleHook_To_apps_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Post = nil
	}
	return nil
}

func autoConvert_apps_RollingDeploymentStrategyParams_To_v1_RollingDeploymentStrategyParams(in *apps.RollingDeploymentStrategyParams, out *RollingDeploymentStrategyParams, s conversion.Scope) error {
	out.UpdatePeriodSeconds = (*int64)(unsafe.Pointer(in.UpdatePeriodSeconds))
	out.IntervalSeconds = (*int64)(unsafe.Pointer(in.IntervalSeconds))
	out.TimeoutSeconds = (*int64)(unsafe.Pointer(in.TimeoutSeconds))
	// WARNING: in.MaxUnavailable requires manual conversion: inconvertible types (k8s.io/apimachinery/pkg/util/intstr.IntOrString vs *k8s.io/apimachinery/pkg/util/intstr.IntOrString)
	// WARNING: in.MaxSurge requires manual conversion: inconvertible types (k8s.io/apimachinery/pkg/util/intstr.IntOrString vs *k8s.io/apimachinery/pkg/util/intstr.IntOrString)
	if in.Pre != nil {
		in, out := &in.Pre, &out.Pre
		*out = new(LifecycleHook)
		if err := Convert_apps_LifecycleHook_To_v1_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Pre = nil
	}
	if in.Post != nil {
		in, out := &in.Post, &out.Post
		*out = new(LifecycleHook)
		if err := Convert_apps_LifecycleHook_To_v1_LifecycleHook(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Post = nil
	}
	return nil
}

func autoConvert_v1_TagImageHook_To_apps_TagImageHook(in *TagImageHook, out *apps.TagImageHook, s conversion.Scope) error {
	out.ContainerName = in.ContainerName
	if err := api_v1.Convert_v1_ObjectReference_To_api_ObjectReference(&in.To, &out.To, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_TagImageHook_To_apps_TagImageHook is an autogenerated conversion function.
func Convert_v1_TagImageHook_To_apps_TagImageHook(in *TagImageHook, out *apps.TagImageHook, s conversion.Scope) error {
	return autoConvert_v1_TagImageHook_To_apps_TagImageHook(in, out, s)
}

func autoConvert_apps_TagImageHook_To_v1_TagImageHook(in *apps.TagImageHook, out *TagImageHook, s conversion.Scope) error {
	out.ContainerName = in.ContainerName
	if err := api_v1.Convert_api_ObjectReference_To_v1_ObjectReference(&in.To, &out.To, s); err != nil {
		return err
	}
	return nil
}

// Convert_apps_TagImageHook_To_v1_TagImageHook is an autogenerated conversion function.
func Convert_apps_TagImageHook_To_v1_TagImageHook(in *apps.TagImageHook, out *TagImageHook, s conversion.Scope) error {
	return autoConvert_apps_TagImageHook_To_v1_TagImageHook(in, out, s)
}
