// This file was automatically generated by informer-gen

package internalversion

import (
	image "github.com/openshift/origin/pkg/image/apis/image"
	internalinterfaces "github.com/openshift/origin/pkg/image/generated/informers/internalversion/internalinterfaces"
	internalclientset "github.com/openshift/origin/pkg/image/generated/internalclientset"
	internalversion "github.com/openshift/origin/pkg/image/generated/listers/image/internalversion"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
	time "time"
)

// ImageInformer provides access to a shared informer and lister for
// Images.
type ImageInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() internalversion.ImageLister
}

type imageInformer struct {
	factory internalinterfaces.SharedInformerFactory
}

func newImageInformer(client internalclientset.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	sharedIndexInformer := cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				return client.Image().Images().List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				return client.Image().Images().Watch(options)
			},
		},
		&image.Image{},
		resyncPeriod,
		cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc},
	)

	return sharedIndexInformer
}

func (f *imageInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&image.Image{}, newImageInformer)
}

func (f *imageInformer) Lister() internalversion.ImageLister {
	return internalversion.NewImageLister(f.Informer().GetIndexer())
}
