// This file was automatically generated by lister-gen

package internalversion

import (
	quota "github.com/openshift/origin/pkg/quota/apis/quota"
	"k8s.io/apimachinery/pkg/api/errors"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterResourceQuotaLister helps list ClusterResourceQuotas.
type ClusterResourceQuotaLister interface {
	// List lists all ClusterResourceQuotas in the indexer.
	List(selector labels.Selector) (ret []*quota.ClusterResourceQuota, err error)
	// Get retrieves the ClusterResourceQuota from the index for a given name.
	Get(name string) (*quota.ClusterResourceQuota, error)
	ClusterResourceQuotaListerExpansion
}

// clusterResourceQuotaLister implements the ClusterResourceQuotaLister interface.
type clusterResourceQuotaLister struct {
	indexer cache.Indexer
}

// NewClusterResourceQuotaLister returns a new ClusterResourceQuotaLister.
func NewClusterResourceQuotaLister(indexer cache.Indexer) ClusterResourceQuotaLister {
	return &clusterResourceQuotaLister{indexer: indexer}
}

// List lists all ClusterResourceQuotas in the indexer.
func (s *clusterResourceQuotaLister) List(selector labels.Selector) (ret []*quota.ClusterResourceQuota, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*quota.ClusterResourceQuota))
	})
	return ret, err
}

// Get retrieves the ClusterResourceQuota from the index for a given name.
func (s *clusterResourceQuotaLister) Get(name string) (*quota.ClusterResourceQuota, error) {
	key := &quota.ClusterResourceQuota{ObjectMeta: v1.ObjectMeta{Name: name}}
	obj, exists, err := s.indexer.Get(key)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(quota.Resource("clusterresourcequota"), name)
	}
	return obj.(*quota.ClusterResourceQuota), nil
}
