// This file was automatically generated by lister-gen

package internalversion

import (
	network "github.com/openshift/origin/pkg/sdn/apis/network"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterNetworkLister helps list ClusterNetworks.
type ClusterNetworkLister interface {
	// List lists all ClusterNetworks in the indexer.
	List(selector labels.Selector) (ret []*network.ClusterNetwork, err error)
	// ClusterNetworks returns an object that can list and get ClusterNetworks.
	ClusterNetworks(namespace string) ClusterNetworkNamespaceLister
	ClusterNetworkListerExpansion
}

// clusterNetworkLister implements the ClusterNetworkLister interface.
type clusterNetworkLister struct {
	indexer cache.Indexer
}

// NewClusterNetworkLister returns a new ClusterNetworkLister.
func NewClusterNetworkLister(indexer cache.Indexer) ClusterNetworkLister {
	return &clusterNetworkLister{indexer: indexer}
}

// List lists all ClusterNetworks in the indexer.
func (s *clusterNetworkLister) List(selector labels.Selector) (ret []*network.ClusterNetwork, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*network.ClusterNetwork))
	})
	return ret, err
}

// ClusterNetworks returns an object that can list and get ClusterNetworks.
func (s *clusterNetworkLister) ClusterNetworks(namespace string) ClusterNetworkNamespaceLister {
	return clusterNetworkNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterNetworkNamespaceLister helps list and get ClusterNetworks.
type ClusterNetworkNamespaceLister interface {
	// List lists all ClusterNetworks in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*network.ClusterNetwork, err error)
	// Get retrieves the ClusterNetwork from the indexer for a given namespace and name.
	Get(name string) (*network.ClusterNetwork, error)
	ClusterNetworkNamespaceListerExpansion
}

// clusterNetworkNamespaceLister implements the ClusterNetworkNamespaceLister
// interface.
type clusterNetworkNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterNetworks in the indexer for a given namespace.
func (s clusterNetworkNamespaceLister) List(selector labels.Selector) (ret []*network.ClusterNetwork, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*network.ClusterNetwork))
	})
	return ret, err
}

// Get retrieves the ClusterNetwork from the indexer for a given namespace and name.
func (s clusterNetworkNamespaceLister) Get(name string) (*network.ClusterNetwork, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(network.Resource("clusternetwork"), name)
	}
	return obj.(*network.ClusterNetwork), nil
}
