// This file was automatically generated by lister-gen

package internalversion

import (
	security "github.com/openshift/origin/pkg/security/apis/security"
	"k8s.io/apimachinery/pkg/api/errors"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SecurityContextConstraintsLister helps list SecurityContextConstraints.
type SecurityContextConstraintsLister interface {
	// List lists all SecurityContextConstraints in the indexer.
	List(selector labels.Selector) (ret []*security.SecurityContextConstraints, err error)
	// Get retrieves the SecurityContextConstraints from the index for a given name.
	Get(name string) (*security.SecurityContextConstraints, error)
	SecurityContextConstraintsListerExpansion
}

// securityContextConstraintsLister implements the SecurityContextConstraintsLister interface.
type securityContextConstraintsLister struct {
	indexer cache.Indexer
}

// NewSecurityContextConstraintsLister returns a new SecurityContextConstraintsLister.
func NewSecurityContextConstraintsLister(indexer cache.Indexer) SecurityContextConstraintsLister {
	return &securityContextConstraintsLister{indexer: indexer}
}

// List lists all SecurityContextConstraints in the indexer.
func (s *securityContextConstraintsLister) List(selector labels.Selector) (ret []*security.SecurityContextConstraints, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*security.SecurityContextConstraints))
	})
	return ret, err
}

// Get retrieves the SecurityContextConstraints from the index for a given name.
func (s *securityContextConstraintsLister) Get(name string) (*security.SecurityContextConstraints, error) {
	key := &security.SecurityContextConstraints{ObjectMeta: v1.ObjectMeta{Name: name}}
	obj, exists, err := s.indexer.Get(key)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(security.Resource("securitycontextconstraints"), name)
	}
	return obj.(*security.SecurityContextConstraints), nil
}
