// This file was automatically generated by lister-gen

package internalversion

import (
	user "github.com/openshift/origin/pkg/user/apis/user"
	"k8s.io/apimachinery/pkg/api/errors"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// IdentityLister helps list Identities.
type IdentityLister interface {
	// List lists all Identities in the indexer.
	List(selector labels.Selector) (ret []*user.Identity, err error)
	// Get retrieves the Identity from the index for a given name.
	Get(name string) (*user.Identity, error)
	IdentityListerExpansion
}

// identityLister implements the IdentityLister interface.
type identityLister struct {
	indexer cache.Indexer
}

// NewIdentityLister returns a new IdentityLister.
func NewIdentityLister(indexer cache.Indexer) IdentityLister {
	return &identityLister{indexer: indexer}
}

// List lists all Identities in the indexer.
func (s *identityLister) List(selector labels.Selector) (ret []*user.Identity, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*user.Identity))
	})
	return ret, err
}

// Get retrieves the Identity from the index for a given name.
func (s *identityLister) Get(name string) (*user.Identity, error) {
	key := &user.Identity{ObjectMeta: v1.ObjectMeta{Name: name}}
	obj, exists, err := s.indexer.Get(key)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(user.Resource("identity"), name)
	}
	return obj.(*user.Identity), nil
}
