/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */

package io.fabric8.activemq.facade;

import javax.management.MBeanServerConnection;


/**
 * A {@link BrokerFacade} which uses a {@link MBeanServerConnection} to communicate with a
 * broker
 */
public class RemoteBrokerFacade extends RemoteBrokerFacadeSupport {

    private final MBeanServerConnection mbeanServerConnection;

    public RemoteBrokerFacade(MBeanServerConnection mbeanServerConnection) {
        this(mbeanServerConnection, null);
    }

    private RemoteBrokerFacade(MBeanServerConnection mbeanServerConnection, String brokerName) {
        super(brokerName);
        this.mbeanServerConnection = mbeanServerConnection;
    }

    @Override
    public BrokerFacade[] getBrokers() throws Exception {
        String[] brokerNames = getBrokerNames();
        BrokerFacade[] rc = new BrokerFacade[brokerNames.length];
        for (int i = 0; i < rc.length; i++) {
            rc[i] = new RemoteBrokerFacade(getMBeanServerConnection(), brokerNames[i]);
        }
        return rc;
    }

    @Override
    protected MBeanServerConnection getMBeanServerConnection() throws Exception {
        return mbeanServerConnection;
    }
}
